/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioAnalogOutputProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BNdioVoltageOutputProxyExt
extends BNdioAnalogOutputProxyExt {
    public static final Property pointType = BNdioVoltageOutputProxyExt.newProperty((int)1, (BValue)BNdioPointTypeEnum.voltageOutput, null);
    public static final Property deviceFacets = BNdioVoltageOutputProxyExt.newProperty((int)1, (BValue)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Type TYPE = Sys.loadType(BNdioVoltageOutputProxyExt.class);
    private boolean pendingValue = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNumericPoint;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    @Override
    public void read() {
        if (!this.pointSynchronized()) {
            return;
        }
        try {
            BStatusNumeric value = this.readNumericValue();
            this.readOk((BStatusValue)value);
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    @Override
    public boolean write(Context cx) {
        if (!Sys.atSteadyState()) {
            this.pendingValue = true;
        }
        if (!this.pointSynchronized()) {
            return false;
        }
        if (this.getWriteValue().getStatus().isNull()) {
            return false;
        }
        float value = (float)((BStatusNumeric)this.getWriteValue()).getValue();
        if (Float.isNaN(value)) {
            return false;
        }
        try {
            this.writeFloatValue(value);
            this.writeOk(this.getWriteValue());
            this.readOk((BStatusValue)new BStatusNumeric((double)value));
            return true;
        }
        catch (Exception e) {
            this.writeFail(e.getMessage());
            return false;
        }
    }

    public void atSteadyState() throws Exception {
        if (this.pendingValue) {
            this.write(null);
        }
    }

    protected BStatusNumeric readNumericValue() throws Exception {
        float value = this.getBoard().readValue(2, this.getAddress());
        this.setRaw((long)value);
        value = value * 10.0f / 4095.0f;
        if (value < 0.0f) {
            value = 0.0f;
        }
        boolean orval = this.getBoard().readOverrideValue(2, this.getAddress());
        BStatusNumeric svalue = new BStatusNumeric((double)value);
        this.getHardwareOverride().evaluate((BStatusValue)svalue, orval);
        return svalue;
    }

    protected void writeFloatValue(float value) throws Exception {
        if (this.getBoard().getAoType(this.getAddress()) != 1) {
            log.error("physical analog out is not voltage type");
            this.writeFail("physical analog out is not voltage type");
            return;
        }
        float max = 10.0f;
        float min = 0.0f;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        int ivalue = (int)(value / max * 4095.0f) & 0xFFF;
        this.getBoard().writeValue(2, this.getAddress(), ivalue);
    }
}

