/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioUniversalInputProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BNdioResistiveInputProxyExt
extends BNdioUniversalInputProxyExt {
    public static final Property pointType = BNdioResistiveInputProxyExt.newProperty((int)1, (BValue)BNdioPointTypeEnum.resistiveInput, null);
    public static final Property deviceFacets = BNdioResistiveInputProxyExt.newProperty((int)1, (BValue)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"ohm")));
    public static final Type TYPE = Sys.loadType(BNdioResistiveInputProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNumericPoint;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    @Override
    public void read() {
        if (!this.pointSynchronized()) {
            return;
        }
        try {
            BStatusNumeric value = this.readNumericValue();
            this.readOk((BStatusValue)value);
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    protected BStatusNumeric readNumericValue() throws Exception {
        float value = this.getBoard().readValue(0, this.getAddress());
        this.setRaw((long)value);
        if (value < 4095.0f) {
            if ((value = value * 10000.0f / (4095.0f - value)) < 0.0f) {
                value = 0.0f;
            }
            if (value > 100000.0f) {
                value = 100000.0f;
            }
        } else {
            value = 100000.0f;
        }
        BStatusNumeric svalue = new BStatusNumeric((double)value);
        return svalue;
    }
}

