/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BNdioProxyExt
extends BProxyExt
implements BIPollable,
NdioConstants,
NdioPlatformServiceConstants {
    public static final Property conversion = BNdioProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"ndio:NdioProxyConversionFE"));
    public static final Property pollFrequency = BNdioProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property pointType = BNdioProxyExt.newProperty((int)0, (BValue)BNdioPointTypeEnum.counterInput, null);
    public static final Property address = BNdioProxyExt.newProperty((int)0, (int)0, null);
    public static final Property previousAddress = BNdioProxyExt.newProperty((int)71, (int)0, null);
    public static final Property synced = BNdioProxyExt.newProperty((int)67, (boolean)false, null);
    public static final Property raw = BNdioProxyExt.newProperty((int)67, (int)0, null);
    public static final Type TYPE = Sys.loadType(BNdioProxyExt.class);
    protected static final Log log = Log.getLog((String)"ndio");
    private boolean configFault = true;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BNdioPointTypeEnum getPointType() {
        return (BNdioPointTypeEnum)this.get(pointType);
    }

    public void setPointType(BNdioPointTypeEnum v) {
        this.set(pointType, (BValue)v, null);
    }

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    public int getPreviousAddress() {
        return this.getInt(previousAddress);
    }

    public void setPreviousAddress(int v) {
        this.setInt(previousAddress, v, null);
    }

    public boolean getSynced() {
        return this.getBoolean(synced);
    }

    public void setSynced(boolean v) {
        this.setBoolean(synced, v, null);
    }

    public long getRaw() {
        return this.getLong(raw);
    }

    public void setRaw(long v) {
        this.setLong(raw, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint() != null) {
            this.getNdioPointDeviceExt().handlePointChanged(this.getParentPoint());
        }
        this.setPreviousAddress(this.getAddress());
    }

    public void readSubscribed(Context cx) throws Exception {
        BNdioNetwork network = this.getNdioNetwork();
        network.getPollScheduler().subscribe(this);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        BNdioNetwork network = this.getNdioNetwork();
        network.getPollScheduler().unsubscribe(this);
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BControlPoint) {
            return parent.getParent() instanceof BNdioPointDeviceExt;
        }
        return false;
    }

    public Type getDeviceExtType() {
        return BNdioPointDeviceExt.TYPE;
    }

    protected BNdioBoard getBoard() {
        return (BNdioBoard)this.getDevice();
    }

    protected BNdioNetwork getNdioNetwork() {
        return (BNdioNetwork)this.getNetwork();
    }

    protected BNdioPointDeviceExt getNdioPointDeviceExt() {
        return (BNdioPointDeviceExt)this.getDeviceExt();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && prop.equals(address) && this.getParentPoint() != null) {
            this.getNdioPointDeviceExt().handlePointChanged(this.getParentPoint());
            this.setPreviousAddress(this.getAddress());
            if (!this.isConfigFault()) {
                this.read();
            }
        }
    }

    public abstract void read();

    public boolean write(Context cx) {
        return false;
    }

    public void configFail(String cause) {
        this.setSynced(false);
        this.configFault = true;
        this.readFail(cause);
    }

    public void configOk() {
        this.configFault = false;
        this.readReset();
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    public abstract BNdioIoTypeEnum getIoType();

    protected boolean pointSynchronized() {
        if (!this.getNdioNetwork().isKeepAliveStarted()) {
            return false;
        }
        if (this.getBoard().isDown()) {
            return false;
        }
        if (this.getBoard().isFault()) {
            return false;
        }
        if (this.isFatalFault()) {
            return false;
        }
        if (this.isConfigFault()) {
            return false;
        }
        if (this.getSynced()) {
            return true;
        }
        this.setSynced(true);
        return true;
    }
}

