/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.learn.BNdioPointDiscoveryJob;
import com.tridium.ndio.point.BNdioPointFolder;
import com.tridium.ndio.point.BNdioProxyExt;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNdioPointDeviceExt
extends BPointDeviceExt {
    public static final Action submitDiscoveryJob = BNdioPointDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNdioPointDeviceExt.class);
    protected static final Log log = Log.getLog((String)"ndio");

    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNdioBoard;
    }

    public Type getProxyExtType() {
        return BNdioProxyExt.TYPE;
    }

    public Type getDeviceType() {
        return BNdioBoard.TYPE;
    }

    public Type getPointFolderType() {
        return BNdioPointFolder.TYPE;
    }

    public BNdioBoard getBoard() {
        return (BNdioBoard)this.getDevice();
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (this.isRunning() && property.getType().is(BControlPoint.TYPE)) {
            this.handlePointAdded((BControlPoint)this.get(property));
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (this.isRunning() && property.getType().is(BControlPoint.TYPE)) {
            this.handlePointRemoved((BControlPoint)oldValue);
        }
    }

    public void handlePointChanged(BControlPoint point) {
        log.trace("handle point changed for " + point.getName());
        BNdioProxyExt ext = (BNdioProxyExt)point.getProxyExt();
        ext.setSynced(false);
        if (this.checkInvalidPoint(point, ext.getAddress())) {
            if (this.checkDuplicatePoint(point, ext.getAddress())) {
                ext.configOk();
            }
        } else {
            this.checkDuplicatePoint(point, ext.getAddress());
        }
    }

    public void handlePointAdded(BControlPoint point) {
        if (point.getProxyExt() instanceof BNdioProxyExt) {
            log.trace("handle point added for " + point.getName());
            BNdioProxyExt ext = (BNdioProxyExt)point.getProxyExt();
            if (this.checkInvalidPoint(point, ext.getAddress()) && this.checkDuplicatePoint(point, ext.getAddress())) {
                ext.configOk();
            }
        }
    }

    public void handlePointRemoved(BControlPoint point) {
        if (point.getProxyExt() instanceof BNdioProxyExt) {
            log.trace("handle point removed for " + point.getName());
            BNdioProxyExt ext = (BNdioProxyExt)point.getProxyExt();
            this.checkDuplicatePointCleared(point, ext.getAddress());
        }
    }

    private boolean checkInvalidPoint(BControlPoint point, int addr) {
        BNdioProxyExt ext = (BNdioProxyExt)point.getProxyExt();
        if (addr > this.getBoard().getCount(ext.getIoType().getOrdinal()) || addr < 1) {
            ext.configFail("invalid address provided (1 <= addr <= " + this.getBoard().getCount(ext.getIoType().getOrdinal()) + ")");
            return false;
        }
        return true;
    }

    private boolean checkDuplicatePoint(BControlPoint point, int addr) {
        boolean dupFound = false;
        BNdioProxyExt ext = (BNdioProxyExt)point.getProxyExt();
        this.checkDuplicatePointCleared(point, ext.getPreviousAddress());
        BControlPoint[] points = this.getDeviceExt().getPoints();
        for (int i = 0; i < points.length; ++i) {
            BNdioProxyExt pext = (BNdioProxyExt)points[i].getProxyExt();
            if (pext.getIoType() != ext.getIoType() || pext == ext || pext.getAddress() != addr) continue;
            dupFound = true;
            pext.configFail("duplicate address: addresses must be unique/type");
        }
        if (dupFound) {
            ext.configFail("duplicate address: addresses must be unique/type");
            return false;
        }
        return true;
    }

    private void checkDuplicatePointCleared(BControlPoint point, int addr) {
        BNdioProxyExt ext = (BNdioProxyExt)point.getProxyExt();
        BControlPoint[] points = this.getDeviceExt().getPoints();
        if (addr != 0) {
            BControlPoint ipoint;
            BNdioProxyExt pext;
            ArrayList<BControlPoint> list = new ArrayList<BControlPoint>(points.length);
            for (int i = 0; i < points.length; ++i) {
                pext = (BNdioProxyExt)points[i].getProxyExt();
                if (pext.getIoType() != ext.getIoType() || pext == ext || pext.getAddress() != addr) continue;
                list.add(points[i]);
            }
            if (list.size() == 1 && this.checkInvalidPoint(ipoint = (BControlPoint)list.get(0), (pext = (BNdioProxyExt)ipoint.getProxyExt()).getAddress())) {
                pext.configOk();
            }
            list = null;
        }
    }

    public void resetPoints() {
        BControlPoint[] points = this.getPoints();
        for (int i = 0; i < points.length; ++i) {
            this.handlePointChanged(points[i]);
        }
    }

    public BOrd doSubmitDiscoveryJob(Context cx) {
        return new BNdioPointDiscoveryJob(this).submit(cx);
    }
}

