/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.learn;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioProperties;
import com.tridium.platNdio.BNdioPlatformService;
import java.util.Properties;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNdioBoardEntry
extends BComponent
implements NdioConstants {
    public static final Property ioPort = BNdioBoardEntry.newProperty((int)3, (int)-1, null);
    public static final Property multipleProcessors = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Property firmwareVersion = BNdioBoardEntry.newProperty((int)3, (String)"-", null);
    public static final Property configCode = BNdioBoardEntry.newProperty((int)3, (String)"-", null);
    public static final Property uiCount = BNdioBoardEntry.newProperty((int)3, (int)0, null);
    public static final Property boCount = BNdioBoardEntry.newProperty((int)3, (int)0, null);
    public static final Property aoCount = BNdioBoardEntry.newProperty((int)3, (int)0, null);
    public static final Property uiBiEnabled = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Property uiHsEnabled = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Property uiThEnabled = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Property uiPlEnabled = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Property uiVEnabled = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Property uiMaEnabled = BNdioBoardEntry.newProperty((int)3, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BNdioBoardEntry.class);
    private static Properties ndioProps = null;
    public static Log log = Log.getLog((String)"ndio");

    public int getIoPort() {
        return this.getInt(ioPort);
    }

    public void setIoPort(int v) {
        this.setInt(ioPort, v, null);
    }

    public boolean getMultipleProcessors() {
        return this.getBoolean(multipleProcessors);
    }

    public void setMultipleProcessors(boolean v) {
        this.setBoolean(multipleProcessors, v, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String v) {
        this.setString(firmwareVersion, v, null);
    }

    public String getConfigCode() {
        return this.getString(configCode);
    }

    public void setConfigCode(String v) {
        this.setString(configCode, v, null);
    }

    public int getUiCount() {
        return this.getInt(uiCount);
    }

    public void setUiCount(int v) {
        this.setInt(uiCount, v, null);
    }

    public int getBoCount() {
        return this.getInt(boCount);
    }

    public void setBoCount(int v) {
        this.setInt(boCount, v, null);
    }

    public int getAoCount() {
        return this.getInt(aoCount);
    }

    public void setAoCount(int v) {
        this.setInt(aoCount, v, null);
    }

    public boolean getUiBiEnabled() {
        return this.getBoolean(uiBiEnabled);
    }

    public void setUiBiEnabled(boolean v) {
        this.setBoolean(uiBiEnabled, v, null);
    }

    public boolean getUiHsEnabled() {
        return this.getBoolean(uiHsEnabled);
    }

    public void setUiHsEnabled(boolean v) {
        this.setBoolean(uiHsEnabled, v, null);
    }

    public boolean getUiThEnabled() {
        return this.getBoolean(uiThEnabled);
    }

    public void setUiThEnabled(boolean v) {
        this.setBoolean(uiThEnabled, v, null);
    }

    public boolean getUiPlEnabled() {
        return this.getBoolean(uiPlEnabled);
    }

    public void setUiPlEnabled(boolean v) {
        this.setBoolean(uiPlEnabled, v, null);
    }

    public boolean getUiVEnabled() {
        return this.getBoolean(uiVEnabled);
    }

    public void setUiVEnabled(boolean v) {
        this.setBoolean(uiVEnabled, v, null);
    }

    public boolean getUiMaEnabled() {
        return this.getBoolean(uiMaEnabled);
    }

    public void setUiMaEnabled(boolean v) {
        this.setBoolean(uiMaEnabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNdioBoardEntry() {
    }

    public BNdioBoardEntry(int ioPort) {
        this.setIoPort(ioPort);
        this.readInfo();
    }

    private void readInfo() {
        String firmware = "";
        String config = "";
        int code0 = 0;
        int code1 = 0;
        BNdioPlatformService platSvc = BNdioNetwork.getPlatformService();
        if (platSvc == null) {
            log.error("Unable to find NdioPlatformService.");
            return;
        }
        int port = this.getIoPort();
        int hdwrAddr = IO_PORT_TO_PROC_0[port];
        NdioProperties props = NdioProperties.DEFAULT;
        try {
            int intf = platSvc.getFirmwareIntfNum(hdwrAddr);
            int build = platSvc.getFirmwareBuildNum(hdwrAddr);
            firmware = intf + "." + build;
            code0 = platSvc.readConfigCode(hdwrAddr);
            config = Integer.toString(code0);
            props = NdioProperties.make(code0);
            this.setMultipleProcessors(props.getMultipleProcessors());
            if (this.getMultipleProcessors()) {
                hdwrAddr = IO_PORT_TO_PROC_1[port];
                intf = platSvc.getFirmwareIntfNum(hdwrAddr);
                build = platSvc.getFirmwareBuildNum(hdwrAddr);
                firmware = firmware + "/" + intf + "." + build;
                code1 = platSvc.readConfigCode(hdwrAddr);
                config = config + "/" + Integer.toString(code1);
            }
            this.setFirmwareVersion(firmware);
            this.setConfigCode(config);
        }
        catch (Exception e) {
            log.error("Unable to readInfo for board entry", (Throwable)e);
            this.setFirmwareVersion("-");
            this.setConfigCode("-");
        }
        this.setUiCount(props.getUiCount());
        this.setAoCount(props.getAoCount());
        this.setBoCount(props.getBoCount());
        this.setUiBiEnabled(props.getUiBiEnabled());
        this.setUiHsEnabled(props.getUiHsEnabled());
        this.setUiThEnabled(props.getUiThEnabled());
        this.setUiPlEnabled(props.getUiPlEnabled());
        this.setUiVEnabled(props.getUiVEnabled());
        this.setUiMaEnabled(props.getUiMaEnabled());
        props = NdioProperties.make(code1);
        this.setUiCount(props.getUiCount() + this.getUiCount());
        this.setAoCount(props.getAoCount() + this.getAoCount());
        this.setBoCount(props.getBoCount() + this.getBoCount());
        this.setUiBiEnabled(props.getUiBiEnabled() || this.getUiBiEnabled());
        this.setUiHsEnabled(props.getUiHsEnabled() || this.getUiHsEnabled());
        this.setUiThEnabled(props.getUiThEnabled() || this.getUiThEnabled());
        this.setUiPlEnabled(props.getUiPlEnabled() || this.getUiPlEnabled());
        this.setUiVEnabled(props.getUiVEnabled() || this.getUiVEnabled());
        this.setUiMaEnabled(props.getUiMaEnabled() || this.getUiMaEnabled());
    }

    public boolean is(BComponent component) {
        BNdioBoard board;
        return component instanceof BNdioBoard && (board = (BNdioBoard)component).getIoPort() == this.getIoPort();
    }
}

