/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BINdioRebootable;
import com.tridium.ndio.BNdioBoardFolder;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioProcessor;
import com.tridium.ndio.NdioRebootException;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.platNdio.BNdioPlatformService;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import java.util.Properties;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

public class BNdioBoard
extends BDevice
implements BINdioRebootable,
NdioConstants,
NdioPlatformServiceConstants {
    public static final Property ioPort = BNdioBoard.newProperty((int)0, (int)0, null);
    public static final Property previousIoPort = BNdioBoard.newProperty((int)71, (int)0, null);
    public static final Property multipleProcessors = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property firmwareVersion = BNdioBoard.newProperty((int)3, (String)"-", null);
    public static final Property configCode = BNdioBoard.newProperty((int)3, (String)"-", null);
    public static final Property calibrated = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiCount = BNdioBoard.newProperty((int)3, (int)0, null);
    public static final Property boCount = BNdioBoard.newProperty((int)3, (int)0, null);
    public static final Property aoCount = BNdioBoard.newProperty((int)3, (int)0, null);
    public static final Property uiBiEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiHsEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiThEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiPlEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiVEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiMaEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property points = BNdioBoard.newProperty((int)0, (BValue)new BNdioPointDeviceExt(), null);
    public static final Property rebootConditionMet = BNdioBoard.newProperty((int)71, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BNdioBoard.class);
    private static Properties ndioProps = null;
    private static final Log log = Log.getLog((String)"ndio");
    public static int PING_OK = 0;
    public static int PING_FAILED_DAEMON = 1;
    public static int PING_FAILED_EXCEPTION = 3;
    private NdioProcessor proc0 = new NdioProcessor();
    private NdioProcessor proc1 = new NdioProcessor();
    private int pingState = PING_OK;

    public int getIoPort() {
        return this.getInt(ioPort);
    }

    public void setIoPort(int v) {
        this.setInt(ioPort, v, null);
    }

    public int getPreviousIoPort() {
        return this.getInt(previousIoPort);
    }

    public void setPreviousIoPort(int v) {
        this.setInt(previousIoPort, v, null);
    }

    public boolean getMultipleProcessors() {
        return this.getBoolean(multipleProcessors);
    }

    public void setMultipleProcessors(boolean v) {
        this.setBoolean(multipleProcessors, v, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String v) {
        this.setString(firmwareVersion, v, null);
    }

    public String getConfigCode() {
        return this.getString(configCode);
    }

    public void setConfigCode(String v) {
        this.setString(configCode, v, null);
    }

    public boolean getCalibrated() {
        return this.getBoolean(calibrated);
    }

    public void setCalibrated(boolean v) {
        this.setBoolean(calibrated, v, null);
    }

    public int getUiCount() {
        return this.getInt(uiCount);
    }

    public void setUiCount(int v) {
        this.setInt(uiCount, v, null);
    }

    public int getBoCount() {
        return this.getInt(boCount);
    }

    public void setBoCount(int v) {
        this.setInt(boCount, v, null);
    }

    public int getAoCount() {
        return this.getInt(aoCount);
    }

    public void setAoCount(int v) {
        this.setInt(aoCount, v, null);
    }

    public boolean getUiBiEnabled() {
        return this.getBoolean(uiBiEnabled);
    }

    public void setUiBiEnabled(boolean v) {
        this.setBoolean(uiBiEnabled, v, null);
    }

    public boolean getUiHsEnabled() {
        return this.getBoolean(uiHsEnabled);
    }

    public void setUiHsEnabled(boolean v) {
        this.setBoolean(uiHsEnabled, v, null);
    }

    public boolean getUiThEnabled() {
        return this.getBoolean(uiThEnabled);
    }

    public void setUiThEnabled(boolean v) {
        this.setBoolean(uiThEnabled, v, null);
    }

    public boolean getUiPlEnabled() {
        return this.getBoolean(uiPlEnabled);
    }

    public void setUiPlEnabled(boolean v) {
        this.setBoolean(uiPlEnabled, v, null);
    }

    public boolean getUiVEnabled() {
        return this.getBoolean(uiVEnabled);
    }

    public void setUiVEnabled(boolean v) {
        this.setBoolean(uiVEnabled, v, null);
    }

    public boolean getUiMaEnabled() {
        return this.getBoolean(uiMaEnabled);
    }

    public void setUiMaEnabled(boolean v) {
        this.setBoolean(uiMaEnabled, v, null);
    }

    public BNdioPointDeviceExt getPoints() {
        return (BNdioPointDeviceExt)this.get(points);
    }

    public void setPoints(BNdioPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    public boolean getRebootConditionMet() {
        return this.getBoolean(rebootConditionMet);
    }

    public void setRebootConditionMet(boolean v) {
        this.setBoolean(rebootConditionMet, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getNdioNetwork().handleBoardChanged(this);
        this.setPreviousIoPort(this.getIoPort());
        this.doPing();
    }

    public Type getNetworkType() {
        return BNdioNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNdioNetwork || parent instanceof BNdioBoardFolder;
    }

    public void spy(SpyWriter out) throws Exception {
        BNdioPlatformService platSvc = BNdioNetwork.getPlatformService();
        try {
            if (platSvc.isDaemonOk() && this.getIoPort() > 0 && this.getIoPort() < 4) {
                this.processorSpyProps(out, IO_PORT_TO_PROC_0[this.getIoPort()]);
                if (this.getMultipleProcessors()) {
                    this.processorSpyProps(out, IO_PORT_TO_PROC_1[this.getIoPort()]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.spy(out);
    }

    private void processorSpyProps(SpyWriter out, int addr) throws Exception {
        BNdioPlatformService platSvc = BNdioNetwork.getPlatformService();
        out.startProps();
        out.trTitle((Object)("Ndio Processor " + addr + "Extra Properties"), 2);
        int ioType = 0;
        int ioConfigState = 0;
        try {
            ioType = platSvc.readIoType(addr);
            ioConfigState = platSvc.readIoConfigState(addr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ioType != 0 && ioConfigState != 0 && ioConfigState != 1) {
            int j;
            out.prop((Object)"firstReadTicks", (Object)String.valueOf(platSvc.getFirstReadTicks(addr)));
            out.prop((Object)"ioBoardType", ioType);
            out.prop((Object)"ioFirmware", (Object)(platSvc.getFirmwareIntfNum(addr) + "." + platSvc.getFirmwareBuildNum(addr)));
            out.prop((Object)"configCode", platSvc.readConfigCode(addr) & 0xFFFFFF);
            out.prop((Object)"ioConfigState", ioConfigState);
            out.prop((Object)"calibrated", platSvc.isProcessorCalibrated(addr));
            out.prop((Object)"successTicks", (Object)String.valueOf(platSvc.getSuccessTicks(addr)));
            StringBuffer buf = new StringBuffer();
            for (j = 0; j < 8; ++j) {
                buf.append("[").append(platSvc.readUIType(addr, j)).append("]");
            }
            out.prop((Object)"definitionUIs", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 8; ++j) {
                buf.append("[").append(platSvc.readValue(addr, 0, j)).append("]");
            }
            out.prop((Object)"uiInValues", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 8; ++j) {
                buf.append("[").append(platSvc.readUICount(addr, j)).append("]");
            }
            out.prop((Object)"uiInCounts", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 16; ++j) {
                buf.append("[").append(platSvc.readValue(addr, 1, j)).append("]");
            }
            out.prop((Object)"ovrInValues", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 16; ++j) {
                buf.append("[").append(platSvc.readValue(addr, 3, j)).append("]");
            }
            out.prop((Object)"doInValues", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 16; ++j) {
                buf.append("[").append(platSvc.readOutValue(addr, 3, j)).append("]");
            }
            out.prop((Object)"doOutValues", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 4; ++j) {
                buf.append("[").append(platSvc.readValue(addr, 2, j)).append("]");
            }
            out.prop((Object)"aoInValues", (Object)buf.toString());
            buf = new StringBuffer();
            for (j = 0; j < 4; ++j) {
                buf.append("[").append(platSvc.readOutValue(addr, 2, j)).append("]");
            }
            out.prop((Object)"aoOutValues", (Object)buf.toString());
        } else {
            out.prop((Object)"state", (Object)"undefined");
        }
        out.endProps();
    }

    public BNdioNetwork getNdioNetwork() {
        return (BNdioNetwork)this.getNetwork();
    }

    protected IFuture postPing() {
        try {
            this.doPing();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized void doPing() {
        block11: {
            if (!Sys.atSteadyState()) {
                return;
            }
            if (this.isConfigFault() || this.isFatalFault()) {
                return;
            }
            log.trace("pinging board @ " + this.getIoPort());
            if (BNdioNetwork.getPlatformService() != null) {
                if (!BNdioNetwork.getPlatformService().isDaemonOk()) {
                    if (this.getNdioNetwork().hadSuccessfulPing()) {
                        this.setRebootConditionMet(true);
                    }
                    this.pingFail("board @ " + this.getIoPort() + " failed because it couldn't find ndio daemon");
                    if (this.pingState != PING_FAILED_DAEMON) {
                        log.error("board @ " + this.getIoPort() + " failed because it couldn't find ndio daemon");
                        this.pingState = PING_FAILED_DAEMON;
                    }
                    return;
                }
                try {
                    this.proc0.ping();
                    if (this.getMultipleProcessors()) {
                        this.proc1.ping();
                    }
                    this.pingOk();
                    this.pingState = PING_OK;
                }
                catch (NdioRebootException n) {
                    this.setRebootConditionMet(true);
                    this.pingFail(n.getMessage());
                    if (this.pingState != PING_FAILED_EXCEPTION) {
                        log.error(n.getMessage());
                        this.pingState = PING_FAILED_EXCEPTION;
                    }
                }
                catch (Exception n) {
                    this.pingFail(n.getMessage());
                    if (this.pingState == PING_FAILED_EXCEPTION) break block11;
                    log.error(n.getMessage());
                    this.pingState = PING_FAILED_EXCEPTION;
                }
            }
        }
    }

    public int getCount(int type) {
        switch (type) {
            case 0: {
                return this.getUiCount();
            }
            case 2: {
                return this.getAoCount();
            }
            case 3: {
                return this.getBoCount();
            }
        }
        return 0;
    }

    public int getAoType(int index) {
        int count = this.proc0.getAoCount();
        if (index > count) {
            return this.proc1.getAoType(index -= count);
        }
        return this.proc0.getAoType(index);
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning() && BNdioNetwork.getPlatformService() != null && prop == ioPort) {
            this.getNdioNetwork().handleBoardChanged(this);
            this.getPoints().resetPoints();
            this.setPreviousIoPort(this.getIoPort());
            if (!this.isConfigFault()) {
                try {
                    this.doPing();
                }
                catch (Exception e) {
                    log.error("deviceChanged: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int readUIType(int index) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getUiCount()) {
            proc = this.proc1;
            index -= this.proc0.getUiCount();
        } else {
            proc = this.proc0;
        }
        return proc.readUIType(index);
    }

    public void writeUIType(int index, int subtype) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getUiCount()) {
            proc = this.proc1;
            index -= this.proc0.getUiCount();
        } else {
            proc = this.proc0;
        }
        proc.writeUIType(index, subtype);
    }

    public int readValue(int type, int index) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getCount(type)) {
            proc = this.proc1;
            index -= this.proc0.getCount(type);
        } else {
            proc = this.proc0;
        }
        return proc.readValue(type, index);
    }

    public boolean readOverrideValue(int type, int index) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getCount(type)) {
            proc = this.proc1;
            index -= this.proc0.getCount(type);
        } else {
            proc = this.proc0;
        }
        int orindex = 0;
        switch (type) {
            case 3: {
                orindex = proc.getDoOverrideMap(index);
                break;
            }
            case 2: {
                orindex = proc.getAoOverrideMap(index);
                break;
            }
            default: {
                return false;
            }
        }
        int value = proc.readValue(1, orindex);
        boolean orval = value == 0;
        return orval;
    }

    public void writeValue(int type, int index, int value) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getCount(type)) {
            proc = this.proc1;
            index -= this.proc0.getCount(type);
        } else {
            proc = this.proc0;
        }
        proc.writeValue(type, index, value);
    }

    public long readUICount(int index) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getUiCount()) {
            proc = this.proc1;
            index -= this.proc0.getUiCount();
        } else {
            proc = this.proc0;
        }
        return proc.readUICount(index);
    }

    public long readUICountDelta(int index) throws Exception {
        NdioProcessor proc;
        if (index > this.proc0.getUiCount()) {
            proc = this.proc1;
            index -= this.proc0.getUiCount();
        } else {
            proc = this.proc0;
        }
        return proc.readUICountDelta(index);
    }

    public void initDevice() {
        if (BNdioNetwork.getPlatformService() != null) {
            try {
                this.proc0 = new NdioProcessor(this.getIoPort(), true);
                boolean calib = BNdioNetwork.getPlatformService().isProcessorCalibrated(this.proc0.getHdwrAddress());
                int configCode = BNdioNetwork.getPlatformService().readConfigCode(this.proc0.getHdwrAddress());
                this.setMultipleProcessors(this.proc0.getMultipleProcessors());
                if (this.getMultipleProcessors()) {
                    this.proc1 = new NdioProcessor(this.getIoPort(), false);
                    calib &= BNdioNetwork.getPlatformService().isProcessorCalibrated(this.proc1.getHdwrAddress());
                    this.setFirmwareVersion(this.proc0.getFirmwareVersion() + "/" + this.proc1.getFirmwareVersion());
                    this.setConfigCode(String.valueOf(this.proc0.getConfigCode()) + "/" + String.valueOf(this.proc1.getConfigCode()));
                } else {
                    this.proc1 = new NdioProcessor();
                    this.setFirmwareVersion(this.proc0.getFirmwareVersion());
                    this.setConfigCode(String.valueOf(this.proc0.getConfigCode()));
                }
                this.setCalibrated(calib);
                this.setUiCount(this.proc0.getUiCount() + this.proc1.getUiCount());
                this.setBoCount(this.proc0.getBoCount() + this.proc1.getBoCount());
                this.setAoCount(this.proc0.getAoCount() + this.proc1.getAoCount());
                this.setUiBiEnabled(this.proc0.getUiBiEnabled() | this.proc1.getUiBiEnabled());
                this.setUiHsEnabled(this.proc0.getUiHsEnabled() | this.proc1.getUiHsEnabled());
                this.setUiThEnabled(this.proc0.getUiThEnabled() | this.proc1.getUiThEnabled());
                this.setUiPlEnabled(this.proc0.getUiPlEnabled() | this.proc1.getUiPlEnabled());
                this.setUiVEnabled(this.proc0.getUiVEnabled() | this.proc1.getUiVEnabled());
                this.setUiMaEnabled(this.proc0.getUiMaEnabled() | this.proc1.getUiMaEnabled());
            }
            catch (Exception e) {
                log.error("Unable to init ndio device at ioPort <" + this.getIoPort() + ">");
                this.proc1 = new NdioProcessor(this.getIoPort(), false);
            }
        }
    }

    private void resetDevice() {
        this.setMultipleProcessors(false);
        this.setFirmwareVersion("-");
        this.setConfigCode("-");
        this.setCalibrated(false);
        this.setUiCount(0);
        this.setBoCount(0);
        this.setAoCount(0);
        this.setUiBiEnabled(false);
        this.setUiHsEnabled(false);
        this.setUiThEnabled(false);
        this.setUiPlEnabled(false);
        this.setUiVEnabled(false);
        this.setUiMaEnabled(false);
    }

    public boolean isConfigFault() {
        return this.isFault() && !this.isFatalFault() && !this.getNetwork().isFault();
    }
}

