/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSystemDbScheme
extends BOrdScheme {
    static final SystemDbQuery QUERY = new SystemDbQuery();
    public static final BSystemDbScheme INSTANCE = new BSystemDbScheme();
    public static final Type TYPE = Sys.loadType(BSystemDbScheme.class);

    private BSystemDbScheme() {
        super("sys");
    }

    public OrdQuery parse(String queryBody) {
        return QUERY;
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BSystemDbService service;
        BFacets facets = null;
        BObject baseObj = base.get();
        if (baseObj.isComponent()) {
            if (!baseObj.getType().is(BSystemDb.TYPE) && !(baseObj.asComponent().getSession() instanceof BFoxSession)) {
                facets = BFacets.make((String)"alternateQueryScope", (String)baseObj.asComponent().getNavOrd().toString());
            }
        } else {
            BINavNode navChild;
            BISession session;
            BSpace space = base.getSpace();
            if (space == null && (session = BOrd.toSession((BObject)baseObj)) != null && (navChild = session.getNavChild("station")) instanceof BComponentSpace) {
                space = navChild.asObject();
            }
            baseObj = space;
        }
        if (!(service = (BSystemDbService)BOrd.make((String)"service:systemDb:SystemDbService").get(baseObj)).isRunning()) {
            service.lease();
        }
        OrdTarget result = OrdTarget.makeWithFacets((OrdTarget)base, (BObject)service.getSystemDatabase(), (BFacets)facets);
        return result;
    }

    public Type getType() {
        return TYPE;
    }

    static class SystemDbQuery
    implements OrdQuery {
        SystemDbQuery() {
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return false;
        }

        public void normalize(OrdQueryList list, int index) {
            if (list.isSameScheme(index, index + 1)) {
                list.remove(index);
            }
        }

        public String getScheme() {
            return "sys";
        }

        public String getBody() {
            return "";
        }

        public String toString() {
            return "sys:";
        }
    }
}

