/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.station.BStationScheme;
import com.tridium.systemDb.BInactiveSystemDb;
import com.tridium.systemDb.BSystemDbDeleteJob;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemDb.SystemDbConnection;
import com.tridium.util.ArrayUtil;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.neql.BNeqlScheme;
import javax.baja.neql.NeqlQuery;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.query.BQueryScheme;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BIStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.user.BUser;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.CloseableIterator;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="startDatabase", flags=16), @NiagaraAction(name="stopDatabase", flags=16), @NiagaraAction(name="deleteStationRecords", flags=128, parameterType="BString", defaultValue="BString.make(\"\")", returnType="BOrd"), @NiagaraAction(name="deleteAllRecords", flags=128, returnType="BOrd")})
public abstract class BSystemDb
extends BComponent
implements BIRestrictedComponent,
BIQueryHandler {
    public static final Action startDatabase = BSystemDb.newAction((int)16, null);
    public static final Action stopDatabase = BSystemDb.newAction((int)16, null);
    public static final Action deleteStationRecords = BSystemDb.newAction((int)128, (BValue)BString.make((String)""), null);
    public static final Action deleteAllRecords = BSystemDb.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BSystemDb.class);
    private static final BIcon icon = BIcon.std((String)"database.png");
    private static final Lexicon LEXICON = Lexicon.make(BSystemDb.class);
    private static final String UNLICENSED_TYPE = LEXICON.get("systemDb.error.typeUnlicensed");
    public static final String LIGHTWEIGHT_QUERY_RESULTS_FACET_KEY = "lightweightSystemDbQueryResults";
    private static final String INCLUDE_LIGHTWEIGHT_RELATIONS_KEY = "includeLightweightRelations";
    private static final Permission systemIndexCxPermission = new NiagaraBasicPermission("NIAGARA_SYSTEM_INDEX");
    private static final Context systemIndexContext = new BasicContext();
    private final AtomicInteger fatalFault = new AtomicInteger(-1);
    private final AtomicBoolean purgeCheckComplete = new AtomicBoolean();
    protected static final Logger LOGGER = Logger.getLogger("systemDb");

    public void startDatabase() {
        this.invoke(startDatabase, null, null);
    }

    public void stopDatabase() {
        this.invoke(stopDatabase, null, null);
    }

    public BOrd deleteStationRecords(BString parameter) {
        return (BOrd)this.invoke(deleteStationRecords, (BValue)parameter, null);
    }

    public BOrd deleteAllRecords() {
        return (BOrd)this.invoke(deleteAllRecords, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract SystemDbConnection makeConnection(Context var1) throws Exception;

    protected abstract void initializeDbServer() throws Exception;

    protected abstract void shutdownDbServer() throws Exception;

    protected abstract boolean isDbServerRunning() throws UnsupportedOperationException;

    public final void doStartDatabase() throws Exception {
        if (this.getSystemDbService().isDisabled() || this.isFatalFault() || this.isDbServerRunning()) {
            return;
        }
        try {
            this.initializeDbServer();
            this.getSystemDbService().pingOk();
            this.getSystemDbService().setFaultCause("");
            this.purgeUnlicensedDatabaseRecords();
        }
        catch (Exception e) {
            this.getSystemDbService().handleDbFailure(e, BSystemDbService.START_FAIL, false);
            throw e;
        }
    }

    public final void doStopDatabase() throws Exception {
        try {
            if (this.isDbServerRunning() && !this.purgeCheckComplete.get()) {
                LOGGER.info(() -> "Waiting for purge check to complete before stopping System Database...");
                long startTicks = Clock.ticks();
                while (!this.purgeCheckComplete.get() && Clock.ticks() - startTicks < 30000L) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                LOGGER.info(() -> "Finished wait for purge check; proceeding to stop System Database.");
            }
            this.shutdownDbServer();
            if (!this.isFatalFault()) {
                this.getSystemDbService().setFaultCause("");
                if (!this.getSystemDbService().isDisabled()) {
                    this.getSystemDbService().getHealth().setDown(true);
                    this.getSystemDbService().updateStatus();
                }
            }
        }
        catch (Exception e) {
            if (!this.isFatalFault()) {
                if (!this.getSystemDbService().isDisabled()) {
                    this.getSystemDbService().getHealth().setDown(true);
                    this.getSystemDbService().updateStatus();
                }
                this.getSystemDbService().handleDbFailure(e, BSystemDbService.STOP_FAIL, false);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFatalFault() {
        int fatalFaultVal;
        block9: {
            if (!Sys.isStation()) {
                return false;
            }
            fatalFaultVal = this.fatalFault.get();
            if (fatalFaultVal < 0) {
                try {
                    BSystemDbService systemDbService = this.getSystemDbService();
                    if (systemDbService != null && systemDbService.isFatalFault()) {
                        fatalFaultVal = 1;
                        break block9;
                    }
                    try {
                        this.checkLicense();
                        fatalFaultVal = 0;
                    }
                    catch (Exception e) {
                        fatalFaultVal = 1;
                        LOGGER.log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
                        if (systemDbService != null && systemDbService.isOperational()) {
                            String msg = e instanceof BajaRuntimeException ? ((BajaRuntimeException)e).toString(null) : e.getLocalizedMessage();
                            systemDbService.configFail(UNLICENSED_TYPE + ": " + msg);
                        }
                    }
                }
                finally {
                    this.fatalFault.set(fatalFaultVal);
                }
            }
        }
        return fatalFaultVal == 1;
    }

    protected void checkLicense() {
    }

    void purgeUnlicensedDatabaseRecords() {
        if (Sys.isStationStarted() && !this.getType().is(BInactiveSystemDb.TYPE) && !this.purgeCheckComplete.get()) {
            if (BSystemDb.isLicensedForUnlimitedStations()) {
                this.purgeCheckComplete.set(true);
            } else {
                this.getSystemDbService().connectQueue.enqueue((Object)new PurgeUnlicensedTask(this));
            }
        }
    }

    private static boolean isLicensedForUnlimitedStations() {
        try {
            String[] keysToCheckForNonZero;
            Feature feature = Sys.getLicenseManager().getFeature("tridium", "systemIndex");
            feature.check();
            List<String> keysToCheckForUnlimited = Arrays.asList("station.limit", "edgeLite1_station.limit");
            for (String key : keysToCheckForNonZero = new String[]{"local.entity.limit", "station.limit", "station.entity.limit", "edgeLite1_station.limit", "edgeLite1_station.entity.limit"}) {
                int limit = LicenseUtil.parseLimit((Feature)feature, (String)key);
                if (limit > 0 && (!keysToCheckForUnlimited.contains(key) || limit == Integer.MAX_VALUE)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        if (this.isFatalFault() || this.getType().is(BInactiveSystemDb.TYPE)) {
            list = list.filter(info -> {
                TypeInfo agentType = info.getAgentType();
                return !agentType.is(BIQueryHandler.TYPE) && !agentType.is(SearchProviderHolder.searchProviderType);
            });
        }
        return list;
    }

    public boolean canHandle(OrdTarget scope, BQueryScheme scheme) {
        BObject obj = scope.get();
        boolean validScope = this.isRunning() && !this.isFatalFault() && obj != null && (obj instanceof BComponentSpace || !obj.isComponent() && obj instanceof Entity && BSystemDb.isBooleanFacetEnabled((Context)scope, LIGHTWEIGHT_QUERY_RESULTS_FACET_KEY) || obj.isComponent() && scope.getPermissionsForTarget().hasOperatorRead());
        return validScope && scheme.getId().equals(BNeqlScheme.INSTANCE.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CloseableIterator<Entity> query(OrdTarget scope, OrdQuery query) {
        long start = DiagnosticUtil.startIfLoggable((String)"BSystemDb.query");
        try {
            OrdQuery[] queries;
            int len;
            if (this.isFatalFault()) {
                throw new LocalizableRuntimeException("systemDb", "systemDb.error.unavailable");
            }
            boolean useLightweightResults = BSystemDb.isBooleanFacetEnabled((Context)scope, LIGHTWEIGHT_QUERY_RESULTS_FACET_KEY);
            if (useLightweightResults && (len = (queries = scope.getOrdQueries()).length) > 0) {
                String lastScheme = queries[len - 1].getScheme();
                boolean lastSchemeIsQuery = false;
                try {
                    lastSchemeIsQuery = "bql".equals(lastScheme) || BOrdScheme.lookup((String)lastScheme).getType().is(BQueryScheme.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lastSchemeIsQuery && !lastScheme.equals(query.getScheme())) {
                    useLightweightResults = false;
                }
            }
            boolean includeLightweightRelations = useLightweightResults && BSystemDb.isBooleanFacetEnabled((Context)scope, INCLUDE_LIGHTWEIGHT_RELATIONS_KEY);
            CloseableIterator<Entity> closeableIterator = this.doQuery(scope, query, useLightweightResults, includeLightweightRelations);
            return closeableIterator;
        }
        finally {
            if (start > -1L) {
                DiagnosticUtil.complete((long)start, (String)"BSystemDb.query", (Object)(scope + ", " + query));
            }
        }
    }

    protected abstract CloseableIterator<Entity> doQuery(OrdTarget var1, OrdQuery var2, boolean var3, boolean var4);

    private static boolean isBooleanFacetEnabled(Context cx, String facetKey) {
        if (cx == null) {
            return false;
        }
        BObject obj = cx.getFacet(facetKey);
        return obj instanceof BBoolean && ((BBoolean)obj).getBoolean();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        try {
            this.getSystemDbService().connectQueue.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not post System Database action " + action, e);
        }
        return null;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(deleteStationRecords)) {
            BUser user = BUser.getCurrentAuthenticatedUser();
            BasicContext cx = user != null ? new BasicContext(user) : null;
            return BString.make((String)Lexicon.make((String)"systemDb", (Context)cx).getText("systemDb.deleteStation.instructions"));
        }
        return super.getActionParameterDefault(action);
    }

    public final BOrd doDeleteStationRecords(BString stationNames, Context cx) {
        if (this.isFatalFault()) {
            throw new LocalizableRuntimeException("systemDb", "systemDb.error.unavailable");
        }
        String deleteStations = stationNames.getString();
        if (deleteStations.equals(Lexicon.make((String)"systemDb", (Context)cx).getText("systemDb.deleteStation.instructions"))) {
            throw new LocalizableRuntimeException("systemDb", "systemDb.deleteStation.noStationName");
        }
        if ((deleteStations = deleteStations.trim()).isEmpty()) {
            throw new LocalizableRuntimeException("systemDb", "systemDb.deleteStation.noStationName");
        }
        return new BSystemDbDeleteJob(this, cx, deleteStations.split(" ")).submit(null);
    }

    public final BOrd doDeleteAllRecords(Context cx) {
        if (this.isFatalFault()) {
            throw new LocalizableRuntimeException("systemDb", "systemDb.error.unavailable");
        }
        return new BSystemDbDeleteJob(this, cx).submit(null);
    }

    private BSystemDbService getSystemDbService() {
        BSystemDbService parent = (BSystemDbService)this.getParent();
        if (parent == null) {
            throw new NotRunningException();
        }
        return parent;
    }

    public static Context getSystemIndexContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(systemIndexCxPermission);
        }
        return systemIndexContext;
    }

    public static BOrd toSystemDbOrd(Entity entity) throws InvalidEntityException {
        BOrd ord = null;
        if (entity instanceof BNiagaraVirtualComponent) {
            String stationName;
            BNiagaraVirtualComponent virtual = (BNiagaraVirtualComponent)entity;
            BNiagaraVirtualGateway gateway = virtual.getNiagaraVirtualGateway();
            if (gateway != null && gateway.getStationAdapter() != null && (stationName = gateway.getStationAdapter().getStationName()) != null) {
                ord = BOrd.make((String)("nspace:" + stationName + '|' + virtual.getSlotPath().toString()));
            }
        } else if (entity instanceof BINavNode) {
            BOrd navOrd = ((BINavNode)entity).getNavOrd().relativizeToSession();
            OrdQuery[] ordQueries = navOrd.parse();
            int len = ordQueries.length;
            ord = len > 0 && BStationScheme.INSTANCE.getId().equals(ordQueries[0].getScheme()) ? BOrd.make((BOrd)NspaceBaseHolder.nspaceBase, (BOrd)BOrd.make((OrdQuery[])ordQueries, (int)1, (int)ordQueries.length)) : navOrd;
        }
        if (ord == null) {
            ord = ((BOrd)entity.getOrdToEntity().orElseThrow(() -> new InvalidEntityException("The Entity provided to the SystemDb doesn't have a valid ORD"))).relativizeToSession();
        }
        return ord;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BSystemDbService.TYPE);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public BIcon getIcon() {
        return icon;
    }

    public static class InvalidEntityException
    extends Exception {
        InvalidEntityException(String msg) {
            super(msg);
        }
    }

    private static final class SearchProviderHolder {
        static final TypeInfo searchProviderType;

        private SearchProviderHolder() {
        }

        static {
            TypeInfo sProviderType = null;
            try {
                sProviderType = Sys.getType((String)"search:ISearchProvider").getTypeInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            searchProviderType = sProviderType;
        }
    }

    private static final class NspaceBaseHolder {
        static final BOrd nspaceBase = BOrd.make((String)("nspace:" + Sys.getStation().getStationName()));

        private NspaceBaseHolder() {
        }
    }

    private static class PurgeUnlicensedTask
    implements Runnable,
    ICoalesceable {
        private final BSystemDb systemDb;

        PurgeUnlicensedTask(BSystemDb systemDb) {
            this.systemDb = systemDb;
        }

        @Override
        public void run() {
            Throwable throwable;
            long startTicks = Clock.ticks();
            LOGGER.fine(() -> "Starting purge check for unlicensed station Entities in the System Database...");
            HashSet activeStationsFound = new HashSet();
            HashSet inactiveStationsFound = new HashSet();
            TreeSet orphanedStationsFound = new TreeSet();
            HashSet stationsToRemove = new HashSet();
            BAbstractService service = null;
            try {
                service = (BAbstractService)BOrd.make((String)"service:systemIndex:SystemIndexService").get((BObject)this.systemDb);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BAbstractService systemIndexService = service;
            NiagaraNetwork network = null;
            try {
                network = (NiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)this.systemDb);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NiagaraNetwork niagaraNetwork = network;
            Id stationTagId = Id.newId((String)"n:station");
            OrdTarget target = OrdTarget.makeWithFacets((OrdTarget)this.systemDb.getAbsoluteOrd().resolve(), (BFacets)BFacets.make((String)BSystemDb.LIGHTWEIGHT_QUERY_RESULTS_FACET_KEY, (BIDataValue)BBoolean.TRUE, (String)"distinctTag", (BIDataValue)BString.make((String)"n:station")));
            AtomicInteger localEntityLimit = new AtomicInteger(-1);
            AtomicBoolean hadFailure = new AtomicBoolean();
            try {
                throwable = null;
                try (CloseableIterator<Entity> uniqueStationEntities = this.systemDb.query(target, (OrdQuery)new NeqlQuery("true"));){
                    uniqueStationEntities.forEachRemaining(entity -> entity.tags().get(stationTagId).ifPresent(stationTag -> {
                        block19: {
                            String stationName = null;
                            try {
                                BDeviceExt systemIndexDeviceExt;
                                BDevice station;
                                block20: {
                                    stationName = stationTag.toString();
                                    if (stationName == null) {
                                        LOGGER.severe(() -> "Unexpectedly found a null station tag value during purge check");
                                        return;
                                    }
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("  System Database purge check is performing license check for discovered station '" + stationName + "'.");
                                    }
                                    if (systemIndexService == null || systemIndexService.isFatalFault()) {
                                        stationsToRemove.add(stationName);
                                        LOGGER.warning("The System Database will purge Entities from station '" + stationName + "' because the SystemIndexService is not available.");
                                        return;
                                    }
                                    if (stationName.equals(Sys.getStation().getStationName())) {
                                        if (localEntityLimit.get() < 0) {
                                            int limit = LicenseUtil.parseLimit((Feature)systemIndexService.getLicenseFeature(), (String)"local.entity.limit");
                                            if (limit <= 0) {
                                                localEntityLimit.set(0);
                                            } else {
                                                localEntityLimit.set(limit);
                                            }
                                        }
                                        if (localEntityLimit.get() <= 0) {
                                            stationsToRemove.add(stationName);
                                            LOGGER.warning("The System Database will purge Entities from the local station '" + stationName + "' because local indexing is not licensed.");
                                        }
                                        return;
                                    }
                                    if (niagaraNetwork == null) {
                                        orphanedStationsFound.add(stationName);
                                        break block19;
                                    }
                                    station = (BDevice)niagaraNetwork.getStation(stationName);
                                    if (station == null) {
                                        orphanedStationsFound.add(stationName);
                                        break block19;
                                    }
                                    systemIndexDeviceExt = null;
                                    try {
                                        systemIndexDeviceExt = (BDeviceExt)station.get("niagaraSystemIndex_NiagaraSystemIndexDeviceExt");
                                        if (systemIndexDeviceExt != null) break block20;
                                        Type systemIndexDeviceExtType = Sys.getType((String)"niagaraSystemIndex:NiagaraSystemIndexDeviceExt");
                                        for (BDeviceExt deviceExt : station.getDeviceExts()) {
                                            if (!deviceExt.getType().is(systemIndexDeviceExtType)) continue;
                                            systemIndexDeviceExt = deviceExt;
                                            break;
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.warning("Could not find a Niagara 'System Indexer' Device Ext for Niagara station '" + stationName + "'. Check the Niagara station's configuration.");
                                    }
                                }
                                if (systemIndexDeviceExt == null) {
                                    orphanedStationsFound.add(stationName);
                                } else if (station.isDisabled() || station.isFatalFault() || systemIndexDeviceExt.getType().is(BIStatus.TYPE) && ((BIStatus)systemIndexDeviceExt).getStatus().isDisabled()) {
                                    inactiveStationsFound.add(systemIndexDeviceExt);
                                } else {
                                    activeStationsFound.add(systemIndexDeviceExt);
                                }
                            }
                            catch (Exception e) {
                                hadFailure.set(true);
                                LOGGER.log(Level.SEVERE, "An unexpected error occurred during the purge check for station " + stationName, e);
                            }
                        }
                    }));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                hadFailure.set(true);
                LOGGER.log(Level.SEVERE, "An unexpected error occurred during the purge check", e);
            }
            activeStationsFound.forEach(deviceExt -> {
                if (deviceExt.fw(501, null, null, null, null) != null) {
                    String stationName = deviceExt.getDevice().getName();
                    stationsToRemove.add(stationName);
                    LOGGER.warning("The System Database will purge Entities from active station '" + stationName + "' because it is not licensed.");
                }
            });
            inactiveStationsFound.forEach(deviceExt -> {
                if (deviceExt.fw(501, null, null, null, null) != null) {
                    String stationName = deviceExt.getDevice().getName();
                    stationsToRemove.add(stationName);
                    LOGGER.warning("The System Database will purge Entities from inactive station '" + stationName + "' because it is not licensed.");
                }
            });
            orphanedStationsFound.forEach(stationName -> {
                if (systemIndexService.fw(501, (Object)"station.limit", stationName, null, null) != null) {
                    stationsToRemove.add(stationName);
                    LOGGER.warning("The System Database will purge Entities from station '" + stationName + "' because it is not licensed.");
                } else {
                    LOGGER.warning("The System Database found Entities from an unknown station '" + stationName + "'. These are likely orphaned Entities, so you may want to manually remove them from the System Database so that they don't count against the systemIndex station.limit license check on future restarts.");
                }
            });
            if (!stationsToRemove.isEmpty()) {
                try {
                    throwable = null;
                    try (SystemDbConnection connection = this.systemDb.makeConnection(null);){
                        Object[] stationNames = stationsToRemove.toArray(new String[stationsToRemove.size()]);
                        connection.removeStationEntities((String[])stationNames);
                        LOGGER.warning("Due to license limit violations, the System Database purged Entities from stations: " + ArrayUtil.join((Object[])stationNames, (String)", "));
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    hadFailure.set(true);
                    LOGGER.log(Level.SEVERE, "An unexpected error occurred during the System Database license purge operation", ex);
                }
            }
            if (!hadFailure.get()) {
                this.systemDb.purgeCheckComplete.set(true);
                LOGGER.fine(() -> "Successfully completed System Database purge check in " + (Clock.ticks() - startTicks) + " ms.");
            } else {
                LOGGER.fine(() -> "Completed System Database purge check with errors in " + (Clock.ticks() - startTicks) + " ms.");
            }
        }

        public Object getCoalesceKey() {
            return this.systemDb;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }
}

