/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="token", type="String", defaultValue="")
public class BGoogleAuthCredentials
extends BUsernameAndPassword
implements BIAgent {
    public static final Property token = BGoogleAuthCredentials.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BGoogleAuthCredentials.class);

    public String getToken() {
        return this.getString(token);
    }

    public void setToken(String v) {
        this.setString(token, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGoogleAuthCredentials(String username, BPassword password) {
        super(username, password);
    }

    public BGoogleAuthCredentials(String username, String password) {
        this(username, BPassword.make((String)password));
    }

    public BGoogleAuthCredentials() {
    }

    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BString.make((String)this.getUsername()).encode((DataOutput)out);
        this.getPassword().encode((DataOutput)out, context);
        BString.make((String)this.getToken()).encode((DataOutput)out);
        out.flush();
        return bout.toByteArray();
    }

    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BGoogleAuthCredentials x = (BGoogleAuthCredentials)this.newCopy();
        x.set(username, (BValue)BString.DEFAULT.decode((DataInput)in));
        x.set(password, (BValue)BPassword.DEFAULT.decode((DataInput)in));
        x.set(token, (BValue)BString.DEFAULT.decode((DataInput)in));
        return x;
    }

    public boolean equivalent(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && SecurityUtil.equals((String)((BGoogleAuthCredentials)((Object)obj)).getUsername(), (String)this.getUsername()) && ((BGoogleAuthCredentials)((Object)obj)).getPassword().validate(this.getPassword()) && SecurityUtil.equals((String)((BGoogleAuthCredentials)((Object)obj)).getToken(), (String)this.getToken());
    }
}

