/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.util;

import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.cert.CertificateCheck;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumCertValidator;
import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.opcUaClient.util.OpcUaCertificateValidationListener;
import java.security.AccessController;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class OpcUaCertificateValidator
implements CertificateValidator {
    List<X509TrustManager> trustManagerList;
    private final String hostname;
    private final int port;
    private final String hostKey;
    private static final CoreCryptoManager coreCryptoManager = CoreCryptoManager.get();
    private static final Logger logger = Logger.getLogger("opcUaClient.certificateValidator");

    public OpcUaCertificateValidator(UaAddress serverAddress) {
        TrustManager[] trustManagers;
        TrustManagerFactory trustManagerFactory;
        block8: {
            this.trustManagerList = new ArrayList<X509TrustManager>();
            this.hostname = serverAddress.getHost();
            this.port = serverAddress.getPort();
            this.hostKey = this.hostname + ":" + this.port;
            try {
                ICoreTrustStore userTrustStore = coreCryptoManager.getUserTrustStore();
                if (userTrustStore.size() <= 0) break block8;
                trustManagerFactory = TrustManagerFactory.getInstance("X509");
                trustManagerFactory.init(AccessController.doPrivileged(() -> ((ICoreTrustStore)userTrustStore).getKeyStore()));
                for (TrustManager trustManager : trustManagers = trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    this.trustManagerList.add((X509TrustManager)trustManager);
                    break;
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Could not add User Trust Store to OpcUa trust certs list", e);
                }
                logger.log(Level.SEVERE, "Could not add User Trust Store to OpcUa trust certs list: " + e.getMessage());
            }
        }
        try {
            ICoreTrustStore systemTrustStore = coreCryptoManager.getSystemTrustStore();
            trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(AccessController.doPrivileged(() -> ((ICoreTrustStore)systemTrustStore).getKeyStore()));
            for (TrustManager trustManager : trustManagers = trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.trustManagerList.add((X509TrustManager)trustManager);
                break;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Could not add System Trust Store to OpcUa trust certs list", e);
            }
            logger.log(Level.SEVERE, "Could not add System Trust Store to OpcUa trust certs list: " + e.getMessage());
        }
    }

    private boolean isCertificateTrusted(X509Certificate[] x509Chain) {
        Exception lastException = null;
        for (X509TrustManager trustManager : this.trustManagerList) {
            try {
                trustManager.checkServerTrusted(x509Chain, "UNKNOWN");
                TridiumHostnameVerifier hostnameVerifier = new TridiumHostnameVerifier(coreCryptoManager.getExemptionStore());
                boolean verified = hostnameVerifier.verify(this.hostname, x509Chain, this.port);
                if (!verified) {
                    logger.log(Level.SEVERE, String.format("hostname validation failed. Expected <%s>, got <%s>", this.hostname, x509Chain[0].getSubjectX500Principal().getName()));
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Certificate " + x509Chain[0].getSubjectX500Principal().getName() + " failed trust validation", lastException);
            } else {
                logger.log(Level.SEVERE, "Certificate " + x509Chain[0].getSubjectX500Principal().getName() + " failed trust validation: " + lastException.getMessage());
            }
        }
        return false;
    }

    private void createExemptionIfNotPresent(X509Certificate[] x509Chain) {
        ICoreExemptionStore exemptionStore = coreCryptoManager.getExemptionStore();
        try {
            NHostExemption exemption = exemptionStore.getExemption(this.hostKey);
            if (exemption == null) {
                logger.info("Attempting to create exemption for host: " + this.hostKey);
                exemptionStore.setExemption(NHostExemption.make((NX509Certificate)NX509Certificate.make((X509Certificate)x509Chain[0]), (String)this.hostKey, (boolean)false));
                exemptionStore.save();
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Unable to get certificate exemption from exemption store for host: " + this.hostKey, e);
            }
            logger.log(Level.SEVERE, "Unable to get certificate exemption from exemption store for host: " + this.hostKey);
        }
    }

    private boolean isHostExempted(X509Certificate[] x509Chain) {
        try {
            CertValidationResult result = TridiumCertValidator.validateCertificate((ICoreCryptoManager)coreCryptoManager, (X509Certificate[])x509Chain, (String)this.hostname, (String)this.hostKey);
            if (result.isApproved()) {
                logger.log(Level.INFO, "Exemption approved for host: " + this.hostKey);
                return true;
            }
            logger.log(Level.WARNING, "Exemption not approved for host: " + this.hostKey);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "Exemption approval failed.", e);
            }
            logger.log(Level.WARNING, "Exemption approval failed: " + e.getMessage());
        }
        return false;
    }

    public StatusCode validateCertificate(ApplicationDescription applicationDescription, Cert cert) {
        EnumSet<CertificateCheck> certificateCheckEnumSet;
        StatusCode statusCode;
        block13: {
            X509Certificate[] certChain;
            X509Certificate certificate;
            block12: {
                statusCode = StatusCode.BAD;
                certificateCheckEnumSet = EnumSet.noneOf(CertificateCheck.class);
                certificate = cert.getCertificate();
                certChain = new X509Certificate[]{certificate};
                try {
                    certificate.checkValidity();
                    certificateCheckEnumSet.add(CertificateCheck.Validity);
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    if (!logger.isLoggable(Level.FINE)) break block12;
                    logger.log(Level.WARNING, "The certificate is not valid for current date: " + this.hostKey, e);
                }
            }
            if (this.isCertificateTrusted(certChain)) {
                certificateCheckEnumSet.add(CertificateCheck.Trusted);
                certificateCheckEnumSet.add(CertificateCheck.Signature);
            } else {
                this.createExemptionIfNotPresent(certChain);
                if (this.isHostExempted(certChain)) {
                    certificateCheckEnumSet.add(CertificateCheck.Trusted);
                    certificateCheckEnumSet.add(CertificateCheck.Signature);
                }
            }
            try {
                certificate.verify(certificate.getPublicKey());
                certificateCheckEnumSet.add(CertificateCheck.Signature);
                certificateCheckEnumSet.add(CertificateCheck.SelfSigned);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block13;
                logger.log(Level.FINE, "Certificate not self-signed.", e);
            }
        }
        OpcUaCertificateValidationListener listener = new OpcUaCertificateValidationListener();
        ValidationResult validationResult = listener.onValidate(cert, applicationDescription, certificateCheckEnumSet);
        switch (validationResult) {
            case AcceptPermanently: 
            case AcceptOnce: {
                statusCode = StatusCode.GOOD;
                break;
            }
            case Reject: {
                if (!certificateCheckEnumSet.contains(CertificateCheck.Signature)) {
                    statusCode = StatusCode.valueOf((UnsignedInteger)StatusCodes.Bad_SecurityChecksFailed);
                    break;
                }
                if (certificateCheckEnumSet.contains(CertificateCheck.Validity)) break;
                statusCode = StatusCode.valueOf((UnsignedInteger)StatusCodes.Bad_CertificateTimeInvalid);
            }
        }
        return statusCode;
    }

    public StatusCode validateCertificate(Cert cert) {
        return cert == null ? StatusCode.GOOD : this.validateCertificate(null, cert);
    }
}

