/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Attributes;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.point.BOpcUaClientPointDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.util.OpcUaMonitoredDataItemUtil;
import java.util.logging.Level;
import javax.baja.util.Lexicon;

public class PointSubscribeCmd
implements Runnable {
    private static final Lexicon LEX = Lexicon.make(PointSubscribeCmd.class);
    private BOpcUaDevice device;
    private BOpcUaClientPointDeviceExt deviceExt;
    private NodeId nodeId;
    private BOpcUaClientProxyExt proxyExt;

    private PointSubscribeCmd() {
    }

    public PointSubscribeCmd(BOpcUaDevice device, BOpcUaClientPointDeviceExt deviceExt, NodeId nodeId, BOpcUaClientProxyExt proxyExt) {
        this.device = device;
        this.deviceExt = deviceExt;
        this.nodeId = nodeId;
        this.proxyExt = proxyExt;
    }

    private String updateUaNodeId(String oldUaNodeId, String nameSpaceUri) throws ServiceException, StatusException {
        if (nameSpaceUri == null || nameSpaceUri.isEmpty()) {
            return oldUaNodeId;
        }
        return oldUaNodeId.substring(0, oldUaNodeId.indexOf(61) + 1) + this.device.uaClient.getNamespaceTable(true).getIndex(nameSpaceUri) + oldUaNodeId.substring(oldUaNodeId.indexOf(59));
    }

    @Override
    public void run() {
        block13: {
            Subscription subscription;
            String updatedNodeId;
            if (this.proxyExt.getNodeId() == null) {
                try {
                    NodeId newNodeId = NodeId.parseNodeId((String)this.proxyExt.getUaNodeId());
                    this.proxyExt.setNodeId(newNodeId);
                    this.nodeId = newNodeId;
                }
                catch (Exception e) {
                    this.proxyExt.configFail(e.getLocalizedMessage());
                    return;
                }
            }
            try {
                updatedNodeId = this.updateUaNodeId(this.proxyExt.getUaNodeId(), this.proxyExt.getNameSpaceUri());
            }
            catch (ServiceException | StatusException e) {
                throw new RuntimeException(e);
            }
            if (updatedNodeId != null && !updatedNodeId.equals(this.proxyExt.getUaNodeId())) {
                this.proxyExt.setUaNodeId(updatedNodeId);
                try {
                    NodeId newNodeId = NodeId.parseNodeId((String)updatedNodeId);
                    this.proxyExt.setNodeId(newNodeId);
                    this.nodeId = newNodeId;
                }
                catch (Exception e) {
                    this.proxyExt.configFail(e.getLocalizedMessage());
                    return;
                }
            }
            if ((subscription = this.deviceExt.getSubscription()) != null) {
                try {
                    PointSubscribeCmd.subscribe(subscription, this.proxyExt, this.nodeId);
                }
                catch (Exception e) {
                    if (e instanceof StatusException) {
                        StatusCode statusCode = ((StatusException)((Object)e)).getStatusCode();
                        this.proxyExt.setUaStatusCode(statusCode.toString());
                    }
                    this.proxyExt.readFail(LEX.getText("opcUaClient.point.subscribeFailed", new Object[]{e.getLocalizedMessage()}));
                    if (BOpcUaClientProxyExt.rdlogger.isLoggable(Level.FINER)) {
                        BOpcUaClientProxyExt.rdlogger.log(Level.FINER, "Subscribe failed: ", e);
                    }
                    if (!BOpcUaClientProxyExt.rdlogger.isLoggable(Level.FINE)) break block13;
                    BOpcUaClientProxyExt.rdlogger.log(Level.FINE, "Subscribe failed: " + e.getLocalizedMessage());
                }
            }
        }
    }

    private static void subscribe(Subscription subscription, BOpcUaClientProxyExt proxyExt, NodeId nodeId) throws Exception {
        MonitoredDataItem item = OpcUaMonitoredDataItemUtil.getOrCreateAndGetMonitoredItem(subscription, nodeId, Attributes.Value);
        if (BOpcUaClientProxyExt.rdlogger.isLoggable(Level.FINEST)) {
            BOpcUaClientProxyExt.rdlogger.log(Level.FINEST, "Adding listener for: " + nodeId);
        }
        proxyExt.setMonitoredItem(item);
        OpcUaMonitoredDataItemUtil.subscribe(item, proxyExt, nodeId, Attributes.Value);
    }
}

