/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.point.BNProxyExt;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.message.OpcUaWriteAsyncRequest;
import com.tridium.opcUaClient.point.BOpcUaClientPointDeviceExt;
import com.tridium.opcUaClient.point.PointSubscribeCmd;
import com.tridium.opcUaClient.point.PointUnsubscribeCmd;
import com.tridium.opcUaClient.util.MatrixUtil;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.enums.BServerState;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="uaNodeId", type="String", defaultValue=""), @NiagaraProperty(name="nameSpaceUri", type="String", defaultValue=""), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal", flags=4), @NiagaraProperty(name="arrayDimensions", type="String", defaultValue=""), @NiagaraProperty(name="arrayIndex", type="String", defaultValue=""), @NiagaraProperty(name="uaDataType", type="String", defaultValue=""), @NiagaraProperty(name="uaDataTypeIdentifier", type="long", defaultValue="-1"), @NiagaraProperty(name="uaStatusCode", type="String", defaultValue="", flags=3), @NiagaraProperty(name="sourceTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="serverTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="infoLogging", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="enableInfoLog", parameterType="BBoolean", defaultValue="BBoolean.make(false)")
public class BOpcUaClientProxyExt
extends BNProxyExt
implements BINPollable,
MonitoredDataItemListener {
    public static final Property uaNodeId = BOpcUaClientProxyExt.newProperty((int)0, (String)"", null);
    public static final Property nameSpaceUri = BOpcUaClientProxyExt.newProperty((int)0, (String)"", null);
    public static final Property pollFrequency = BOpcUaClientProxyExt.newProperty((int)4, (BValue)BPollFrequency.normal, null);
    public static final Property arrayDimensions = BOpcUaClientProxyExt.newProperty((int)0, (String)"", null);
    public static final Property arrayIndex = BOpcUaClientProxyExt.newProperty((int)0, (String)"", null);
    public static final Property uaDataType = BOpcUaClientProxyExt.newProperty((int)0, (String)"", null);
    public static final Property uaDataTypeIdentifier = BOpcUaClientProxyExt.newProperty((int)0, (int)-1, null);
    public static final Property uaStatusCode = BOpcUaClientProxyExt.newProperty((int)3, (String)"", null);
    public static final Property sourceTimestamp = BOpcUaClientProxyExt.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property serverTimestamp = BOpcUaClientProxyExt.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property infoLogging = BOpcUaClientProxyExt.newProperty((int)4, (boolean)false, null);
    public static final Action enableInfoLog = BOpcUaClientProxyExt.newAction((int)0, (BValue)BBoolean.make((boolean)false), null);
    public static final Type TYPE = Sys.loadType(BOpcUaClientProxyExt.class);
    public static final Logger rdlogger = Logger.getLogger("opcUaClient.point.rd");
    public static final Logger wrlogger = Logger.getLogger("opcUaClient.point.wr");
    boolean configFault = false;
    MonitoredDataItem item;
    NodeId nodeId;
    DataValue[] values;
    StatusCode statusCode;
    NumericRange numericRange;

    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    public String getNameSpaceUri() {
        return this.getString(nameSpaceUri);
    }

    public void setNameSpaceUri(String v) {
        this.setString(nameSpaceUri, v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public String getArrayDimensions() {
        return this.getString(arrayDimensions);
    }

    public void setArrayDimensions(String v) {
        this.setString(arrayDimensions, v, null);
    }

    public String getArrayIndex() {
        return this.getString(arrayIndex);
    }

    public void setArrayIndex(String v) {
        this.setString(arrayIndex, v, null);
    }

    public String getUaDataType() {
        return this.getString(uaDataType);
    }

    public void setUaDataType(String v) {
        this.setString(uaDataType, v, null);
    }

    public long getUaDataTypeIdentifier() {
        return this.getLong(uaDataTypeIdentifier);
    }

    public void setUaDataTypeIdentifier(long v) {
        this.setLong(uaDataTypeIdentifier, v, null);
    }

    public String getUaStatusCode() {
        return this.getString(uaStatusCode);
    }

    public void setUaStatusCode(String v) {
        this.setString(uaStatusCode, v, null);
    }

    public BAbsTime getSourceTimestamp() {
        return (BAbsTime)this.get(sourceTimestamp);
    }

    public void setSourceTimestamp(BAbsTime v) {
        this.set(sourceTimestamp, (BValue)v, null);
    }

    public BAbsTime getServerTimestamp() {
        return (BAbsTime)this.get(serverTimestamp);
    }

    public void setServerTimestamp(BAbsTime v) {
        this.set(serverTimestamp, (BValue)v, null);
    }

    public boolean getInfoLogging() {
        return this.getBoolean(infoLogging);
    }

    public void setInfoLogging(boolean v) {
        this.setBoolean(infoLogging, v, null);
    }

    public void enableInfoLog(BBoolean parameter) {
        this.invoke(enableInfoLog, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BOpcUaNetwork getOpcUaClientNetwork() {
        return (BOpcUaNetwork)this.getNetwork();
    }

    public final BOpcUaDevice getBOpcUaClientDevice() {
        return (BOpcUaDevice)DrUtil.getParent((BComplex)this, (Type)BOpcUaDevice.TYPE);
    }

    public final BOpcUaClientPointDeviceExt getOpcUaClientPointDeviceExt() {
        return (BOpcUaClientPointDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        try {
            this.nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
        }
        catch (Exception e) {
            this.nodeId = null;
            this.configFail(e.getLocalizedMessage());
        }
    }

    public void stopped() {
        BOpcUaNetwork network = (BOpcUaNetwork)this.getNetwork();
        if (network != null && this.item != null) {
            network.postAsync(new PointUnsubscribeCmd(this.getBOpcUaClientDevice(), this.getOpcUaClientPointDeviceExt(), this.getNodeId(), this));
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning() && cx != Context.decoding) {
            if (p.equals(arrayIndex)) {
                int[] arrayIndex = MatrixUtil.stringToIndexes(this.getArrayIndex());
                int[] maxIndex = MatrixUtil.stringToIndexes(this.getArrayDimensions());
                boolean indexOk = true;
                if (arrayIndex.length == maxIndex.length) {
                    for (int i = 0; i < arrayIndex.length; ++i) {
                        if (maxIndex[i] <= 0 || arrayIndex[i] <= maxIndex[i]) continue;
                        indexOk = false;
                        break;
                    }
                } else {
                    indexOk = false;
                }
                if (!indexOk) {
                    this.configFail("Invalid index: " + this.getArrayIndex() + " for ArrayDimensions: " + this.getArrayDimensions());
                }
            } else if (p.equals(uaNodeId)) {
                try {
                    this.nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
                }
                catch (Exception e) {
                    this.nodeId = null;
                    this.configFail(e.getLocalizedMessage());
                    return;
                }
                this.configOk();
                if (this.isSubscribed()) {
                    try {
                        this.readSubscribed(cx);
                    }
                    catch (Exception e) {
                        rdlogger.fine(e.getMessage());
                    }
                }
            }
        }
    }

    public void configFail(String cause) {
        this.configFault = true;
        this.readFail(cause);
    }

    public void configOk() {
        this.configFault = false;
        this.readReset();
    }

    public void readSubscribed(Context cx) throws Exception {
        BOpcUaNetwork network = (BOpcUaNetwork)this.getNetwork();
        if (network != null) {
            network.postAsync(new PointSubscribeCmd(this.getBOpcUaClientDevice(), this.getOpcUaClientPointDeviceExt(), this.getNodeId(), this));
        }
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public boolean write(Context cx) throws Exception {
        if (this.configFault || !this.getParentPoint().isWritablePoint()) {
            return false;
        }
        BStatusValue out = this.getWriteValue();
        if (out.getStatus().isNull()) {
            return false;
        }
        BOpcUaNetwork network = (BOpcUaNetwork)this.getNetwork();
        BOpcUaDevice device = (BOpcUaDevice)this.getDevice();
        if (!device.getServerState().equals((Object)BServerState.Running)) {
            return false;
        }
        try {
            network.postAsync(new OpcUaWriteAsyncRequest(this, out));
        }
        catch (Exception e) {
            network.log().severe("Could not post write for " + this.getParentPoint().getName());
            this.writeFail("postWriteFail: " + e);
            return false;
        }
        return true;
    }

    public void doWrite(BStatusValue out) {
        try {
            BOpcUaNetwork net = (BOpcUaNetwork)this.getNetwork();
            if (net == null || net.isDisabled() || this.configFault) {
                return;
            }
            BOpcUaDevice device = (BOpcUaDevice)this.getDevice();
            UaClient uaClient = device.uaClient;
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            if (this.statusCode != null && this.statusCode.isBad()) {
                this.writeFail(this.statusCode.getName());
                return;
            }
            AccessController.doPrivileged(() -> {
                try {
                    BControlPoint point;
                    UaNode node = uaClient.getAddressSpace().getNode(nodeId);
                    UaDataType dataType = null;
                    Class javaClass = null;
                    if (node instanceof UaVariable) {
                        UaVariable v = (UaVariable)node;
                        if (v.getDataType() == null) {
                            v.setDataType(uaClient.getAddressSpace().getDataType(v.getDataTypeId()));
                        }
                        dataType = v.getDataType();
                        javaClass = dataType.getJavaClass();
                    }
                    if ((point = this.getParentPoint()).isWritablePoint()) {
                        boolean written;
                        String dimensions = this.getArrayDimensions();
                        boolean isArray = !dimensions.isEmpty() && !dimensions.equals("[]");
                        Object wrValue = this.convertForWrite(out, isArray);
                        Variant wrVariant = new Variant(wrValue);
                        if (isArray) {
                            this.logMessage(wrlogger, point.getName() + ": wrValue = " + ((Object[])wrValue)[0] + ", class = " + wrValue.getClass().getSimpleName());
                        } else {
                            this.logMessage(wrlogger, point.getName() + ": wrValue = " + wrValue + ", class = " + wrValue.getClass().getSimpleName());
                        }
                        Object[] convertedValue = new Object[]{wrVariant};
                        if (convertedValue[0] == null) {
                            this.writeFail("Cannot write null OpcUa variable value");
                            return null;
                        }
                        if (isArray) {
                            this.numericRange = MatrixUtil.indexToNumericRange(this.getArrayIndex());
                            written = uaClient.writeAttribute(nodeId, Attributes.Value, (Object)wrVariant, this.numericRange);
                        } else {
                            written = uaClient.writeAttribute(nodeId, Attributes.Value, convertedValue[0]);
                        }
                        if (written) {
                            wrlogger.log(Level.FINE, point.getName() + ": wrValue = " + wrValue + ", class = " + wrValue.getClass().getSimpleName() + " has already been written");
                        } else {
                            wrlogger.log(Level.FINE, point.getName() + ": wrValue = " + wrValue + ", class = " + wrValue.getClass().getSimpleName() + " will be written asynchronously");
                        }
                        this.writeOk(out);
                    }
                }
                catch (ServiceException e) {
                    this.writeFail("ServiceException: " + e.getLocalizedMessage());
                }
                catch (StatusException e) {
                    this.writeFail("StatusException: " + e.getLocalizedMessage());
                }
                catch (Exception e) {
                    this.writeFail("Exception: " + e.getLocalizedMessage());
                }
                return null;
            });
        }
        catch (Exception e) {
            this.writeFail("Exception: " + e.getLocalizedMessage());
        }
    }

    private boolean isArray() {
        String dimensions = this.getArrayDimensions();
        return !dimensions.isEmpty() && !dimensions.equals("[]");
    }

    private NumericRange getNumericRange() {
        return new NumericRange((int[][])new int[][]{MatrixUtil.stringToIndexes(this.getArrayIndex())});
    }

    private Object convertForWrite(BStatusValue wrStatusValue, boolean isArray) {
        String uaDataType = this.getUaDataType();
        int i = uaDataType.indexOf(91);
        if (i >= 0) {
            uaDataType = uaDataType.substring(0, i);
        }
        if (wrStatusValue instanceof BStatusNumeric) {
            double dValue = ((BStatusNumeric)wrStatusValue).getValue();
            switch (uaDataType) {
                case "SByte": 
                case "Byte": {
                    Byte bvalue = (byte)dValue;
                    if (isArray) {
                        Byte[] bArray = new Byte[]{bvalue};
                        return bArray;
                    }
                    return bvalue;
                }
                case "UByte": 
                case "UnsignedByte": {
                    UnsignedByte ubvalue = UnsignedByte.valueOf((int)((int)dValue));
                    if (isArray) {
                        UnsignedByte[] bArray = new UnsignedByte[]{ubvalue};
                        return bArray;
                    }
                    return ubvalue;
                }
                case "Int16": 
                case "Short": {
                    Short svalue = (short)dValue;
                    if (isArray) {
                        Short[] bArray = new Short[]{svalue};
                        return bArray;
                    }
                    return svalue;
                }
                case "UInt16": 
                case "UnsignedShort": {
                    UnsignedShort usvalue = UnsignedShort.valueOf((int)((int)dValue));
                    if (isArray) {
                        UnsignedShort[] bArray = new UnsignedShort[]{usvalue};
                        return bArray;
                    }
                    return usvalue;
                }
                case "Int32": 
                case "Integer": {
                    Integer ivalue = (int)dValue;
                    if (isArray) {
                        Integer[] bArray = new Integer[]{ivalue};
                        return bArray;
                    }
                    return ivalue;
                }
                case "UInt32": 
                case "UInteger": 
                case "UnsignedInteger": {
                    UnsignedInteger uivalue = UnsignedInteger.valueOf((long)((long)dValue));
                    if (isArray) {
                        UnsignedInteger[] bArray = new UnsignedInteger[]{uivalue};
                        return bArray;
                    }
                    return uivalue;
                }
                case "Int64": 
                case "Long": {
                    Long value = (long)dValue;
                    if (isArray) {
                        Long[] bArray = new Long[]{value};
                        return bArray;
                    }
                    return value;
                }
                case "UInt64": 
                case "ULong": 
                case "UnsignedLong": {
                    UnsignedLong ulvalue = UnsignedLong.valueOf((long)((long)dValue));
                    if (isArray) {
                        UnsignedLong[] bArray = new UnsignedLong[]{ulvalue};
                        return bArray;
                    }
                    return ulvalue;
                }
                case "Float": {
                    Float fvalue = Float.valueOf((float)dValue);
                    if (isArray) {
                        Float[] bArray = new Float[]{fvalue};
                        return bArray;
                    }
                    return fvalue;
                }
                case "Number": 
                case "Double": {
                    Double dvalue = dValue;
                    if (isArray) {
                        Double[] bArray = new Double[]{dvalue};
                        return bArray;
                    }
                    return dvalue;
                }
            }
            return Double.toString(dValue);
        }
        if (wrStatusValue instanceof BStatusBoolean) {
            boolean bValue = ((BStatusBoolean)wrStatusValue).getValue();
            if (uaDataType.equals("Boolean")) {
                Boolean value = bValue;
                if (isArray) {
                    Boolean[] array = new Boolean[]{value};
                    return array;
                }
                return value;
            }
            return Boolean.toString(bValue);
        }
        if (wrStatusValue instanceof BStatusEnum) {
            int iValue = ((BStatusEnum)wrStatusValue).getValue().getOrdinal();
            switch (uaDataType) {
                case "Byte": {
                    return (byte)iValue;
                }
                case "UnsignedByte": {
                    return UnsignedByte.valueOf((int)iValue);
                }
                case "Short": {
                    return (short)iValue;
                }
                case "UnsignedShort": {
                    return UnsignedShort.valueOf((int)iValue);
                }
                case "Integer": {
                    return iValue;
                }
                case "UInt32": 
                case "UInteger": 
                case "UnsignedInteger": {
                    return UnsignedInteger.valueOf((long)iValue);
                }
                case "Long": {
                    return (long)iValue;
                }
                case "UnsignedLong": {
                    return UnsignedLong.valueOf((long)iValue);
                }
            }
            return (long)iValue;
        }
        String sValue = ((BStatusString)wrStatusValue).getValue();
        String dimensions = this.getArrayDimensions();
        boolean isByteStringArray = dimensions.startsWith("[][");
        switch (uaDataType) {
            case "String": {
                if (isArray) {
                    String[] retValue = new String[]{sValue};
                    return retValue;
                }
                return sValue;
            }
            case "LocalizedText": {
                if (isArray) {
                    LocalizedText[] retValue = new LocalizedText[]{new LocalizedText(sValue)};
                    return retValue;
                }
                return new LocalizedText(sValue);
            }
            case "byte": {
                byte[] bytes = sValue.getBytes();
                if (isByteStringArray) {
                    byte[][] retValue = new byte[][]{bytes};
                    return retValue;
                }
                return bytes;
            }
        }
        throw new IllegalArgumentException("Invalid String type: " + uaDataType);
    }

    public Type getDeviceExtType() {
        return BOpcUaClientPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParentPoint().isWritablePoint()) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(enableInfoLog)) {
            return BBoolean.make((!this.getInfoLogging() ? 1 : 0) != 0);
        }
        return super.getActionParameterDefault(action);
    }

    public void doEnableInfoLog(BBoolean enable) {
        this.setInfoLogging(enable.getBoolean());
        rdlogger.info("enableInfoLog:" + this.getParentPoint().getName() + " " + enable.getBoolean());
    }

    public void doPoll() {
    }

    private int[] decodeMaxArrayIndex() {
        String dimensions = this.getArrayDimensions();
        if (dimensions.isEmpty()) {
            return new int[0];
        }
        String[] ss = dimensions.split("]");
        int[] maxIndex = new int[ss.length];
        for (int i = 0; i < maxIndex.length; ++i) {
            maxIndex[i] = -1;
            if (ss[i].length() <= 1 && !ss[i].startsWith("[")) continue;
            String sIndex = ss[i].substring(1);
            try {
                maxIndex[i] = Integer.parseInt(sIndex);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxIndex;
    }

    private int[] decodeArrayIndex() {
        int[] ret = new int[]{0};
        String s = this.getArrayIndex();
        try {
            if (!s.contains(",")) {
                ret[0] = Integer.parseInt(s);
            } else {
                String[] strings = s.split(",");
                ret = new int[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    ret[i] = Integer.parseInt(strings[i]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    public void onDataChange(MonitoredDataItem monitoredDataItem, DataValue oldValue, DataValue newValue) {
        if (newValue != null && monitoredDataItem.equals((Object)this.item)) {
            int[] arrayIndex = MatrixUtil.stringToIndexes(this.getArrayIndex());
            this.statusCode = newValue.getStatusCode();
            this.setUaStatusCode(this.statusCode.toString());
            if (this.statusCode.isGood()) {
                BStatusValue desiredType = (BStatusValue)this.getParentPoint().getOutStatusValue().newCopy();
                BStatusValue setValue = OpcUaClientUtil.makeStatusValue(newValue, desiredType, arrayIndex);
                this.logMessage(rdlogger, "onDataChange():" + this.getParentPoint().getName() + " setValue = " + setValue);
                this.readOk(setValue);
                this.getDevice().pingOk();
            } else {
                String description = this.statusCode.getDescription();
                this.readFail(description);
            }
            DateTime sourceTimestamp = newValue.getSourceTimestamp();
            if (null != sourceTimestamp) {
                this.setSourceTimestamp(BAbsTime.make((long)sourceTimestamp.getTimeInMillis()));
            }
            this.setServerTimestamp(BAbsTime.make());
        }
    }

    private void logMessage(Logger logger, String message) {
        if (this.getInfoLogging()) {
            logger.info(message);
        } else {
            logger.fine(message);
        }
    }

    protected void setMonitoredItem(MonitoredDataItem item) {
        this.item = item;
    }

    protected MonitoredDataItem getMonitoredItem() {
        return this.item;
    }

    protected void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    protected StatusCode getStatusCode() {
        return this.statusCode;
    }

    protected void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    protected NodeId getNodeId() {
        return this.nodeId;
    }
}

