/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.UaClient;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.point.BNPointDeviceExt;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.point.BOpcUaClientPointDiscoveryPreferences;
import com.tridium.opcUaClient.point.BOpcUaClientPointFolder;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaClient.util.OpcUaSubscriptionAliveListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="discoveryPreferences", type="NDiscoveryPreferences", defaultValue="new BOpcUaClientPointDiscoveryPreferences()", override=true), @NiagaraProperty(name="discoveryFailCause", type="String", defaultValue="", flags=7), @NiagaraProperty(name="publishInterval", type="int", defaultValue="500", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="maxKeepAliveCount", type="long", defaultValue="1728000", facets={@Facet(name="BFacets.MIN", value="1")})})
public class BOpcUaClientPointDeviceExt
extends BNPointDeviceExt {
    public static final Property discoveryPreferences = BOpcUaClientPointDeviceExt.newProperty((int)0, (BValue)new BOpcUaClientPointDiscoveryPreferences(), null);
    public static final Property discoveryFailCause = BOpcUaClientPointDeviceExt.newProperty((int)7, (String)"", null);
    public static final Property publishInterval = BOpcUaClientPointDeviceExt.newProperty((int)0, (int)500, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"))));
    public static final Property maxKeepAliveCount = BOpcUaClientPointDeviceExt.newProperty((int)0, (int)1728000, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Type TYPE = Sys.loadType(BOpcUaClientPointDeviceExt.class);
    private Subscription subscription;
    private static Logger logger = Logger.getLogger("opcUaClient.point");

    public String getDiscoveryFailCause() {
        return this.getString(discoveryFailCause);
    }

    public void setDiscoveryFailCause(String v) {
        this.setString(discoveryFailCause, v, null);
    }

    public int getPublishInterval() {
        return this.getInt(publishInterval);
    }

    public void setPublishInterval(int v) {
        this.setInt(publishInterval, v, null);
    }

    public long getMaxKeepAliveCount() {
        return this.getLong(maxKeepAliveCount);
    }

    public void setMaxKeepAliveCount(long v) {
        this.setLong(maxKeepAliveCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BOpcUaNetwork getOpcUaClientNetwork() {
        return (BOpcUaNetwork)this.getNetwork();
    }

    public final BOpcUaDevice getOpcUaClientDevice() {
        return (BOpcUaDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BOpcUaDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BOpcUaClientPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BOpcUaClientProxyExt.TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        boolean netwkStatus;
        boolean devStatus = this.getOpcUaClientDevice().isDisabled() || this.getOpcUaClientDevice().isFault() || this.getOpcUaClientDevice().isDown();
        boolean bl = netwkStatus = this.getOpcUaClientNetwork().isDisabled() || this.getOpcUaClientNetwork().isFault() || this.getOpcUaClientNetwork().isDown();
        if (devStatus || netwkStatus) {
            prefs.getJob().log().message("Discovery job Failed.");
            throw new Exception("Device not Enabled.");
        }
        this.getOpcUaClientDevice().doLearn(prefs.getJob());
        boolean showAddableOnly = prefs instanceof BOpcUaClientPointDiscoveryPreferences && ((BOpcUaClientPointDiscoveryPreferences)prefs).getShowAddableOnly();
        return this.getOpcUaClientDevice().getLearnedPoints(showAddableOnly);
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NPointManager");
        return list;
    }

    public void changed(Property property, Context context) {
        if (this.subscription != null && (property.equals(publishInterval) || property.equals(maxKeepAliveCount))) {
            try {
                this.subscription.setPublishingInterval((double)this.getPublishInterval());
                this.subscription.setMaxKeepAliveCount(this.getMaxKeepAliveCount());
                this.subscription.setLifetimeCount(this.getMaxKeepAliveCount() * 5L);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Error while modifying subscription", e);
                }
                logger.log(Level.SEVERE, "Error while modifying subscription: " + e.getMessage());
            }
            try {
                this.subscription.getClient().reconnect();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Error while reconnecting client after modifying subscription", e);
                }
                logger.log(Level.SEVERE, "Error while reconnecting client after modifying subscription: " + e.getMessage());
            }
        }
        super.changed(property, context);
    }

    public Subscription getSubscription() {
        if (this.subscription != null) {
            UaClient client = this.subscription.getClient();
            if (client == this.getOpcUaClientDevice().uaClient) {
                return this.subscription;
            }
            this.subscription = null;
        }
        this.subscription = new Subscription();
        try {
            this.subscription.setPublishingInterval((double)this.getPublishInterval());
            this.subscription.setMaxKeepAliveCount(this.getMaxKeepAliveCount());
            this.subscription.setLifetimeCount(this.getMaxKeepAliveCount() * 5L);
            this.subscription.addAliveListener((SubscriptionAliveListener)new OpcUaSubscriptionAliveListener());
            OpcUaClientUtil.addSubscription(this.getOpcUaClientDevice().uaClient, this.subscription);
        }
        catch (ServiceException e) {
            logger.severe("Error while adding a Subscription :" + e.getMessage());
        }
        return this.subscription;
    }
}

