/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.sys;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.json.JAppWriter;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.sys.AceException;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.sys.BAceSpace;
import com.tridium.nre.util.FileLockException;
import com.tridium.sys.engine.EngineUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIComponentFile;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BSubSpaceFile;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BIJsonFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType(ext={@FileExt(name="ace")})
public class BAceAppFile
extends BSubSpaceFile
implements BIComponentFile,
BIJsonFile {
    public static final Type TYPE = Sys.loadType(BAceAppFile.class);
    private Catalog catalog = null;
    private static final BIcon icon = BIcon.std((String)"objectFile.png");
    private static final BIcon dirtyIcon = BIcon.std((String)"objectFileDirty.png");
    public static final Logger LOG = Logger.getLogger("AceNetwork");
    public static Lexicon lex = Lexicon.make((String)"ace");

    public Type getType() {
        return TYPE;
    }

    public BAceAppFile(BIFileStore store) {
        super(store);
    }

    public BAceAppFile() {
    }

    public void initialize(String appName, FilePath appFilePath, BAceApp defaultAceApp, Context cx, Catalog cat) throws Exception {
        BIFile appFileInstance = BFileSystem.INSTANCE.makeFile(appFilePath, cx);
        this.setStore(appFileInstance.getStore());
        this.catalog = cat;
        if (defaultAceApp != null) {
            JAppWriter appWriter = new JAppWriter();
            appWriter.encode(appFileInstance.getOutputStream(), defaultAceApp, cat);
        } else {
            Version appVersion = new Version("0.1");
            this.writeEmptyAppFile(appFileInstance.getOutputStream(), appName, appVersion);
        }
    }

    private void writeEmptyAppFile(OutputStream out, String appName, Version appVersion) throws IOException {
        long coreSysChecksum = 0L;
        String coreSysKitName = "core.sys";
        for (CatalogKit kit : this.catalog.kits()) {
            if (!kit.name().equals(coreSysKitName)) continue;
            coreSysChecksum = kit.getChecksum();
            break;
        }
        OutputStreamWriter sw = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        sw.write("{\n  \"comps\": [{\n");
        sw.write("    \"children\": [],\n");
        sw.write("    \"props\": [],\n");
        sw.write("    \"id\": 0,\n");
        sw.write("    \"name\": \"" + appName + "\",\n");
        sw.write("    \"type\": { \"kitName\": \"core.sys\", \"name\": \"App\" }\n");
        sw.write("  }],\n");
        sw.write("  \"kits\": [{ \"checksum\": " + coreSysChecksum + ", \"name\": \"core.sys\" }],\n");
        sw.write("  \"links\": [],\n");
        sw.write("  \"version\": \"" + appVersion + "\"\n}");
        sw.close();
    }

    public BAceSpace getAceSpace() {
        return (BAceSpace)this.getSubSpace();
    }

    public boolean isModified() {
        BAceSpace aceSpace = (BAceSpace)this.getSubSpace();
        return aceSpace != null && aceSpace.isModified();
    }

    protected BSpace doOpen() {
        BAceSpace aceSpace = new BAceSpace(this);
        try {
            aceSpace.checkLock();
            BAceApp root = this.loadAceApp();
            aceSpace.setRootComponent(root);
            EngineUtil.activateLinks((BComponent)root);
        }
        catch (AceException | FileLockException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AceException(lex.getText("json.appLoadError", new Object[]{this.getFileName()}), e);
        }
        aceSpace.setModified(false);
        return aceSpace;
    }

    protected void doSave() throws Exception {
        BAceSpace aceSpace = this.getAceSpace();
        if (aceSpace == null) {
            return;
        }
        BAceApp aceApp = aceSpace.getRootComponent();
        if (aceApp.getAutoForceOrder()) {
            aceApp.doForceExeOrder();
        }
        aceSpace.save();
    }

    protected void doClose() {
        BAceSpace aceSpace = this.getAceSpace();
        if (aceSpace != null) {
            aceSpace.close();
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("webEditors:TextFileEditor");
        return agents;
    }

    public Mark readComponents() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<BAceComponent> values = new ArrayList<BAceComponent>();
        BAceApp root = this.loadAceApp();
        for (BComponent child : root.getChildComponents()) {
            if (!(child instanceof BAceComponent)) continue;
            names.add(((BAceComponent)child).getName());
            values.add((BAceComponent)child);
        }
        return new Mark(values.toArray(new BObject[values.size()]), names.toArray(new String[names.size()]));
    }

    private BAceApp loadAceApp() throws Exception {
        JAppReader aceAppReader = new JAppReader();
        Catalog cat = aceAppReader.decodeCatalog(this.getInputStream());
        BAceApp aceApp = aceAppReader.loadAceApp(this.getInputStream(), cat);
        this.catalog = cat;
        return aceApp;
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)(this.getAbsoluteOrd().toString() + "|ace:|slot:/"));
    }

    public BIcon getIcon() {
        return this.isModified() ? dirtyIcon : icon;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }
}

