/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.program;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.app.App;
import com.tridium.ace.component.AceUtil;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAceDownloadParams;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.program.AceFileUtil;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.util.LicenseUtil;
import com.tridium.driver.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="getMissingModules", returnType="BString", flags=4)
public class BAceAppDownloadJob
extends BSimpleJob {
    public static final Action getMissingModules = BAceAppDownloadJob.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAceAppDownloadJob.class);
    private BAceNetwork ace;
    private BAceDownloadParams param;
    private boolean errors = false;
    private boolean successes = false;
    private String unloadedModules = null;

    public BString getMissingModules() {
        return (BString)this.invoke(getMissingModules, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAceAppDownloadJob() {
    }

    public BAceAppDownloadJob(BAceNetwork ace, BAceDownloadParams param) {
        this.ace = ace;
        this.param = param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        try {
            BAceDevice[] devs;
            byte[] bin = this.param.getData().copyBytes();
            if (this.param.getCheckMissingModules()) {
                JAppReader aceAppReader = new JAppReader(true);
                Catalog catalog = aceAppReader.decodeCatalog(new ByteArrayInputStream(bin));
                if (catalog == null) {
                    this.errors = true;
                    throw new Exception("catalog does not exist");
                }
                App app = aceAppReader.decode(new ByteArrayInputStream(bin), catalog);
                HashMap<Integer, BAceComponent> aceComponents = new HashMap<Integer, BAceComponent>();
                BAceApp aceApp = aceAppReader.buildComponentTree(app, aceComponents, catalog);
                int limit = LicenseUtil.getComponentLimit();
                if (aceApp.getComponentCnt() > limit) {
                    this.errors = true;
                    throw new Exception("There are more components than license permits");
                }
                this.unloadedModules = aceAppReader.verifyTypes();
                if (this.unloadedModules.length() > 1) {
                    this.errors = true;
                    throw new Exception("missing modules");
                }
            }
            for (BAceDevice dev : devs = this.getDevices(this.param.getAddressList())) {
                if (dev == null) continue;
                try {
                    if (dev.get("App") != null) {
                        dev.remove("App");
                        AceUtil.asyncWait(dev.getAceNetwork());
                    }
                    Object limit = dev.lock;
                    synchronized (limit) {
                        AceFileUtil.writeFile(dev, this.param.getFileName(), bin);
                        dev.implRestart();
                    }
                    dev.getPoints().implForceUpdate();
                    this.log().message("Downloaded " + dev.getDisplayName(null));
                    this.successes = true;
                }
                catch (Throwable e) {
                    this.log().failed("Failed to download " + dev.getDisplayName(null), e);
                    this.errors = true;
                }
            }
        }
        catch (Throwable e) {
            this.log().failed("General download failure", e);
        }
        if (this.errors && !this.successes) {
            throw new Exception("Download failed");
        }
        if (this.errors && this.successes) {
            throw new Exception("Download completed with failures");
        }
    }

    private BAceDevice[] getDevices(String s) throws Exception {
        BOrd[] ords = (BOrd[])StringUtil.getSimpleArray((String)s, (BSimple)BOrd.NULL);
        BAceDevice[] devs = new BAceDevice[ords.length];
        for (int i = 0; i < ords.length; ++i) {
            devs[i] = (BAceDevice)ords[i].resolve((BObject)this.ace).getComponent();
        }
        return devs;
    }

    public BString doGetMissingModules() {
        if (this.unloadedModules == null) {
            return null;
        }
        return BString.make((String)this.unloadedModules);
    }
}

