/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.program;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.enums.BAceFileTransferDirectionEnum;
import com.tridium.ace.message.AceError;
import com.tridium.ace.message.AceFileRead;
import com.tridium.ace.message.AceFileReadResp;
import com.tridium.ace.message.AceFileTransferInit;
import com.tridium.ace.message.AceFileTransferInitResp;
import com.tridium.ace.message.AceFileWrite;
import com.tridium.ace.message.AceFileWriteResp;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.ErrUtil;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;

public class AceFileUtil {
    private static final int MAX_PACKET_SIZE = 1024;

    public static void writeFile(BAceDevice dev, String fileName, byte[] file) throws Exception {
        AceFileUtil.writeFile(dev, fileName, file, 0, file.length);
    }

    public static void writeFile(BAceDevice dev, String fileName, byte[] file, int offset, int lenToSend) throws Exception {
        if (lenToSend == 0) {
            throw new Exception("Zero length file");
        }
        int sessionId = dev.getNextSessionId();
        int maxPacketSize = 1024;
        NComm comm = dev.getAceNetwork().ncomm();
        AceFileTransferInit initMsg = AceFileTransferInit.make(fileName, BAceFileTransferDirectionEnum.downLoad, sessionId, lenToSend, maxPacketSize);
        initMsg.setAddress(dev.getAddress());
        AceMessage rsp = (AceMessage)comm.sendRequest((NMessage)initMsg);
        if (rsp.isError()) {
            throw new Exception("Unable to read file " + ErrUtil.errToString(((AceError)rsp).err));
        }
        AceFileTransferInitResp initRsp = (AceFileTransferInitResp)rsp;
        if (initRsp.len < lenToSend) {
            throw new Exception("Device limit file length to " + initRsp.len);
        }
        maxPacketSize = initRsp.maxPacketSize;
        int sentLen = 0;
        int packetSequence = 1;
        while (sentLen < lenToSend) {
            int pktLen = lenToSend - sentLen;
            if (pktLen > maxPacketSize) {
                pktLen = maxPacketSize;
            }
            AceFileWrite ftMsg = AceFileWrite.make(sessionId, packetSequence, pktLen, file, offset + sentLen);
            ftMsg.setAddress(dev.getAddress());
            rsp = (AceMessage)comm.sendRequest((NMessage)ftMsg);
            if (rsp.isError()) {
                throw new Exception("Received failed response");
            }
            AceFileWriteResp ftRsp = (AceFileWriteResp)rsp;
            if (ftRsp.sequence != packetSequence) {
                throw new Exception("Received invalid sequence");
            }
            sentLen += pktLen;
            ++packetSequence;
        }
    }

    public static byte[] readFile(BAceDevice dev, String fileName) throws Exception {
        int sessionId = dev.getNextSessionId();
        int maxMsgSize = 1024;
        NComm comm = dev.getAceNetwork().ncomm();
        AceFileTransferInit initMsg = AceFileTransferInit.make(fileName, BAceFileTransferDirectionEnum.upLoad, sessionId, 0, maxMsgSize);
        initMsg.setAddress(dev.getAddress());
        AceMessage rsp = (AceMessage)comm.sendRequest((NMessage)initMsg);
        if (rsp.isError()) {
            throw new Exception("Unable to read file " + ErrUtil.errToString(((AceError)rsp).err));
        }
        AceFileTransferInitResp initRsp = (AceFileTransferInitResp)rsp;
        maxMsgSize = initRsp.maxPacketSize;
        int fileLen = initRsp.len;
        int sequence = 1;
        boolean done = false;
        byte[] file = new byte[fileLen];
        int bytesRcvd = 0;
        while (!done) {
            AceFileRead rdMsg = AceFileRead.make(sessionId, sequence++);
            rdMsg.setAddress(dev.getAddress());
            rsp = (AceMessage)comm.sendRequest((NMessage)rdMsg);
            if (rsp.isError()) {
                throw new Exception("Unable to read file " + ErrUtil.errToString(((AceError)rsp).err));
            }
            AceFileReadResp rdRsp = (AceFileReadResp)rsp;
            if (bytesRcvd + rdRsp.len > fileLen) {
                throw new Exception("To many bytes received.");
            }
            System.arraycopy(rdRsp.data, 0, file, bytesRcvd, rdRsp.len);
            bytesRcvd += rdRsp.len;
            done = rdRsp.done;
        }
        if (bytesRcvd != fileLen) {
            throw new Exception("To few bytes received.");
        }
        return file;
    }
}

