/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.AceUtil;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.datatypes.InvalidTypeException;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.message.AceInvoke;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceObjPropValue;
import com.tridium.ace.point.BAcePointDeviceExt;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.util.SfUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3, facets={@Facet(value="SfUtil.incl()")}, override=true), @NiagaraProperty(name="compName", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="propName", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="compId", type="int", defaultValue="0", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="propId", type="int", defaultValue="0", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="dataType", type="BAcePrimitiveTypeEnum", defaultValue="BAcePrimitiveTypeEnum.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="slotType", type="BAceSlotTypeEnum", defaultValue="BAceSlotTypeEnum.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}), @NiagaraProperty(name="readValue", type="BStatusValue", defaultValue="new BStatusNumeric()", flags=3, override=true), @NiagaraProperty(name="writeValue", type="BStatusValue", defaultValue="new BStatusNumeric()", flags=3, override=true)})
public class BAceProxyExt
extends BProxyExt
implements ICoalesceable {
    public static final Property faultCause = BAceProxyExt.newProperty((int)3, (String)"", (BFacets)SfUtil.incl());
    public static final Property compName = BAceProxyExt.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property propName = BAceProxyExt.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property compId = BAceProxyExt.newProperty((int)0, (int)0, (BFacets)SfUtil.incl((String)"un"));
    public static final Property propId = BAceProxyExt.newProperty((int)0, (int)0, (BFacets)SfUtil.incl((String)"un"));
    public static final Property dataType = BAceProxyExt.newProperty((int)0, (BValue)BAcePrimitiveTypeEnum.DEFAULT, (BFacets)SfUtil.incl((String)"un"));
    public static final Property slotType = BAceProxyExt.newProperty((int)0, (BValue)BAceSlotTypeEnum.DEFAULT, (BFacets)SfUtil.incl((String)"un"));
    public static final Property readValue = BAceProxyExt.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property writeValue = BAceProxyExt.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Type TYPE = Sys.loadType(BAceProxyExt.class);
    ProxyUtil proxyUtil = null;
    static Logger LOG = Logger.getLogger("AceNetwork");
    static Logger COV_LOG = BAceNetwork.COV_LOG;
    private long subscribeTime;

    public String getCompName() {
        return this.getString(compName);
    }

    public void setCompName(String v) {
        this.setString(compName, v, null);
    }

    public String getPropName() {
        return this.getString(propName);
    }

    public void setPropName(String v) {
        this.setString(propName, v, null);
    }

    public int getCompId() {
        return this.getInt(compId);
    }

    public void setCompId(int v) {
        this.setInt(compId, v, null);
    }

    public int getPropId() {
        return this.getInt(propId);
    }

    public void setPropId(int v) {
        this.setInt(propId, v, null);
    }

    public BAcePrimitiveTypeEnum getDataType() {
        return (BAcePrimitiveTypeEnum)this.get(dataType);
    }

    public void setDataType(BAcePrimitiveTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    public BAceSlotTypeEnum getSlotType() {
        return (BAceSlotTypeEnum)this.get(slotType);
    }

    public void setSlotType(BAceSlotTypeEnum v) {
        this.set(slotType, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BAceNetwork ace() {
        return (BAceNetwork)this.getNetwork();
    }

    public final BAceDevice dev() {
        return (BAceDevice)DrUtil.getParent((BComplex)this, (Type)BAceDevice.TYPE);
    }

    public final BAcePointDeviceExt getAcePointDeviceExt() {
        return (BAcePointDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        if (this.getSlotType().isAction()) {
            this.readOk((BStatusValue)new BStatusBoolean(false, BStatus.nullStatus));
        } else {
            this.getAcePointDeviceExt().proxyChanged();
            this.ace().postAsync(new Runnable(){

                @Override
                public void run() {
                    BAceProxyExt.this.extStarted();
                }
            });
        }
    }

    private void extStarted() {
        BStatusValue sv = this.doRead();
        if (this.getMode().isWrite()) {
            if (sv != null) {
                this.setWriteValue(sv);
            }
            this.setCompPropReadonly(true);
        }
    }

    public void stopped() throws Exception {
        if (!this.getSlotType().isAction()) {
            this.getAcePointDeviceExt().proxyChanged();
        }
        if (this.getMode().isWrite()) {
            this.setCompPropReadonly(false);
        }
        super.stopped();
    }

    private void setCompPropReadonly(boolean readonly) {
        BAceComponent comp = this.dev().getComponent(this.getCompId());
        if (comp != null) {
            comp.setReadonly(this.getPropId(), readonly);
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(compId) || p.equals(propId)) {
            this.getAcePointDeviceExt().proxyChanged();
        }
        if (p.equals(status) && this.getStatus().isStale()) {
            this.read();
        }
    }

    public void setStale(boolean stale, Context cx) {
        super.setStale(stale, cx);
        if (stale) {
            this.read();
        }
    }

    public void read() {
        this.ace().postAsync(new Runnable(){

            @Override
            public void run() {
                BAceProxyExt.this.doRead();
            }
        });
    }

    private BStatusValue doRead() {
        try {
            AceObjPropValue[] opvs = AceUtil.readProps(this.dev().comm(), this.dev().getAddress(), this.getCompId(), this.getPropId());
            return this.receiveUpdate(opvs[0].primVal);
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }

    public boolean write(Context cx) throws Exception {
        if (this.getSlotType().isAction()) {
            return false;
        }
        BStatus st = this.getStatus();
        if (st.isDown() || st.isDisabled() || !this.dev().getStatus().isValid() || !this.getParentPoint().isWritablePoint()) {
            return false;
        }
        BAcePrimitive pv = this.getPrimitiveValue();
        this.dev().getWriteWorker().write(this.getCompId(), this.getPropId(), pv, this);
        return true;
    }

    public boolean invokeProxyAction() throws Exception {
        if (!this.getSlotType().isAction()) {
            return false;
        }
        BStatus st = this.getStatus();
        if (st.isDown() || st.isDisabled() || !this.dev().getStatus().isValid()) {
            return false;
        }
        AceInvoke msg = AceInvoke.make(this.getCompId(), this.getPropId());
        msg.setAddress(this.dev().getAddress());
        AceMessage resp = (AceMessage)this.dev().comm().sendRequest((NMessage)msg);
        return resp.isError();
    }

    public boolean invokeProxyAction(BStatusValue parameter) throws Exception {
        if (!this.getSlotType().isAction()) {
            return false;
        }
        BStatus st = this.getStatus();
        if (st.isDown() || st.isDisabled() || !this.dev().getStatus().isValid()) {
            return false;
        }
        BAcePrimitive pv = BAcePrimitive.make(this.getDataType(), (BValue)parameter);
        AceInvoke msg = AceInvoke.make(this.getCompId(), this.getPropId(), pv);
        msg.setAddress(this.dev().getAddress());
        AceMessage resp = (AceMessage)this.dev().comm().sendRequest((NMessage)msg);
        return resp.isError();
    }

    public BStatusValue receiveUpdate(BAcePrimitive val) {
        try {
            BStatusValue sv = this.getProxyUtil().getStatusValue(val);
            this.readOk(sv);
            return sv;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error in AceNumericProxyExt: ", e);
            this.readFail(e.getMessage());
            return null;
        }
    }

    BAcePrimitive getPrimitiveValue() {
        return this.getPrimitiveValueWithStatus(this.getWriteValue().getStatus());
    }

    BAcePrimitive getRelinquishValue() {
        return this.getPrimitiveValueWithStatus(BStatus.makeNull((BStatus)this.getWriteValue().getStatus(), (boolean)true));
    }

    private BAcePrimitive getPrimitiveValueWithStatus(BStatus status) {
        BAcePrimitiveTypeEnum dataType = this.getDataType();
        ProxyUtil pu = this.getProxyUtil();
        if (pu == null) {
            return null;
        }
        switch (dataType.getOrdinal()) {
            case 0: {
                return BAcePrimitive.makeNull();
            }
            case 1: {
                return BAcePrimitive.makeBoolean(pu.getBool());
            }
            case 2: {
                return BAcePrimitive.makeU8(pu.getInt());
            }
            case 3: {
                return BAcePrimitive.makeU16(pu.getInt());
            }
            case 4: {
                return BAcePrimitive.makeS32(pu.getInt());
            }
            case 5: {
                return BAcePrimitive.makeS64(pu.getLong());
            }
            case 6: {
                return BAcePrimitive.makeF32(pu.getFloat());
            }
            case 7: {
                return BAcePrimitive.makeF64(pu.getDouble());
            }
            case 8: {
                return BAcePrimitive.makeStatusBool(new BStatusBoolean(pu.getBool(), status));
            }
            case 9: {
                return BAcePrimitive.makeStatusInt(status, pu.getLong());
            }
            case 10: 
            case 11: {
                return BAcePrimitive.makeStatusDouble(new BStatusNumeric(pu.getDouble(), status));
            }
        }
        LOG.severe("Invalid primitive type in AceNumericProxyExt: " + (Object)((Object)dataType));
        return null;
    }

    public void forceUpdate() {
        try {
            if (this.getParentPoint().isWritablePoint()) {
                this.writablePointActionInvoked();
                this.getParentPoint().doExecute();
            } else {
                this.doRead();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Type getDeviceExtType() {
        return BAcePointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public void readSubscribed(Context cx) throws Exception {
        if (this.getSlotType().isAction() || !Sys.isStation()) {
            return;
        }
        this.dev().covReg().add(this);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        if (this.getSlotType().isAction() || !Sys.isStation()) {
            return;
        }
        if (!Sys.getStation().isRunning()) {
            return;
        }
        this.dev().covReg().delete(this);
    }

    void reassertCov() {
        if (this.getSlotType().isAction()) {
            return;
        }
        if (this.getParentPoint().isSubscribed()) {
            this.dev().covReg().add(this);
        }
    }

    ProxyUtil getProxyUtil() {
        if (this.proxyUtil != null) {
            return this.proxyUtil;
        }
        this.proxyUtil = this.isBoolean() ? new BooleanUtil() : (this.isEnum() ? new EnumUtil() : new NumericUtil());
        return this.proxyUtil;
    }

    public Object getCoalesceKey() {
        return new Integer((this.getPropId() << 13) + this.getCompId());
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    class EnumUtil
    extends ProxyUtil {
        EnumUtil() {
        }

        @Override
        BStatusValue getStatusValue(BAcePrimitive val) throws InvalidTypeException {
            int n;
            BAcePrimitiveTypeEnum typ = BAceProxyExt.this.getDataType();
            BStatus st = typ.isStatus() ? val.getStatus() : BStatus.ok;
            switch (typ.getOrdinal()) {
                case 2: 
                case 3: 
                case 4: 
                case 9: {
                    n = val.getInt();
                    break;
                }
                case 5: {
                    n = (int)val.getLong();
                    break;
                }
                case 6: 
                case 10: {
                    n = (int)val.getFloat();
                    break;
                }
                case 7: 
                case 11: {
                    n = (int)val.getDouble();
                    break;
                }
                default: {
                    LOG.severe("Invalid primitive type in AceNumericProxyExt: " + (Object)((Object)typ));
                    throw new InvalidTypeException(typ.getTag());
                }
            }
            BEnumRange er = (BEnumRange)BAceProxyExt.this.getDeviceFacets().getFacet("range");
            return new BStatusEnum((BEnum)BDynamicEnum.make((int)n, (BEnumRange)er), st);
        }

        @Override
        boolean getBool() {
            return this.getInt() != 0;
        }

        @Override
        int getInt() {
            return ((BStatusEnum)BAceProxyExt.this.getWriteValue()).getValue().getOrdinal();
        }

        @Override
        long getLong() {
            return this.getInt();
        }

        @Override
        float getFloat() {
            return this.getInt();
        }

        @Override
        double getDouble() {
            return this.getInt();
        }
    }

    class BooleanUtil
    extends ProxyUtil {
        BooleanUtil() {
        }

        @Override
        BStatusValue getStatusValue(BAcePrimitive val) throws InvalidTypeException {
            BAcePrimitiveTypeEnum typ = BAceProxyExt.this.getDataType();
            BStatus st = typ.isStatus() ? val.getStatus() : BStatus.ok;
            boolean b = false;
            switch (typ.getOrdinal()) {
                case 1: 
                case 8: {
                    b = val.getBoolean();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 9: {
                    b = val.getInt() != 0;
                    break;
                }
                case 5: {
                    b = val.getLong() != 0L;
                    break;
                }
                case 6: 
                case 10: {
                    b = (double)val.getFloat() != 0.0;
                    break;
                }
                case 7: 
                case 11: {
                    b = val.getDouble() != 0.0;
                    break;
                }
                default: {
                    LOG.severe("Invalid primitive type in AceBooleanProxyExt: " + (Object)((Object)typ));
                    throw new InvalidTypeException(typ.getTag());
                }
            }
            return new BStatusBoolean(b, st);
        }

        @Override
        boolean getBool() {
            return ((BStatusBoolean)BAceProxyExt.this.getWriteValue()).getValue();
        }

        @Override
        int getInt() {
            return this.getBool() ? 1 : 0;
        }

        @Override
        long getLong() {
            return this.getInt();
        }

        @Override
        float getFloat() {
            return this.getInt();
        }

        @Override
        double getDouble() {
            return this.getInt();
        }
    }

    class NumericUtil
    extends ProxyUtil {
        NumericUtil() {
        }

        @Override
        public BStatusValue getStatusValue(BAcePrimitive val) throws InvalidTypeException {
            double d;
            BAcePrimitiveTypeEnum typ = BAceProxyExt.this.getDataType();
            BStatus st = typ.isStatus() ? val.getStatus() : BStatus.ok;
            switch (typ.getOrdinal()) {
                case 1: 
                case 8: {
                    d = val.getBoolean() ? 1.0 : 0.0;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 9: {
                    d = val.getInt();
                    break;
                }
                case 5: {
                    d = val.getLong();
                    break;
                }
                case 6: 
                case 10: {
                    d = val.getFloat();
                    break;
                }
                case 7: 
                case 11: {
                    d = val.getDouble();
                    break;
                }
                default: {
                    LOG.severe("Invalid primitive type in AceNumericProxyExt: " + (Object)((Object)typ));
                    throw new InvalidTypeException(typ.getTag());
                }
            }
            return new BStatusNumeric(d, st);
        }

        @Override
        boolean getBool() {
            return this.getDouble() != 0.0;
        }

        @Override
        int getInt() {
            return (int)this.getDouble();
        }

        @Override
        long getLong() {
            return (long)this.getDouble();
        }

        @Override
        float getFloat() {
            return (float)this.getDouble();
        }

        @Override
        double getDouble() {
            return ((BStatusNumeric)BAceProxyExt.this.getWriteValue()).getValue();
        }
    }

    abstract class ProxyUtil {
        ProxyUtil() {
        }

        abstract BStatusValue getStatusValue(BAcePrimitive var1) throws InvalidTypeException;

        abstract boolean getBool();

        abstract int getInt();

        abstract long getLong();

        abstract float getFloat();

        abstract double getDouble();
    }
}

