/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.message;

import com.tridium.ace.enums.BAceMessageTypeEnum;
import com.tridium.ace.message.AceConst;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AceMessage
extends NMessage
implements AceConst {
    private static int ntag = 1;
    public static Object lock = new Object();
    int version = 1;
    int type;
    Integer tag;
    public static final int MAX_ASTRING_LENGTH = 255;
    public static final int MAX_COMP_NAME_LENGTH = 32;
    public static final int MAX_KIT_NAME_LENGTH = 64;
    public static final int MAX_TYPE_NAME_LENGTH = 32;
    public static final int MAX_SLOT_NAME_LENGTH = 32;
    public static final int MAX_PATH_DEPTH = 12;
    public static final int KIT_NAME_SEP_LEN = 2;
    public static final String ACE_PATH_DELIMITER = "/";

    public AceMessage() {
        this.setRetryCount(0);
    }

    public AceMessage(int typ) {
        this();
        this.type = typ;
    }

    public boolean toOutputStream(OutputStream out) throws Exception {
        TypedOutputStream to = (TypedOutputStream)out;
        to.writeUnsigned8(this.version);
        to.writeUnsigned8(this.type);
        to.writeUnsigned8(this.tag.intValue());
        this.toTypedOutputStream(to);
        return false;
    }

    protected abstract void toTypedOutputStream(TypedOutputStream var1);

    public void fromInputStream(InputStream in) throws Exception {
        TypedInputStream ti = (TypedInputStream)in;
        this.version = ti.readUnsigned8();
        this.type = ti.readUnsigned8();
        this.tag = new Integer(ti.readUnsigned8());
        this.fromTypedInputStream(ti);
    }

    protected abstract void fromTypedInputStream(TypedInputStream var1);

    public Object getTag() {
        return this.tag;
    }

    public boolean isResponse() {
        return (this.type & 0xC0) > 0;
    }

    public boolean isFragmentable() {
        return false;
    }

    public int getResponseTimeOut() {
        return 11000;
    }

    public String toString() {
        return this.toTraceString();
    }

    public String toTraceString() {
        StringBuffer sb = new StringBuffer();
        sb.append("v=").append(this.version);
        sb.append(" type=").append((Object)BAceMessageTypeEnum.make(this.type & 0x3F));
        if ((this.type & 0x80) > 0) {
            sb.append("{RESP}");
        }
        if ((this.type & 0x40) > 0) {
            sb.append("{ACE_ERROR}");
        }
        sb.append(" tag=").append(this.getTag());
        sb.append("\n");
        this.toTraceString(sb);
        return sb.toString();
    }

    protected abstract void toTraceString(StringBuffer var1);

    public int getType() {
        return this.type & 0x3F;
    }

    public boolean isError() {
        return (this.type & 0x40) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextTag() {
        Object object = lock;
        synchronized (object) {
            if (++ntag > 255) {
                ntag = 1;
            }
            this.tag = new Integer(ntag);
        }
    }
}

