/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.json;

import com.tridium.ace.app.AceApp;
import com.tridium.ace.app.AceAppReader;
import com.tridium.ace.app.AceComponent;
import com.tridium.ace.app.AceConfigValue;
import com.tridium.ace.app.AceLink;
import com.tridium.ace.app.App;
import com.tridium.ace.app.AppKit;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.json.JCatalogReader;
import com.tridium.ace.kit.ACE;
import com.tridium.ace.kit.AceSlot;
import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.sys.AceException;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class JAppReader
extends AceAppReader {
    private static Lexicon lex = Lexicon.make((String)"ace");
    private static final Logger LOG = Logger.getLogger("AceNetwork");
    public static final String LINK_SLOT_SEP = ".";
    public static final String PRODUCT_NAME = "product";
    public static final String VENDOR_NAME = "vendor";

    public JAppReader() {
    }

    public JAppReader(boolean online) {
        super(online);
    }

    @Override
    public App decode(InputStream inputStream, Catalog catalog) throws IOException {
        if (catalog == null) {
            throw new IOException(lex.getText("ace.getCatalogFailed"));
        }
        JSONTokener tok = new JSONTokener((Reader)new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        JSONObject appObj = new JSONObject(tok);
        return this.decode(appObj, catalog);
    }

    public App decode(JSONObject appObj, Catalog catalog) throws IOException {
        int i;
        AceApp aceApp = new AceApp();
        aceApp.setAceVersion(new Version(JSONUtil.getString((JSONObject)appObj, (String)"version")));
        HashSet<String> kitNames = new HashSet<String>();
        if (appObj.has("kits")) {
            JSONArray kits = appObj.getJSONArray("kits");
            for (i = 0; i < kits.length(); ++i) {
                JSONObject kit = kits.getJSONObject(i);
                AppKit jk = new AppKit();
                jk.setName(JSONUtil.getString((JSONObject)kit, (String)"name"));
                jk.setChecksum(kit.getLong("checksum"));
                aceApp.getKits().add(jk);
                kitNames.add(jk.getName());
            }
        }
        if (appObj.has("comps")) {
            JSONArray comps = appObj.getJSONArray("comps");
            for (i = 0; i < comps.length(); ++i) {
                JSONObject comp = comps.getJSONObject(i);
                AceComponent jc = this.parseAceComponent(catalog, comp, kitNames);
                aceApp.addComponent(jc);
            }
        }
        if (appObj.has("links")) {
            JSONArray links = appObj.getJSONArray("links");
            for (i = 0; i < links.length(); ++i) {
                JSONObject link = links.getJSONObject(i);
                AceLink jl = new AceLink(JSONUtil.getString((JSONObject)link, (String)"from"), JSONUtil.getString((JSONObject)link, (String)"to"));
                aceApp.getLinks().add(jl);
            }
        }
        return aceApp;
    }

    @Override
    public Catalog decodeCatalog(InputStream inputStream) throws Exception {
        String product;
        String vendor;
        JSONTokener tok = new JSONTokener((Reader)new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        JSONObject root = new JSONObject(tok);
        try {
            vendor = JSONUtil.getString((JSONObject)root, (String)VENDOR_NAME);
            product = JSONUtil.getString((JSONObject)root, (String)PRODUCT_NAME);
        }
        catch (JSONException e) {
            return ACE.getDefaultRegistryCatalog();
        }
        String def = "aceCatalog." + vendor + LINK_SLOT_SEP + product;
        String address = Sys.getRegistry().getDef(def);
        if (address == null) {
            LOG.info(lex.getText("ace.getCatalogFailed"));
            return ACE.getDefaultRegistryCatalog();
        }
        return ACE.getKitRegistry(address);
    }

    private AceComponent parseAceComponent(Catalog catalog, JSONObject compObj, Set<String> kitNames) {
        int j;
        AceComponent jc = new AceComponent();
        jc.setId(compObj.getInt("id"));
        jc.setName(JSONUtil.getString((JSONObject)compObj, (String)"name"));
        JSONObject aceTypeObject = compObj.getJSONObject("type");
        jc.setType(JSONUtil.getString((JSONObject)aceTypeObject, (String)"name"));
        jc.setKitName(JSONUtil.getString((JSONObject)aceTypeObject, (String)"kitName"));
        if (!kitNames.contains(jc.getKitName())) {
            throw new AceException(lex.getText("json.componentKitError", new Object[]{jc.getName(), jc.getKitName()}));
        }
        CatalogKit kit = catalog.get(jc.getKitName());
        if (kit == null) {
            throw new AceException(lex.getText("json.componentRegistryKitError", new Object[]{jc.getName(), jc.getKitName()}));
        }
        AceType at = kit.type(jc.getType());
        this.getTypeListFromFacets(at);
        if (compObj.has("props")) {
            JSONArray configs = compObj.getJSONArray("props");
            for (j = 0; j < configs.length(); ++j) {
                BStatus st;
                AceSlot configSlot;
                JSONObject config = configs.getJSONObject(j);
                String configName = JSONUtil.getString((JSONObject)config, (String)"name");
                AceType aceType = kit.type(jc.getType());
                if (aceType == null || (configSlot = aceType.getSlot(configName)) == null) continue;
                BAcePrimitiveTypeEnum pType = configSlot.getPrimType();
                Object configValue = config.get("value");
                BValue convertedValue = JCatalogReader.defaultJSONValue(configValue, st = config.has("status") ? BStatus.make((int)config.getInt("status")) : BStatus.nullStatus, pType);
                if (convertedValue == null) continue;
                AceConfigValue jconf = new AceConfigValue(pType, convertedValue);
                jc.getConfigs().put(configName, jconf);
                this.addTypeList(convertedValue, configSlot.getFacets().toFacets());
            }
        }
        if (compObj.has("children")) {
            JSONArray children = compObj.getJSONArray("children");
            for (j = 0; j < children.length(); ++j) {
                JSONObject childObj = children.getJSONObject(j);
                AceComponent child = this.parseAceComponent(catalog, childObj, kitNames);
                jc.getChildren().add(child);
            }
        }
        return jc;
    }
}

