/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.expr;

import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.expr.AceExpressionException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Stack;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Lexicon;

public class ExprUtil {
    private static final int OPERAND = 1;
    private static final int OPERATION = 2;
    private static final int QUALIFIER = 3;
    private static final int FUNCTION = 4;
    private static final int OPENPAREN = 5;
    private static final int CLOSEPAREN = 6;
    private static final int ARGSEPERAT = 7;
    private static final int ASCLOSE = 8;
    private static final int DESTINAT = 9;
    private static final int EXPREND = 10;
    private ExpressionReader parser;
    private String[] inputs;
    private String[] outputs;
    private boolean[] usedOuts = new boolean[]{false, false, false, false};
    private ByteArrayOutputStream ops;
    private Stack<Operation> opStack = new Stack();
    private int currentLevel = 0;
    private int stackCount = 0;
    private int maxEquationLength;
    private int maxOpCodesLength;
    private static Lexicon LEX = BAceNetwork.LEX;

    public ExprUtil(BAceComponent exprComp) throws AceExpressionException {
        this.init(exprComp);
    }

    private void init(BAceComponent exprComp) {
        Property p;
        ArrayList<String> inList = new ArrayList<String>(16);
        ArrayList<String> outList = new ArrayList<String>(4);
        SlotCursor c = exprComp.getProperties();
        while (c.next()) {
            p = c.property();
            BFacets f = p.getFacets();
            if (f.get("pId") == null) continue;
            String n = p.getName();
            if (n.startsWith("in")) {
                inList.add(n);
                continue;
            }
            if (!n.startsWith("out")) continue;
            outList.add(p.getName());
        }
        this.inputs = inList.toArray(new String[inList.size()]);
        this.outputs = outList.toArray(new String[outList.size()]);
        if (this.inputs.length > 16) {
            ExprUtil.exception(LEX.get("ace.expression.maxInputs"), null);
        }
        if (this.outputs.length > 4) {
            ExprUtil.exception(LEX.get("ace.expression.maxOutputs"), null);
        }
        p = exprComp.getProperty("opCodes");
        this.maxOpCodesLength = p.getFacets().geti("length", 0);
        p = exprComp.getProperty("expr");
        this.maxEquationLength = p.getFacets().geti("length", 0);
        this.ops = new ByteArrayOutputStream(256);
        this.parser = new ExpressionReader();
    }

    public ExprUtil(String[] ins, String[] outs) throws AceExpressionException {
        this.inputs = ins;
        this.outputs = outs;
        this.maxOpCodesLength = 128;
        this.maxEquationLength = 256;
        this.ops = new ByteArrayOutputStream(256);
        this.parser = new ExpressionReader();
    }

    public byte[] convertToOpCodes(String expr) throws AceExpressionException {
        if (expr.length() > this.maxEquationLength) {
            throw new AceExpressionException(LEX.get("ace.expression.maxExprLen"));
        }
        this.currentLevel = 0;
        this.stackCount = 0;
        for (int i = 0; i < this.usedOuts.length; ++i) {
            this.usedOuts[i] = false;
        }
        this.parser.reset(expr);
        this.ops.reset();
        this.opStack.clear();
        byte[] ops = this.parse();
        if (ops.length > this.maxOpCodesLength) {
            throw new AceExpressionException(LEX.get("maxOpCodeLen"));
        }
        return ops;
    }

    private byte[] parse() throws AceExpressionException {
        ExpressionElement elem = new ExprBegin();
        ExpressionElement nxtElem = this.parser.getNext();
        while (nxtElem != null) {
            if (!elem.validNext(nxtElem = elem.qualify(nxtElem))) {
                if (nxtElem.type == 10) {
                    this.incomplete();
                } else {
                    ExprUtil.exception(LEX.get("ace.expression.invalidElement"), nxtElem);
                }
            }
            nxtElem.prevousType = elem.type;
            elem = nxtElem;
            elem.process();
            if (elem.type == 10) break;
            nxtElem = this.parser.getNext();
        }
        if (this.stackCount == 1) {
            if (this.usedOuts[0] || this.usedOuts[1] || this.usedOuts[2] || this.usedOuts[3]) {
                ExprUtil.exception(LEX.get("ace.expression.specifyAllOuts"), nxtElem);
            }
            this.ops.write(80);
            --this.stackCount;
        }
        if (!this.opStack.empty() || this.ops.size() == 0 || this.stackCount != 0 || this.currentLevel != 0) {
            this.incomplete();
        }
        this.ops.write(0);
        return this.ops.toByteArray();
    }

    void processOps(Operation current) {
        if (this.opStack.empty()) {
            return;
        }
        int prec = current != null ? this.getPrecedence(current) : 0;
        int level = this.currentLevel;
        while (this.opStack.peek().level == level && this.getPrecedence(this.opStack.peek()) >= prec) {
            this.opStack.pop().write();
            if (!this.opStack.empty()) continue;
            break;
        }
    }

    int getPrecedence(Operation op) {
        int opCode = op.operation;
        switch (opCode) {
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 48: {
                return 13;
            }
            case 34: 
            case 35: 
            case 37: {
                return 12;
            }
            case 32: 
            case 33: {
                return 11;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                return 9;
            }
            case 49: 
            case 50: {
                return 8;
            }
            case 51: {
                return 4;
            }
            case 52: {
                return 3;
            }
        }
        ExprUtil.exception(LEX.get("ace.expression.invalidOp"), op);
        return 0;
    }

    ExpressionElement makeQualifier(ExpressionElement ee) {
        Qualifier qual;
        if (ee.type != 2) {
            return ee;
        }
        int operation = ((Operation)ee).operation;
        if (operation == 33) {
            qual = new Qualifier(36);
        } else if (operation == 48) {
            qual = new Qualifier(48);
        } else {
            return ee;
        }
        qual.line = ee.line;
        qual.linePos = ee.linePos;
        qual.level = ee.level;
        return qual;
    }

    static void exception(String msg, ExpressionElement ee) {
        ExprUtil.exception(msg, ee.line, ee.linePos);
    }

    static void exception(String msg, int line, int linePos) {
        throw new AceExpressionException(msg + ":" + (line > 0 ? "line " + (line + 1) + " " : "") + " pos = " + linePos);
    }

    void incomplete() {
        throw new AceExpressionException(LEX.get("ace.expression.incomplete"));
    }

    class ExprEnd
    extends ExpressionElement {
        ExprEnd() {
            this.type = 10;
        }

        @Override
        void process() {
            ExprUtil.this.processOps(null);
        }
    }

    class Destination
    extends ExpressionElement {
        int output;

        Destination(int outpt) {
            this.type = 9;
            this.output = outpt;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 5 || nxt.type == 3 || nxt.type == 4 || nxt.type == 10;
        }

        @Override
        void process() {
            if (ExprUtil.this.usedOuts[this.output]) {
                ExprUtil.exception(LEX.get("ace.expression.secondUse") + ExprUtil.this.outputs[this.output], this);
            }
            ((ExprUtil)ExprUtil.this).usedOuts[this.output] = true;
            ExprUtil.this.ops.write(80 + this.output);
            ExprUtil.this.stackCount--;
            if (!ExprUtil.this.opStack.empty() || ExprUtil.this.ops.size() == 0 || ExprUtil.this.stackCount != 0 || ExprUtil.this.currentLevel != 0) {
                ExprUtil.this.incomplete();
            }
        }

        @Override
        ExpressionElement qualify(ExpressionElement ee) {
            return ExprUtil.this.makeQualifier(ee);
        }
    }

    class AsClose
    extends ExpressionElement {
        AsClose() {
            this.type = 8;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 9;
        }

        @Override
        void process() {
            ExprUtil.this.processOps(null);
        }
    }

    class ArgSeperator
    extends ExpressionElement {
        ArgSeperator() {
            this.type = 7;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 3 || nxt.type == 4 || nxt.type == 5;
        }

        @Override
        void process() {
            ExprUtil.this.processOps(null);
        }
    }

    class CloseParen
    extends ExpressionElement {
        CloseParen() {
            this.type = 6;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 2 || nxt.type == 5 || nxt.type == 6 || nxt.type == 7 || nxt.type == 10 || nxt.type == 8;
        }

        @Override
        void process() {
            if (ExprUtil.this.currentLevel <= 0) {
                ExprUtil.exception(LEX.get("ace.expression.unmatched"), this);
            }
            ExprUtil.this.processOps(null);
            ExprUtil.this.currentLevel--;
        }
    }

    class OpenParen
    extends ExpressionElement {
        OpenParen() {
            this.type = 5;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 3 || nxt.type == 4 || nxt.type == 5;
        }

        @Override
        void process() {
            ExprUtil.this.currentLevel++;
        }

        @Override
        ExpressionElement qualify(ExpressionElement ee) {
            return ExprUtil.this.makeQualifier(ee);
        }
    }

    class Function
    extends Operation {
        int argsRequired;
        int initialStackCount;

        Function(int op, int args) {
            super(op);
            this.type = 4;
            this.operation = op;
            this.argsRequired = args;
            this.initialStackCount = ExprUtil.this.stackCount;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 5;
        }

        @Override
        void write() {
            int args = ExprUtil.this.stackCount - this.initialStackCount;
            if (args > this.argsRequired) {
                ExprUtil.exception(LEX.get("ace.expression.toManyArgs"), this);
            }
            if (args < this.argsRequired) {
                ExprUtil.exception(LEX.get("ace.expression.toFewArgs"), this);
            }
            ExprUtil.this.stackCount = ExprUtil.this.stackCount - (this.argsRequired - 1);
            ExprUtil.this.ops.write(this.operation);
        }
    }

    class Qualifier
    extends Operation {
        Qualifier(int op) {
            super(op);
            this.type = 3;
            this.operation = op;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 5;
        }

        @Override
        void write() {
            ExprUtil.this.ops.write(this.operation);
        }
    }

    class Operation
    extends ExpressionElement {
        int operation;

        Operation(int op) {
            this.type = 2;
            this.operation = op;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 3 || nxt.type == 4 || nxt.type == 5;
        }

        @Override
        ExpressionElement qualify(ExpressionElement ee) {
            return ExprUtil.this.makeQualifier(ee);
        }

        @Override
        void process() {
            ExprUtil.this.processOps(this);
            ExprUtil.this.opStack.push(this);
        }

        void write() {
            ExprUtil.this.stackCount--;
            ExprUtil.this.ops.write(this.operation);
        }
    }

    class Operand
    extends ExpressionElement {
        boolean isNumber;
        String number;
        int input;

        Operand(String num) {
            this.isNumber = false;
            this.number = null;
            this.type = 1;
            this.isNumber = true;
            this.number = num;
        }

        Operand(int in) {
            this.isNumber = false;
            this.number = null;
            this.type = 1;
            this.isNumber = false;
            this.input = in;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 2 || nxt.type == 6 || nxt.type == 10 || nxt.type == 7 || nxt.type == 8;
        }

        @Override
        void process() {
            if (this.isNumber) {
                try {
                    byte[] da;
                    if (this.number.indexOf(46) > 0) {
                        double d = Double.parseDouble(this.number);
                        if (d > (double)1.4E-45f && d < 3.4028234663852886E38) {
                            ExprUtil.this.ops.write(67);
                            da = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putFloat((float)d).array();
                        } else {
                            ExprUtil.this.ops.write(68);
                            da = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putDouble(d).array();
                        }
                    } else {
                        long n = Long.parseLong(this.number);
                        if (n >= -128L && n <= 127L) {
                            ExprUtil.this.ops.write(64);
                            da = new byte[]{(byte)n};
                        } else if (n >= -32768L && n <= 32767L) {
                            ExprUtil.this.ops.write(65);
                            da = ByteBuffer.allocate(2).putShort((short)n).array();
                        } else if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
                            ExprUtil.this.ops.write(66);
                            da = ByteBuffer.allocate(4).putInt((int)n).array();
                        } else {
                            ExprUtil.this.ops.write(68);
                            da = ByteBuffer.allocate(8).putDouble(n).array();
                        }
                    }
                    for (byte b : da) {
                        ExprUtil.this.ops.write(b);
                    }
                }
                catch (NumberFormatException e) {
                    ExprUtil.exception(LEX.get("ace.expression.invalidNum"), this);
                }
            } else {
                ExprUtil.this.ops.write(16 + this.input);
            }
            ExprUtil.this.stackCount++;
        }
    }

    class ExprBegin
    extends ExpressionElement {
        ExprBegin() {
            this.type = 0;
        }

        @Override
        boolean validNext(ExpressionElement nxt) {
            return nxt.type == 1 || nxt.type == 3 || nxt.type == 4 || nxt.type == 5;
        }

        @Override
        ExpressionElement qualify(ExpressionElement ee) {
            return ExprUtil.this.makeQualifier(ee);
        }
    }

    class ExpressionElement {
        int line;
        int linePos;
        int level;
        int type;
        int prevousType;

        ExpressionElement() {
            this.line = ((ExprUtil)ExprUtil.this).parser.line;
            this.linePos = ((ExprUtil)ExprUtil.this).parser.nxtElmPos;
            this.level = ExprUtil.this.currentLevel;
        }

        boolean validNext(ExpressionElement nxt) {
            return false;
        }

        ExpressionElement qualify(ExpressionElement ee) {
            return ee;
        }

        void process() {
        }
    }

    class ExpressionReader {
        int length;
        char[] expr;
        int pos;
        int line;
        int nxtElmPos;
        int linePos;

        ExpressionReader() {
        }

        void reset(String expr) {
            this.expr = expr.toCharArray();
            this.length = expr.length();
            this.pos = 0;
            this.line = 0;
            this.linePos = 0;
            this.nxtElmPos = 0;
        }

        ExpressionElement getNext() {
            char c = this.read();
            while (c == ' ') {
                c = this.read();
            }
            this.nxtElmPos = this.linePos;
            if (c == '\u0000') {
                return new ExprEnd();
            }
            if (c == '(') {
                return new OpenParen();
            }
            if (c == ')') {
                return new CloseParen();
            }
            if (c == ',') {
                return new ArgSeperator();
            }
            if (c == '\'') {
                return this.getDestination();
            }
            if (Character.isDigit(c)) {
                return this.getNumber(c);
            }
            if (Character.isLetter(c)) {
                return this.getName(c);
            }
            ExpressionElement ee = this.getOperator(c);
            if (ee != null) {
                return ee;
            }
            ExprUtil.exception(LEX.get("ace.expression.parseFail"), this.line, this.nxtElmPos);
            return new ExprEnd();
        }

        private ExpressionElement getName(char c) {
            StringBuilder sb = new StringBuilder();
            sb.append(c);
            while (Character.isAlphabetic(this.peek()) || Character.isDigit(this.peek())) {
                sb.append(this.read());
            }
            String name = sb.toString();
            if (name.equalsIgnoreCase("and")) {
                return new Operation(51);
            }
            if (name.equalsIgnoreCase("or")) {
                return new Operation(52);
            }
            if (name.equalsIgnoreCase("not")) {
                return new Operation(48);
            }
            if (name.equalsIgnoreCase("as")) {
                return new AsClose();
            }
            if (name.equalsIgnoreCase("abs")) {
                return new Qualifier(38);
            }
            if (name.equalsIgnoreCase("sqrt")) {
                return new Qualifier(39);
            }
            if (name.equalsIgnoreCase("pow")) {
                return new Function(40, 2);
            }
            if (name.equalsIgnoreCase("if")) {
                return new Function(41, 3);
            }
            for (int i = 0; i < ExprUtil.this.inputs.length; ++i) {
                if (!name.equals(ExprUtil.this.inputs[i])) continue;
                return new Operand(i);
            }
            ExprUtil.exception(LEX.getText("ace.expression.invalidArg", new Object[]{name}), this.line, this.nxtElmPos);
            return null;
        }

        private ExpressionElement getDestination() {
            boolean complete = false;
            StringBuilder sb = new StringBuilder();
            while (this.peek() != '\u0000') {
                char c = this.read();
                if (c == '\'') {
                    complete = true;
                    break;
                }
                sb.append(c);
            }
            if (!complete) {
                ExprUtil.exception(LEX.get("ace.expression.incomplete"), this.line, this.nxtElmPos);
            }
            String name = sb.toString();
            for (int i = 0; i < ExprUtil.this.outputs.length; ++i) {
                if (!name.equals(ExprUtil.this.outputs[i])) continue;
                return new Destination(i);
            }
            ExprUtil.exception(LEX.getText("ace.expression.invalidArg", new Object[]{name}), this.line, this.nxtElmPos);
            return null;
        }

        private ExpressionElement getNumber(char c) {
            StringBuilder sb = new StringBuilder();
            sb.append(c);
            char nxt = this.peek();
            while (Character.isDigit(nxt) || "eE.-".indexOf(nxt) >= 0) {
                sb.append(this.read());
                nxt = this.peek();
            }
            Operand op = new Operand(sb.toString());
            return op;
        }

        private ExpressionElement getOperator(char c) {
            switch (c) {
                case '+': {
                    return new Operation(32);
                }
                case '-': {
                    return new Operation(33);
                }
                case '*': {
                    return new Operation(34);
                }
                case '/': {
                    return new Operation(35);
                }
                case '%': {
                    return new Operation(37);
                }
                case '!': {
                    if (this.peek() == '=') {
                        this.read();
                        return new Operation(50);
                    }
                    return new Qualifier(48);
                }
                case '=': {
                    if (this.peek() != '=') break;
                    this.read();
                    return new Operation(49);
                }
                case '&': {
                    if (this.peek() != '&') break;
                    this.read();
                    return new Operation(51);
                }
                case '|': {
                    if (this.peek() != '|') break;
                    this.read();
                    return new Operation(52);
                }
                case '>': {
                    if (this.peek() == '=') {
                        this.read();
                        return new Operation(54);
                    }
                    return new Operation(53);
                }
                case '<': {
                    if (this.peek() == '=') {
                        this.read();
                        return new Operation(56);
                    }
                    return new Operation(55);
                }
            }
            ExprUtil.exception(LEX.get("ace.expression.invalidOp"), this.line, this.nxtElmPos);
            return null;
        }

        private char read() {
            while (this.pos < this.length && this.expr[this.pos] == '\n') {
                ++this.pos;
                ++this.line;
                this.linePos = 0;
            }
            if (this.pos >= this.length) {
                return '\u0000';
            }
            ++this.linePos;
            return this.expr[this.pos++];
        }

        private char peek() {
            if (this.pos >= this.length) {
                return '\u0000';
            }
            return this.expr[this.pos];
        }
    }
}

