/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.enums;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="nullPrim", ordinal=0), @Range(value="bool", ordinal=1), @Range(value="u8", ordinal=2), @Range(value="u16", ordinal=3), @Range(value="s32", ordinal=4), @Range(value="s64", ordinal=5), @Range(value="f32", ordinal=6), @Range(value="f64", ordinal=7), @Range(value="statusBool", ordinal=8), @Range(value="statusInt", ordinal=9), @Range(value="statusFloat", ordinal=10), @Range(value="statusDouble", ordinal=11), @Range(value="byteArray", ordinal=12), @Range(value="string", ordinal=13)}, defaultValue="s32")
public final class BAcePrimitiveTypeEnum
extends BFrozenEnum {
    public static final int NULL_PRIM = 0;
    public static final int BOOL = 1;
    public static final int U_8 = 2;
    public static final int U_16 = 3;
    public static final int S_32 = 4;
    public static final int S_64 = 5;
    public static final int F_32 = 6;
    public static final int F_64 = 7;
    public static final int STATUS_BOOL = 8;
    public static final int STATUS_INT = 9;
    public static final int STATUS_FLOAT = 10;
    public static final int STATUS_DOUBLE = 11;
    public static final int BYTE_ARRAY = 12;
    public static final int STRING = 13;
    public static final BAcePrimitiveTypeEnum nullPrim = new BAcePrimitiveTypeEnum(0);
    public static final BAcePrimitiveTypeEnum bool = new BAcePrimitiveTypeEnum(1);
    public static final BAcePrimitiveTypeEnum u8 = new BAcePrimitiveTypeEnum(2);
    public static final BAcePrimitiveTypeEnum u16 = new BAcePrimitiveTypeEnum(3);
    public static final BAcePrimitiveTypeEnum s32 = new BAcePrimitiveTypeEnum(4);
    public static final BAcePrimitiveTypeEnum s64 = new BAcePrimitiveTypeEnum(5);
    public static final BAcePrimitiveTypeEnum f32 = new BAcePrimitiveTypeEnum(6);
    public static final BAcePrimitiveTypeEnum f64 = new BAcePrimitiveTypeEnum(7);
    public static final BAcePrimitiveTypeEnum statusBool = new BAcePrimitiveTypeEnum(8);
    public static final BAcePrimitiveTypeEnum statusInt = new BAcePrimitiveTypeEnum(9);
    public static final BAcePrimitiveTypeEnum statusFloat = new BAcePrimitiveTypeEnum(10);
    public static final BAcePrimitiveTypeEnum statusDouble = new BAcePrimitiveTypeEnum(11);
    public static final BAcePrimitiveTypeEnum byteArray = new BAcePrimitiveTypeEnum(12);
    public static final BAcePrimitiveTypeEnum string = new BAcePrimitiveTypeEnum(13);
    public static final BAcePrimitiveTypeEnum DEFAULT = s32;
    public static final Type TYPE = Sys.loadType(BAcePrimitiveTypeEnum.class);

    public static BAcePrimitiveTypeEnum make(int ordinal) {
        return (BAcePrimitiveTypeEnum)nullPrim.getRange().get(ordinal, false);
    }

    public static BAcePrimitiveTypeEnum make(String tag) {
        return (BAcePrimitiveTypeEnum)nullPrim.getRange().get(tag);
    }

    private BAcePrimitiveTypeEnum(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public static BAcePrimitiveTypeEnum fromJsonName(String tag) {
        if (!BAcePrimitiveTypeEnum.mapJsonToPrimitive().containsKey(tag)) {
            return (BAcePrimitiveTypeEnum)nullPrim.getRange().get(tag);
        }
        return BAcePrimitiveTypeEnum.mapJsonToPrimitive().get(tag);
    }

    private static Map<String, BAcePrimitiveTypeEnum> mapJsonToPrimitive() {
        return Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("void", nullPrim), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("bool", bool), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("byte", u8), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("short", u16), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("int", s32), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("long", s64), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("float", f32), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("double", f64), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("buf", byteArray), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("statusBool", statusBool), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("statusInt", statusInt), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("statusFloat", statusFloat), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("statusDouble", statusDouble), new AbstractMap.SimpleEntry<String, BAcePrimitiveTypeEnum>("string", string)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (BAcePrimitiveTypeEnum)((Object)((Object)e.getValue())))));
    }

    public static String getJsonName(String typeName) {
        return BAcePrimitiveTypeEnum.mapPrimitiveToJson().get(typeName);
    }

    private static Map<String, String> mapPrimitiveToJson() {
        return Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("nullPrim", "void"), new AbstractMap.SimpleEntry<String, String>("bool", "bool"), new AbstractMap.SimpleEntry<String, String>("u8", "byte"), new AbstractMap.SimpleEntry<String, String>("u16", "short"), new AbstractMap.SimpleEntry<String, String>("s32", "int"), new AbstractMap.SimpleEntry<String, String>("s64", "long"), new AbstractMap.SimpleEntry<String, String>("f32", "float"), new AbstractMap.SimpleEntry<String, String>("f64", "double"), new AbstractMap.SimpleEntry<String, String>("byteArray", "buf"), new AbstractMap.SimpleEntry<String, String>("statusBool", "statusBool"), new AbstractMap.SimpleEntry<String, String>("statusInt", "statusInt"), new AbstractMap.SimpleEntry<String, String>("statusFloat", "statusFloat"), new AbstractMap.SimpleEntry<String, String>("statusDouble", "statusDouble"), new AbstractMap.SimpleEntry<String, String>("string", "string")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
    }

    public boolean isNull() {
        return this == nullPrim;
    }

    public boolean isFloat() {
        return this == f32 || this == f64 || this == statusFloat || this == statusDouble;
    }

    public boolean isFloatOnly() {
        return this == f32 || this == statusFloat;
    }

    public boolean isDouble() {
        return this == f64 || this == statusDouble;
    }

    public boolean isBool() {
        return this == bool || this == statusBool;
    }

    public boolean isInt() {
        return this == u8 || this == u16 || this == s32 || this == statusInt;
    }

    public boolean isByte() {
        return this == u8;
    }

    public boolean isShort() {
        return this == u16;
    }

    public boolean isLong() {
        return this == s64;
    }

    public boolean isByteArray() {
        return this == byteArray;
    }

    public boolean isString() {
        return this == string;
    }

    public boolean isStatus() {
        return BAcePrimitiveTypeEnum.isStatusOrd(this.getOrdinal());
    }

    public static boolean isStatusOrd(int id) {
        return id >= 8 && id <= 11;
    }
}

