/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.ports;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BEthernetPort
extends BPort {
    public static final Property adapterId = BEthernetPort.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BEthernetPort.class);

    public String getAdapterId() {
        return this.getString(adapterId);
    }

    public void setAdapterId(String v) {
        this.setString(adapterId, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BEthernetPort() {
        super(BPortTypeEnum.ethernet);
    }

    public BEthernetPort(String id) {
        super(BPortTypeEnum.ethernet);
        this.setAdapterId(id);
    }

    public void initStatus() {
        this.setStatus(BHwScanStatusEnum.unknown);
        try {
            BTcpIpPlatformService tcpPortService = (BTcpIpPlatformService)Sys.getService((Type)BHardwareScanService.tcpPlatformSvcTypeSpec.getResolvedType());
            tcpPortService.checkPropertiesLoaded();
            tcpPortService.lease(3);
            SlotCursor c = tcpPortService.getSettings().getAdapters().getProperties();
            while (c.next(BTcpIpAdapterSettings.class)) {
                BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
                if (!adapter.getAdapterId().equals(this.getAdapterId())) continue;
                this.setStatus(adapter.getIsAdapterEnabled() ? BHwScanStatusEnum.available : BHwScanStatusEnum.disabled);
                return;
            }
        }
        catch (ModuleNotFoundException mnfe) {
            BHardwareScanService.log.severe(BHardwareScanService.lex.getText("moduleNotFound", new Object[]{mnfe.getMessage(), this.getName()}));
        }
        catch (ServiceNotFoundException mnfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

