/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.optionCards;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BCardSlot;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.optionCards.BOptionCard;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOptionSlot
extends BCardSlot {
    public static final Property slotNumber = BOptionSlot.newProperty((int)1, (int)0, null);
    public static final Type TYPE = Sys.loadType(BOptionSlot.class);
    private static final String NO_PORT_IMAGE = "OptionCardWidget.noPortImage";
    private static final String ONE_PORT_IMAGE = "OptionCardWidget.onePortImage";
    private static final String TWO_PORT_IMAGE = "OptionCardWidget.twoPortImage";
    private static final String UNKNOWN_CARD_PORTS_IMAGE = "OptionCardWidget.unknownCardPortsImage";
    private static final String NO_PORT_TOP_IMAGE = "OptionCardWidget.noPortTopImage";
    private static final String ONE_PORT_TOP_IMAGE = "OptionCardWidget.onePortTopImage";
    private static final String TWO_PORT_TOP_IMAGE = "OptionCardWidget.twoPortTopImage";

    public int getSlotNumber() {
        return this.getInt(slotNumber);
    }

    public void setSlotNumber(int v) {
        this.setInt(slotNumber, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOptionSlot() {
    }

    public BOptionSlot(int slot) {
        this.setSlotNumber(slot);
    }

    public BOptionSlot(int slot, BOptionCard optionCard) {
        this.setSlotNumber(slot);
        this.addCard(optionCard);
    }

    public void addCard(BOptionCard optionCard) {
        BHardwareScanService scanService = (BHardwareScanService)BOrd.make((BOrd)this.getOrdInSession(), (String)"service:platHwScan:HardwareScanService").get();
        BBaseBoard baseBoard = scanService.getBaseBoardType();
        String dir = baseBoard.getImagesDirectory();
        int visiblePorts = optionCard.getConnectors();
        String s = optionCard.getTopViewImage();
        if (s.equals("")) {
            s = visiblePorts == 1 ? BHardwareScanService.lex.getText(ONE_PORT_TOP_IMAGE) : (visiblePorts == 2 ? BHardwareScanService.lex.getText(TWO_PORT_TOP_IMAGE) : BHardwareScanService.lex.getText(NO_PORT_TOP_IMAGE));
        }
        optionCard.setTopViewImage(s);
        if (optionCard.getUnknownCardType()) {
            s = BHardwareScanService.lex.getText(UNKNOWN_CARD_PORTS_IMAGE);
        } else {
            s = optionCard.getSideViewImage();
            if (s.equals("")) {
                s = visiblePorts == 1 ? BHardwareScanService.lex.getText(ONE_PORT_IMAGE) : (visiblePorts == 2 ? BHardwareScanService.lex.getText(TWO_PORT_IMAGE) : BHardwareScanService.lex.getText(NO_PORT_IMAGE));
            }
        }
        optionCard.setSideViewImage(s);
        this.add("Contents", (BValue)optionCard);
    }
}

