/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.optionCards;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionModule;
import com.tridium.platHwScan.ports.BPort;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BOptionCard
extends BComponent {
    public static final Property description = BOptionCard.newProperty((int)1, (String)"", null);
    public static final Property optionCodes = BOptionCard.newProperty((int)1, (String)"FF FF", null);
    public static final Property usesCom = BOptionCard.newProperty((int)1, (boolean)false, null);
    public static final Property unknownCardType = BOptionCard.newProperty((int)5, (boolean)true, null);
    public static final Property portCount = BOptionCard.newProperty((int)5, (int)0, null);
    public static final Property connectors = BOptionCard.newProperty((int)5, (int)0, null);
    public static final Property sideViewImage = BOptionCard.newProperty((int)1, (String)"", null);
    public static final Property topViewImage = BOptionCard.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BOptionCard.class);
    private static Hashtable<String, BOptionCard> cardCatalog = null;
    private static String[] cardFiles = new String[]{"module://platHwScan/rc/platHwScanOptionCards.xml"};

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public String getOptionCodes() {
        return this.getString(optionCodes);
    }

    public void setOptionCodes(String v) {
        this.setString(optionCodes, v, null);
    }

    public boolean getUsesCom() {
        return this.getBoolean(usesCom);
    }

    public void setUsesCom(boolean v) {
        this.setBoolean(usesCom, v, null);
    }

    public boolean getUnknownCardType() {
        return this.getBoolean(unknownCardType);
    }

    public void setUnknownCardType(boolean v) {
        this.setBoolean(unknownCardType, v, null);
    }

    public int getPortCount() {
        return this.getInt(portCount);
    }

    public void setPortCount(int v) {
        this.setInt(portCount, v, null);
    }

    public int getConnectors() {
        return this.getInt(connectors);
    }

    public void setConnectors(int v) {
        this.setInt(connectors, v, null);
    }

    public String getSideViewImage() {
        return this.getString(sideViewImage);
    }

    public void setSideViewImage(String v) {
        this.setString(sideViewImage, v, null);
    }

    public String getTopViewImage() {
        return this.getString(topViewImage);
    }

    public void setTopViewImage(String v) {
        this.setString(topViewImage, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOptionCard() {
    }

    public BOptionCard(String description) {
        this.setDescription(description);
    }

    public BOptionCard(String description, String optionCodes) {
        this.setDescription(description);
        this.setOptionCodes(optionCodes);
    }

    public static String[] getCardFiles() {
        return cardFiles;
    }

    protected String getCardKey() {
        return this.getOptionCodes();
    }

    public static void addOptionCardReference(BOptionCard optionCard) throws Exception {
        if (!optionCard.getOptionCodes().equals("")) {
            cardCatalog.put(optionCard.getOptionCodes(), optionCard);
        }
    }

    public static void buildCardCatalog() {
        cardCatalog = new Hashtable();
        for (String cardFile : cardFiles) {
            try {
                Hashtable<String, BOptionCard> ht = BOptionCard.parseCardFile(cardFile);
                if (ht == null) continue;
                Enumeration<String> keys = ht.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (cardCatalog.get(key) != null) {
                        BHardwareScanService.log.warning(BHardwareScanService.lex.getText("OptionCard.duplicateOptCode", new Object[]{key}));
                    }
                    cardCatalog.put(key, ht.get(key));
                }
            }
            catch (Exception e) {
                BHardwareScanService.log.fine(BHardwareScanService.lex.getText("parsingError", new Object[]{e.getClass().getName(), cardFile}));
            }
        }
    }

    public static Hashtable<String, BOptionCard> getCardCatalog() {
        if (cardCatalog == null) {
            BOptionCard.buildCardCatalog();
        }
        return cardCatalog;
    }

    public static BOptionCard lookup(String optCardCode) {
        BOptionCard obj;
        if (cardCatalog == null) {
            BOptionCard.buildCardCatalog();
        }
        if ((obj = cardCatalog.get(optCardCode)) == null) {
            return null;
        }
        return obj;
    }

    protected static Hashtable<String, BOptionCard> parseCardFile(String filePath) throws Exception {
        XElem[] elements;
        XElem root;
        BHardwareScanService.log.fine(BHardwareScanService.lex.getText("parsingNotification", new Object[]{filePath}));
        try {
            BOrd fileOrd = BOrd.make((String)filePath);
            BIFile file = (BIFile)fileOrd.get();
            root = XParser.make((InputStream)file.getInputStream()).parse();
        }
        catch (Exception e) {
            if (e instanceof UnresolvedException) {
                BHardwareScanService.log.fine(BHardwareScanService.lex.getText("fileDoesNotExist", new Object[]{filePath}));
                return null;
            }
            if (e instanceof EOFException) {
                BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("unexpectedEof", new Object[]{filePath}));
                return null;
            }
            throw e;
        }
        if (!root.name().equalsIgnoreCase("optionCards")) {
            BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("fileFormatError", new Object[]{filePath, root.name(), "optionCards"}));
            return null;
        }
        Hashtable<String, BOptionCard> ht = new Hashtable<String, BOptionCard>();
        for (XElem nextElement : elements = root.elems()) {
            String name = nextElement.name();
            if (!name.equalsIgnoreCase("optionCard") && !name.equalsIgnoreCase("optionModule")) continue;
            try {
                XElem[] cardProps;
                BOptionCard optCard = name.equalsIgnoreCase("optionModule") ? new BOptionModule() : new BOptionCard();
                optCard.setDescription(BHardwareScanService.lex.getText(nextElement.get("description")));
                optCard.setOptionCodes(nextElement.get("optionCodes"));
                optCard.setUsesCom(nextElement.getb("usesCom", false));
                optCard.setUnknownCardType(false);
                int ports = 0;
                int connectors = 0;
                for (XElem nextCardProp : cardProps = nextElement.elems()) {
                    String cardPropName = nextCardProp.name();
                    if (!cardPropName.equalsIgnoreCase("port")) continue;
                    BPort port = new BPort();
                    port.setPortType(BPortTypeEnum.make(nextCardProp.get("portType", BPortTypeEnum.noPort.getTag())));
                    port.setHasConnector(nextCardProp.get("hasConnector", "true").equalsIgnoreCase("true"));
                    if (port.getHasConnector()) {
                        ++connectors;
                    }
                    if (port.getPortType().equals((Object)BPortTypeEnum.future) || port.getPortType().equals((Object)BPortTypeEnum.noPort)) continue;
                    port.setRequiredFeatures(nextCardProp.get("requiredFeatures"));
                    port.setPrefix(nextCardProp.get("prefix"));
                    port.setStatus(BHwScanStatusEnum.make(nextCardProp.get("status", BHwScanStatusEnum.available.getTag())));
                    optCard.setSideViewImage(nextElement.get("sideViewImage", ""));
                    optCard.setTopViewImage(nextElement.get("topViewImage", ""));
                    port.checkLicense();
                    port.add("portIndex", (BValue)BInteger.make((String)nextCardProp.get("index")), 5);
                    optCard.add("Port" + nextCardProp.get("index"), (BValue)port);
                    ++ports;
                }
                optCard.setPortCount(ports);
                optCard.setConnectors(connectors);
                ht.put(optCard.getOptionCodes(), optCard);
            }
            catch (Exception e) {
                BHardwareScanService.log.log(Level.SEVERE, BHardwareScanService.lex.getText("parsingError", new Object[]{e.getClass().getName(), nextElement.toString()}));
            }
        }
        return ht;
    }

    public BPort[] getPorts() {
        return (BPort[])this.getChildren(BPort.class);
    }

    public BPort getPort(int portNumber) {
        BPort[] ports;
        for (BPort port : ports = this.getPorts()) {
            BValue portIndex = port.get("portIndex");
            if (portIndex == null || ((BInteger)portIndex).getInt() != portNumber) continue;
            return port;
        }
        return null;
    }
}

