/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.point;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetDiscoverPointsJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.ui.point.BacnetPointController;
import com.tridium.bacnet.ui.point.PointLearn;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.point.BBacnetBooleanProxyExt;
import javax.baja.bacnet.point.BBacnetEnumProxyExt;
import javax.baja.bacnet.point.BBacnetNumericProxyExt;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetStringProxyExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderState;

public class BBacnetPointManager
extends BPointManager
implements BacnetConst {
    public static final Type TYPE = Sys.loadType(BBacnetPointManager.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BBacnetPointManager.class);
    static BImage bacnetObjectIcon = BImage.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    static BImage numericIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");
    static BImage booleanIcon = BImage.make((String)"module://icons/x16/control/booleanPoint.png");
    static BImage enumIcon = BImage.make((String)"module://icons/x16/control/enumPoint.png");
    static BImage stringIcon = BImage.make((String)"module://icons/x16/control/stringPoint.png");
    static BImage logIcon = BImage.make((String)"module://icons/x16/history.png");
    static BImage scheduleIcon = BImage.make((String)"module://icons/x16/schedule.png");
    static BImage calendarIcon = BImage.make((String)"module://icons/x16/calendar.png");
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    private static final Logger logger = Logger.getLogger("bacnet.ui");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colValue = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new MgrColumn.PropPath(lexicon.getText("learn.objectId"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.objectId}, 1);
    MgrColumn colProperty = new MgrColumn.PropPath(lexicon.getText("pointManager.property"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.propertyId}, 1);
    MgrColumn colIndex = new MgrColumn.PropPath(lexicon.getText("pointManager.index"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.propertyArrayIndex}, 1);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colAsnType = new MgrColumn.PropPath(lexicon.getText("pointManager.dataType"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.dataType}, 7);
    MgrColumn colReadStatus = new MgrColumn.PropPath(lexicon.getText("pointManager.read"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.readStatus}, 5);
    MgrColumn colWriteStatus = new MgrColumn.PropPath(lexicon.getText("pointManager.write"), new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.writeStatus}, 5);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.deviceFacets}, 7);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BBacnetProxyExt.conversion}, 3);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colOid, this.colProperty, this.colIndex, this.colTuning, this.colAsnType, this.colReadStatus, this.colWriteStatus, this.colDeviceFacets, this.colFacets, this.colConversion, this.colReadValue, this.colWriteValue, this.colFaultCause};
    private BBacnetPointDeviceExt deviceExt;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new BacnetPointController(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            this.deviceExt = (BBacnetPointDeviceExt)((BIPointFolder)obj).getDeviceExt();
            super.doLoadValue(obj, cx);
        }
        catch (Exception e) {
            ((BacnetPointController)this.getController()).disableAll();
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        BJob lrnJob = this.getLearn().getJob();
        if (event.getId() == 1 && lrnJob != null && lrnJob instanceof BBacnetDiscoverPointsJob && event.getSourceComponent() == lrnJob) {
            try {
                this.getLearn().updateRoots(lrnJob.getChildren(BDiscoveryPoint.class));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred in handleComponentEvent", e);
            }
        }
    }

    public BBacnetPointDeviceExt getDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BBacnetPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
        }
        return this.deviceExt;
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    static class State
    extends FolderState {
        Object[] lastLearn;
        BJob lrnJob;
        BOrd myLastSaveOrd;

        State() {
        }

        public void restore(BAbstractManager manager) {
            try {
                this.restoreForType(manager);
                BOrd restoreOrd = manager.getWbShell().getActiveOrd();
                if (this.myLastSaveOrd == null) {
                    return;
                }
                BIPointFolder saveFolder = (BIPointFolder)this.myLastSaveOrd.get((BObject)BBacnetNetwork.bacnet());
                BIPointFolder restoreFolder = (BIPointFolder)restoreOrd.get((BObject)BBacnetNetwork.bacnet());
                if (saveFolder.getDeviceExt().equals((Object)restoreFolder.getDeviceExt())) {
                    this.restoreForOrd(manager);
                }
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }

        public void save(BAbstractManager manager) {
            this.myLastSaveOrd = manager.getWbShell().getActiveOrd();
            this.saveForType(manager);
            this.saveForOrd(manager);
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BBacnetPointManager mgr = (BBacnetPointManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
            this.lrnJob = lrn.getJob();
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BBacnetPointManager mgr = (BBacnetPointManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateRoots(this.lastLearn);
            }
            if (this.lrnJob != null) {
                lrn.setJob(this.lrnJob);
            }
        }
    }

    class Learn
    extends PointLearn {
        Learn(BBacnetPointManager mgr) {
            super(mgr);
        }

        public BImage getIcon(Object dis) {
            BDiscoveryPoint plr = this.lr(dis);
            try {
                int propertyId = plr.getPropertyId();
                int asnType = -1;
                PropertyInfo info = BBacnetPointManager.this.getDevice().getPropertyInfo(plr.getObjectId().getObjectType(), propertyId);
                asnType = info != null ? info.getAsnType() : AsnUtil.getAsnType((Type)plr.getValue().getType());
                switch (asnType) {
                    case 0: {
                        return stringIcon;
                    }
                    case 1: {
                        return booleanIcon;
                    }
                    case 2: 
                    case 3: {
                        return enumIcon;
                    }
                    case 4: 
                    case 5: {
                        return numericIcon;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return stringIcon;
                    }
                    case 9: {
                        if (info != null && info.getType().equals("bacnet:BacnetBinaryPv")) {
                            return booleanIcon;
                        }
                        return enumIcon;
                    }
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 10: 
                    case 11: 
                    case 12: {
                        return stringIcon;
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting icon for discovery point:" + plr, e);
            }
            return bacnetObjectIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BWbShell shell = this.getManager().getWbShell();
            shell.enterBusy();
            try {
                BDiscoveryPoint lr = this.lr(dis);
                BControlPoint pt = (BControlPoint)row.getTarget();
                int propertyId = lr.getPropertyId();
                PropertyInfo info = BBacnetPointManager.this.getDevice().getPropertyInfo(lr.getObjectId().getObjectType(), propertyId);
                String ptName = lr.getObjectName();
                if (ptName == null || ptName.length() == 0) {
                    ptName = lr.getObjectId().toString();
                }
                if (lr.getPropertyId() != 85) {
                    ptName = ptName + "-" + lr.getPropertyIdentifier();
                }
                if (lr.getIndex().length() > 0) {
                    ptName = ptName + "_" + lr.getIndex();
                }
                ptName = SlotPath.escape((String)TextUtil.replace((String)ptName, (String)"/", (String)"."));
                row.setDefaultName(ptName);
                row.setCell(BBacnetPointManager.this.colOid, (BValue)lr.getObjectId());
                row.setCell(BBacnetPointManager.this.colProperty, (BValue)BDynamicEnum.make((int)propertyId, (BEnumRange)BEnumRange.make((Type)BBacnetPropertyIdentifier.TYPE)));
                if (lr.getIndex().length() > 0) {
                    row.setCell(BBacnetPointManager.this.colIndex, (BValue)BInteger.make((String)lr.getIndex()));
                }
                if (info != null) {
                    row.setCell(BBacnetPointManager.this.colAsnType, (BValue)BString.make((String)info.getDataType()));
                }
                String writeSts = "readonly";
                if (pt.isWritablePoint()) {
                    writeSts = "writable";
                }
                row.setCell(BBacnetPointManager.this.colWriteStatus, (BValue)BString.make((String)writeSts));
                row.setCell(BBacnetPointManager.this.colReadStatus, (BValue)BString.make((String)"unsubscribed"));
                boolean writablePrioritized = false;
                if (pt.isWritablePoint()) {
                    int objectType = lr.getObjectId().getObjectType();
                    if (objectType == 1 || objectType == 4 || objectType == 14) {
                        writablePrioritized = true;
                    }
                    if (objectType == 2 || objectType == 5 || objectType == 19) {
                        writablePrioritized = this.getDiscoveryJob().checkForPriorityArray(lr.getObjectId()).getBoolean();
                    }
                    if (writablePrioritized) {
                        row.setCell(BBacnetPointManager.this.colEnabled, (BValue)BBoolean.make((boolean)false));
                    }
                }
                BFacets facets = pt.getFacets();
                BFacets lrFacets = lr.getFacets();
                if (lrFacets == null || lrFacets.isNull()) {
                    lrFacets = this.getDiscoveryJob().discoverFacets(lr.getObjectId());
                }
                if (info != null) {
                    if (info.isEnum()) {
                        BEnum en = (BEnum)BTypeSpec.make((String)info.getType()).getInstance();
                        BEnumRange r = en.getRange();
                        if (info.isExtensible()) {
                            r = BBacnetPointManager.this.getDevice().getEnumerationList().getEnumRange(info.getType());
                        }
                        if (r != null) {
                            lrFacets = BFacets.make((BFacets)lrFacets, (String)"range", (BIDataValue)r);
                        }
                    }
                    if (info.getFacetControl().equals("all")) {
                        facets = lrFacets;
                    } else if (info.getFacetControl().equals("units")) {
                        facets = BFacets.make((String)"units", (BIDataValue)((BUnit)lrFacets.getFacet("units")));
                    } else if (!info.getFacetControl().equals("no") && lrFacets != null && !lrFacets.isNull()) {
                        facets = lrFacets;
                    }
                }
                row.setCell(BBacnetPointManager.this.colDeviceFacets, (BValue)facets);
                facets = BFacets.makeRemove((BFacets)facets, (String)"priPV");
                row.setCell(BBacnetPointManager.this.colFacets, (BValue)facets);
            }
            finally {
                shell.exitBusy();
            }
        }
    }

    class Model
    extends PointModel {
        Model(BBacnetPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BBacnetPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BBacnetBooleanProxyExt();
            } else if (pt instanceof BNumericPoint) {
                ext = new BBacnetNumericProxyExt();
            } else if (pt instanceof BEnumPoint) {
                ext = new BBacnetEnumProxyExt();
            } else if (pt instanceof BStringPoint) {
                ext = new BBacnetStringProxyExt();
            }
            if (ext instanceof BProxyExt) {
                BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

