/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.history;

import com.tridium.bacnet.history.BBacnetTrendLogMultipleImport;
import com.tridium.bacnet.ui.history.BMultiRecordTable;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.ui.HistorySourceSubscriber;
import com.tridium.history.ui.HistoryUiUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

public class BBacnetTrendMultipleView
extends BWbView {
    public static final Property showTimeRangeEditor = BBacnetTrendMultipleView.newProperty((int)0, (boolean)true, null);
    public static final Property defaultTimeRange = BBacnetTrendMultipleView.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Property showDeltaEditor = BBacnetTrendMultipleView.newProperty((int)0, (boolean)true, null);
    public static final Property defaultDelta = BBacnetTrendMultipleView.newProperty((int)0, (boolean)false, null);
    public static final Property showLiveUpdates = BBacnetTrendMultipleView.newProperty((int)0, (boolean)true, null);
    public static final Property defaultLiveUpdates = BBacnetTrendMultipleView.newProperty((int)0, (boolean)false, null);
    public static final Action query = BBacnetTrendMultipleView.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BBacnetTrendMultipleView.class);
    BIHistory[] histCache = null;
    static final BImage PLAY_ICON = BImage.make((BIcon)BIcon.std((String)"mediaPlay.png"));
    static final BImage PAUSE_ICON = BImage.make((BIcon)BIcon.std((String)"mediaPause.png"));
    private static Lexicon lex = Lexicon.make((String)"history");
    private static HashMap<String, State> states = new HashMap();
    private static final String lexRecords = lex.getText("records");
    private static final Logger logger = Logger.getLogger("bacnet.ui");
    private BToolBar toolbar;
    private BTitlePane tablePane;
    private boolean useBql = true;
    private BDynamicTimeRangeFE timeRangeEd;
    private BToggleButton deltaEd;
    private BTable table;
    private int lastRowCount = 0;
    private boolean sizedToFit = false;
    private boolean deltaEnabled;
    private Command filterCmd;
    private ToggleCommand deltaCmd;
    private BFilterSet filterSet;
    private Context tzContext;
    private BLabel liveUpdatesStatus;
    private BAbstractButton toolBarLiveUpdatesButton;
    private BToggleButton liveUpdatesToggle;
    private ToggleCommand liveUpdatesCmd;
    private HistoryTableSubscriber mySubscriber = new HistoryTableSubscriber();
    private BHistory currentHistory = null;
    public Object syncObj = new Object();
    public BAbsTime lastTimestamp = BAbsTime.NULL;
    private boolean lastUpdateState = false;
    private boolean tableReady = false;

    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    public void setShowTimeRangeEditor(boolean v) {
        this.setBoolean(showTimeRangeEditor, v, null);
    }

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    public boolean getShowDeltaEditor() {
        return this.getBoolean(showDeltaEditor);
    }

    public void setShowDeltaEditor(boolean v) {
        this.setBoolean(showDeltaEditor, v, null);
    }

    public boolean getDefaultDelta() {
        return this.getBoolean(defaultDelta);
    }

    public void setDefaultDelta(boolean v) {
        this.setBoolean(defaultDelta, v, null);
    }

    public boolean getShowLiveUpdates() {
        return this.getBoolean(showLiveUpdates);
    }

    public void setShowLiveUpdates(boolean v) {
        this.setBoolean(showLiveUpdates, v, null);
    }

    public boolean getDefaultLiveUpdates() {
        return this.getBoolean(defaultLiveUpdates);
    }

    public void setDefaultLiveUpdates(boolean v) {
        this.setBoolean(defaultLiveUpdates, v, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetTrendMultipleView() {
        this.initCommands();
        BEdgePane main = new BEdgePane();
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        this.deltaEd = new BToggleButton(this.deltaCmd, false, true);
        this.deltaEd.setSelected(false);
        this.deltaEd.setVisible(this.getShowDeltaEditor());
        this.liveUpdatesToggle = new BToggleButton(this.liveUpdatesCmd, false, true);
        this.liveUpdatesToggle.setSelected(false);
        this.liveUpdatesToggle.setVisible(this.getShowLiveUpdates());
        this.liveUpdatesStatus = new BLabel(lex.getText("history.liveUpdates.inProgress"), BHalign.right);
        this.liveUpdatesStatus.setVisible(false);
        this.toolbar = new BToolBar();
        this.rebuildToolbar();
        main.setTop((BWidget)new BBorderPane((BWidget)this.toolbar, 0.0, 0.0, 5.0, 0.0));
        main.getTop().setVisible(this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor());
        this.table = new BTable();
        this.table.setController((TableController)new HistoryTableController());
        this.tablePane = BTitlePane.makePane((String)"", (BTable)this.table, (String)lexRecords);
        main.setCenter((BWidget)this.tablePane);
        this.setContent((BWidget)main);
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
    }

    public BToolBar getViewToolBar() {
        BToolBar tb = new BToolBar();
        tb.add("filter", this.filterCmd);
        this.toolBarLiveUpdatesButton = tb.add("liveUpdates", (Command)this.liveUpdatesCmd);
        tb.add("delta", (Command)this.deltaCmd);
        return tb;
    }

    public BTable getExportTable() {
        return this.table;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.liveUpdatesStatus;
    }

    private void initCommands() {
        this.filterCmd = new Command((BWidget)this, BBacnetTrendMultipleView.lex.module, "command.filter"){

            public CommandArtifact doInvoke() {
                BBacnetTrendMultipleView.this.configFilters();
                return null;
            }
        };
        this.deltaCmd = new ToggleCommand((BWidget)this, BBacnetTrendMultipleView.lex.module, "command.delta"){

            public CommandArtifact doInvoke() {
                BBacnetTrendMultipleView.this.query();
                return null;
            }
        };
        this.liveUpdatesCmd = new ToggleCommand((BWidget)this, BBacnetTrendMultipleView.lex.module, "command.liveUpdates"){

            public CommandArtifact doInvoke() {
                if (!this.isEnabled()) {
                    return null;
                }
                boolean enableUpdates = this.isSelected();
                if (enableUpdates == BBacnetTrendMultipleView.this.lastUpdateState) {
                    return null;
                }
                BBacnetTrendMultipleView.this.lastUpdateState = enableUpdates;
                if (BBacnetTrendMultipleView.this.currentHistory != null) {
                    if (enableUpdates) {
                        BBacnetTrendMultipleView.this.liveUpdatesStatus.setVisible(true);
                        BBacnetTrendMultipleView.this.liveUpdatesStatus.relayoutSync();
                        BBacnetTrendMultipleView.this.currentHistory.subscribe((Subscriber)BBacnetTrendMultipleView.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext((Context)BBacnetTrendMultipleView.this.getCurrentContext()));
                    } else {
                        BBacnetTrendMultipleView.this.currentHistory.unsubscribe((Subscriber)BBacnetTrendMultipleView.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext((Context)BBacnetTrendMultipleView.this.getCurrentContext()));
                    }
                }
                if (enableUpdates) {
                    this.icon = PAUSE_ICON;
                    if (BBacnetTrendMultipleView.this.toolBarLiveUpdatesButton != null) {
                        BBacnetTrendMultipleView.this.toolBarLiveUpdatesButton.setImage(PAUSE_ICON);
                    }
                    BBacnetTrendMultipleView.this.liveUpdatesToggle.setImage(PAUSE_ICON);
                } else {
                    BBacnetTrendMultipleView.this.liveUpdatesStatus.setVisible(false);
                    BBacnetTrendMultipleView.this.liveUpdatesStatus.relayoutSync();
                    this.icon = PLAY_ICON;
                    if (BBacnetTrendMultipleView.this.toolBarLiveUpdatesButton != null) {
                        BBacnetTrendMultipleView.this.toolBarLiveUpdatesButton.setImage(PLAY_ICON);
                    }
                    BBacnetTrendMultipleView.this.liveUpdatesToggle.setImage(PLAY_ICON);
                }
                return null;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public void doLoadValue(BObject value, Context context) {
        histories = this.getHistories(value);
        if (histories == null) {
            return;
        }
        history = histories[0];
        this.currentHistory = history instanceof BHistory != false ? (BHistory)history : null;
        this.tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)history.getConfig().getTimeZone()));
        this.tablePane.setTitle(SlotPath.unescape((String)history.getId().toString(context)));
        recTypeSpec = history.getRecordType();
        type = recTypeSpec.getResolvedType();
        this.deltaEnabled = type.is(BNumericTrendRecord.TYPE);
        this.deltaCmd.setEnabled(this.deltaEnabled);
        liveUpdatesEnabled = this.currentHistory != null && this.currentHistory.canSubscribe(context) != false;
        this.liveUpdatesCmd.setEnabled(liveUpdatesEnabled);
        this.rebuildToolbar();
        space = (BHistorySpace)history.getSpace();
        this.useBql = true;
        try {
            BOrd.make((BOrd)space.getAbsoluteOrd(), (String)"bql:").resolve();
        }
        catch (Exception e) {
            this.useBql = false;
        }
        defRange = this.getDefaultTimeRange();
        if (defRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            conn = ((BHistorySpace)history.getSpace()).getConnection(null);
            var11_12 = null;
            try {
                this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.make((BAbsTime)conn.getFirstTimestamp(history), (BAbsTime)BAbsTime.NULL), this.tzContext);
                recordCount = conn.getRecordCount(history);
                lastTs = conn.getLastTimestamp(history);
                if (recordCount <= 500) ** GOTO lbl54
                now = Clock.time();
                if (now.dateEquals(lastTs)) {
                    this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY, this.tzContext);
                }
                range = BDynamicTimeRange.make((BAbsTime)lastTs.timeOfDay(0, 0, 0, 0), (BAbsTime)BAbsTime.NULL);
                this.timeRangeEd.loadValue((BObject)range, this.tzContext);
            }
            catch (Throwable var12_15) {
                var11_12 = var12_15;
                throw var12_15;
            }
            finally {
                if (conn != null) {
                    if (var11_12 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable var12_14) {
                            var11_12.addSuppressed(var12_14);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        } else {
            this.timeRangeEd.loadValue((BObject)defRange, this.tzContext);
        }
lbl54:
        // 4 sources

        this.deltaEd.setSelected(this.deltaEnabled != false && this.getDefaultDelta() != false);
        this.liveUpdatesToggle.setSelected(liveUpdatesEnabled != false && this.getDefaultLiveUpdates() != false);
        this.restoreState(this.toKey());
        if (HistoryUiUtil.requiresSyncLoad((BIHistory)history, (BWidget)this, (Context)context)) {
            this.doQuery();
        } else {
            this.query();
        }
    }

    public void changed(Property p, Context cx) {
        if (p == showTimeRangeEditor || p == showDeltaEditor || p == showLiveUpdates) {
            this.rebuildToolbar();
        }
    }

    private void rebuildToolbar() {
        boolean a = this.currentHistory != null && this.getShowLiveUpdates();
        boolean b = this.deltaEnabled && this.getShowDeltaEditor();
        boolean c = this.getShowTimeRangeEditor();
        this.toolbar.removeAll();
        if (a) {
            this.toolbar.add(null, (BValue)this.liveUpdatesToggle);
        }
        if (a && (b || c)) {
            this.toolbar.add(null, (BValue)new BSeparator());
        }
        if (b) {
            this.toolbar.add(null, (BValue)this.deltaEd);
        }
        if (b && c) {
            this.toolbar.add(null, (BValue)new BSeparator());
        }
        if (c) {
            this.toolbar.add(null, (BValue)this.timeRangeEd);
        }
        if (this.getContent() instanceof BEdgePane) {
            ((BEdgePane)this.getContent()).getTop().setVisible(this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext((Context)cx));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
        return value;
    }

    public void doQuery() {
        this.doQuery(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery(boolean liveUpdate) {
        Object object = this.syncObj;
        synchronized (object) {
            BWidgetShell shell = this.getShell();
            if (shell != null && !liveUpdate) {
                shell.enterBusy();
            }
            try {
                BDynamicTimeRange timeRange;
                int histCnt;
                BIHistory[] histories;
                BBacnetTrendLogMultipleImport tlm;
                block24: {
                    block25: {
                        tlm = (BBacnetTrendLogMultipleImport)this.getCurrentValue();
                        histories = this.getHistories((BObject)tlm);
                        histCnt = histories.length;
                        timeRange = null;
                        try {
                            timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
                            if (!liveUpdate || BAbsTime.NULL.equals((Object)this.lastTimestamp)) break block24;
                            BAbsTime start = this.lastTimestamp.add(BRelTime.make((long)1L));
                            BAbsTime current = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)histories[0].getConfig().getTimeZone());
                            BAbsTime editorStart = timeRange.getStartTime(current);
                            if (!BAbsTime.NULL.equals((Object)editorStart) && !start.isAfter(editorStart)) break block24;
                            BAbsTime editorEnd = timeRange.getEndTime(current);
                            if (!BAbsTime.NULL.equals((Object)editorEnd) && !start.isBefore(editorEnd)) break block25;
                            timeRange = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)editorEnd);
                        }
                        catch (Exception e) {
                            if (!liveUpdate) {
                                BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)e);
                            }
                            throw new BajaRuntimeException((Throwable)e);
                        }
                    }
                    return;
                }
                BITable[] results = new BITable[histCnt];
                for (int i = 0; i < histCnt; ++i) {
                    BIHistory history = histories[i];
                    BOrd historyOrd = history.getOrdInSession();
                    BOrd historyQuery = BOrd.make((String)(historyOrd.toString() + "?" + timeRange.toOrdParams() + ";delta=" + String.valueOf(this.deltaCmd.isSelected())));
                    if (this.useBql) {
                        String filterQual;
                        StringBuilder ordText = new StringBuilder(64);
                        ordText.append(historyQuery.toString()).append('|');
                        ordText.append("bql:select *");
                        StringBuilder predicate = new StringBuilder(64);
                        if (this.filterSet != null && (filterQual = this.filterSet.getPredicate()) != null && filterQual.length() > 0) {
                            if (predicate.length() != 0) {
                                predicate.append(" and ");
                            }
                            predicate.append(filterQual);
                        }
                        if (predicate.length() != 0) {
                            ordText.append(" where ").append(predicate.toString());
                        }
                        BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)BOrd.make((String)ordText.toString())).normalize();
                        results[i] = (BITable)ord.resolve().get();
                        continue;
                    }
                    BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)historyQuery).normalize();
                    results[i] = (BITable)ord.resolve().get();
                }
                boolean resetModel = true;
                try {
                    BMultiRecordTable rt = new BMultiRecordTable(results, tlm.getLocalHistoryNamesArray());
                    this.loadData((BITable<?>)rt, resetModel);
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)lex.getText("historyChart.noChartableValue"), (Throwable)e);
                    this.tableReady = true;
                    if (shell != null && !liveUpdate) {
                        shell.exitBusy();
                    }
                    return;
                }
                try {
                    if (!Tables.hasRows((BITable)results[0])) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception occurred in doQuery", e);
                }
            }
            finally {
                this.tableReady = true;
                if (shell != null && !liveUpdate) {
                    shell.exitBusy();
                }
            }
        }
    }

    public void loadData(BITable<?> result, boolean resetModel) {
        int sortCol = this.table.getSortColumn();
        if (resetModel) {
            CollectionTableModel model = new CollectionTableModel(result, this.getCurrentContext());
            int[] displayCols = null;
            if (this.table.getModel() instanceof DynamicTableModel) {
                DynamicTableModel m = (DynamicTableModel)this.table.getModel();
                displayCols = new int[m.getColumnCount()];
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    displayCols[i] = m.toRootColumnIndex(i);
                }
            }
            DynamicTableModel outerModel = null;
            outerModel = displayCols != null ? new DynamicTableModel((TableModel)model, displayCols) : new DynamicTableModel((TableModel)model);
            if (sortCol != -1) {
                outerModel.sortByColumn(sortCol, this.table.isSortAscending());
            }
            this.table.setModel((TableModel)outerModel);
            this.table.relayout();
            this.relayout();
            if (!this.sizedToFit && this.lastRowCount == 0 && Tables.hasRows(result)) {
                this.sizedToFit = true;
                this.table.sizeColumnsToFit();
            }
            this.updateTitle();
        }
        this.tablePane.tableModified();
    }

    public boolean isReady() {
        return this.tableReady;
    }

    private void updateTitle() {
        String newTitle = SlotPath.unescape((String)((BComplex)this.getCurrentValue()).getName());
        if (this.filterSet != null && this.filterSet.anyActive()) {
            newTitle = newTitle + "*";
        }
        this.tablePane.setTitle(newTitle);
    }

    public void stopped() throws Exception {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
        super.stopped();
    }

    public void configFilters() {
    }

    protected BIHistory[] getHistories(BObject o) {
        if (this.histCache == null) {
            BBacnetTrendLogMultipleImport tlm = (BBacnetTrendLogMultipleImport)o;
            this.histCache = tlm.getHistories();
        }
        return this.histCache;
    }

    private String toKey() {
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return null;
        }
        OrdTarget ordTarget = shell.getActiveOrdTarget();
        if (ordTarget == null) {
            return null;
        }
        return "" + ordTarget.getOrdWithoutViewQuery();
    }

    public void activated() {
        this.restoreState(this.toKey());
    }

    public void deactivated() {
        this.saveState(this.toKey());
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
    }

    private void saveState(String key) {
        try {
            State state = new State();
            state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            state.filterSet = this.filterSet == null ? null : (BFilterSet)this.filterSet.newCopy(true);
            state.deltaState = this.deltaCmd.isSelected();
            state.liveUpdatesState = this.liveUpdatesCmd.isSelected();
            states.put(key, state);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in saveState", e);
        }
    }

    private void restoreState(String key) {
        if (key == null) {
            return;
        }
        State state = states.get(key);
        if (state == null) {
            return;
        }
        this.timeRangeEd.loadValue((BObject)state.timeRange, this.tzContext);
        this.filterSet = state.filterSet;
        this.deltaCmd.setSelected(state.deltaState);
        this.liveUpdatesCmd.setSelected(state.liveUpdatesState);
    }

    public BIHistory getHistory() {
        return this.getHistories(this.getCurrentValue())[0];
    }

    public BDynamicTimeRange getRange() throws Exception {
        return (BDynamicTimeRange)this.timeRangeEd.saveValue();
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    class HistoryTableSubscriber
    extends HistorySourceSubscriber {
        HistoryTableSubscriber() {
        }

        public void historySourceEvent(BComponentEvent event) {
            try {
                BBacnetTrendMultipleView.this.doQuery(true);
            }
            catch (Throwable throwable) {
                BasicContext cx = new BasicContext(BBacnetTrendMultipleView.this.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
                BBacnetTrendMultipleView.this.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", new Object[]{BAbsTime.now().toString((Context)cx)}));
                BBacnetTrendMultipleView.this.liveUpdatesStatus.relayoutSync();
                throw throwable;
            }
            BasicContext cx = new BasicContext(BBacnetTrendMultipleView.this.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
            BBacnetTrendMultipleView.this.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", new Object[]{BAbsTime.now().toString((Context)cx)}));
            BBacnetTrendMultipleView.this.liveUpdatesStatus.relayoutSync();
        }

        protected void unsubscribed(BComponent c, Context cx) {
            block20: {
                try {
                    BIHistory viewHistory = BBacnetTrendMultipleView.this.getHistories(BBacnetTrendMultipleView.this.getCurrentValue())[0];
                    if (!(BBacnetTrendMultipleView.this.getShell() instanceof BWbShell)) break block20;
                    BOrd activeOrd = ((BWbShell)BBacnetTrendMultipleView.this.getShell()).getActiveOrd();
                    BOrd spaceOrd = BOrd.make((BOrd)activeOrd, (String)"history:");
                    BHistorySpace space = (BHistorySpace)spaceOrd.get();
                    BIHistory spaceHistory = null;
                    try (HistorySpaceConnection conn = space.getConnection(null);){
                        spaceHistory = conn.getHistory(viewHistory.getId());
                    }
                    if (spaceHistory != viewHistory) {
                        if (spaceHistory instanceof BHistory) {
                            BBacnetTrendMultipleView.this.currentHistory = (BHistory)spaceHistory;
                        } else {
                            BBacnetTrendMultipleView.this.currentHistory = null;
                        }
                        if (BBacnetTrendMultipleView.this.liveUpdatesCmd.isSelected()) {
                            BBacnetTrendMultipleView.this.liveUpdatesCmd.setSelected(false);
                            if (BBacnetTrendMultipleView.this.currentHistory != null) {
                                BBacnetTrendMultipleView.this.liveUpdatesCmd.setSelected(true);
                            }
                        }
                        if (BBacnetTrendMultipleView.this.currentHistory == null) {
                            BBacnetTrendMultipleView.this.liveUpdatesCmd.setEnabled(false);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception occurred in unsubscribed", e);
                }
            }
        }
    }

    private static class State {
        BDynamicTimeRange timeRange;
        BFilterSet filterSet;
        boolean deltaState;
        boolean liveUpdatesState;

        private State() {
        }
    }

    class HistoryTableController
    extends TableController {
        HistoryTableController() {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                BMultiRecordTable recTab = (BMultiRecordTable)((CollectionTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel()).getBITable();
                BGridPane recPane = new BGridPane(2);
                recPane.setColorRows(true);
                recPane.setColumnGap(9.0);
                Column[] cols = recTab.getColumns().list();
                for (int i = 0; i < cols.length; ++i) {
                    BLabel label = new BLabel(cols[i].getName(), BHalign.left);
                    label.setFont(Theme.label().getBoldText());
                    recPane.add(null, (BValue)label);
                    BValue v = (BValue)recTab.get(row).cell(cols[i]);
                    BLabel val = new BLabel(v.toString());
                    recPane.add(null, (BValue)val);
                }
                BDialog.open((BWidget)BBacnetTrendMultipleView.this, (String)"Record", (Object)recPane, (int)1);
            }
        }
    }
}

