/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.history;

import com.tridium.bacnet.history.BAbstractBacnetHistory;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BBacnetHistoryImport;
import com.tridium.bacnet.history.BBacnetTrendLogMultipleImport;
import com.tridium.bacnet.job.BDiscoveryLog;
import com.tridium.bacnet.ui.history.TrendLogLearn;
import com.tridium.driver.util.StringUtil;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.ImportModel;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BBacnetHistoryImportManager
extends BHistoryImportManager {
    public static final Type TYPE = Sys.loadType(BBacnetHistoryImportManager.class);
    private BBacnetHistoryDeviceExt deviceExt;
    private static Lexicon lexDriver = Lexicon.make((String)"driver");
    MgrColumn objectIdCol = new MgrColumn.Prop(BAbstractBacnetHistory.objectId, 1);
    MgrColumn onDemandPollEnabledCol = new MgrColumn.Prop(BHistoryImport.onDemandPollEnabled, 1);
    MgrColumn onDemandPollFrequencyCol = new MgrColumn.Prop(BHistoryImport.onDemandPollFrequency, 1);
    MgrColumn localHistoryNameFormatCol = new MgrColumn.Prop(BAbstractBacnetHistory.localHistoryNameFormat, 3);
    MgrColumn localHistoryNameCol = new LocalHistoryNameCol(BAbstractBacnetHistory.localHistoryName, 0);
    MgrColumn discHistTypeCol = new MgrColumn.Prop(BAbstractBacnetHistory.discoveryHistoryType, 7);
    MgrColumn alwaysByTimeCol = new MgrColumn.Prop(BAbstractBacnetHistory.alwaysRequestByReferenceTime, 3);

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    public MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected ImportModel makeImportModel() {
        return new Model(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public BBacnetHistoryDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        return (BBacnetHistoryDeviceExt)this.getCurrentValue();
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    protected MgrTypeInfo[] myTypes(Object dis) {
        Object[] types = null;
        types = ((BDiscoveryLog)dis).getObjectId().getObjectType() == 27 ? MgrTypeInfo.makeArray((Type)BBacnetTrendLogMultipleImport.TYPE) : MgrTypeInfo.makeArray((Type)BBacnetHistoryImport.TYPE);
        String defaultType = MgrTypeInfo.make((Type)this.getDefaultType()).toString();
        if (types.length > 0) {
            for (int i = 1; i < types.length; ++i) {
                if (!types[i].toString().equalsIgnoreCase(defaultType)) continue;
                this.swap(types, 0, i);
                break;
            }
        }
        return types;
    }

    protected Type getDefaultType() {
        return BBacnetHistoryImport.TYPE;
    }

    private void swap(Object[] types, int i, int j) {
        Object temp = types[i];
        types[i] = types[j];
        types[j] = temp;
    }

    private static class TimeZoneConfigColumn
    extends ImportModel.ConfigColumn {
        public TimeZoneConfigColumn(String propName, String displayName, int flags, BValue defaultValue) {
            super(propName, displayName, flags, defaultValue);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            BValue val = rows[0].getCell(colIndex);
            BFacets facets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE"));
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)facets);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, (Context)facets);
            return editor;
        }
    }

    public static class LocalHistoryNameCol
    extends MgrColumn.Prop {
        Property prop;

        public LocalHistoryNameCol(Property prop, int flags) {
            super(prop.getDefaultDisplayName(null), prop, flags);
            this.prop = prop;
        }

        public Object get(Object row) {
            BComplex complex = (BComplex)row;
            return SlotPath.unescape((String)complex.get(this.prop).toString());
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            String s = value.toString();
            return SlotPath.unescape((String)s);
        }
    }

    class Controller
    extends ArchiveManagerController {
        public Controller(BBacnetHistoryImportManager manager) {
            super((BArchiveManager)manager);
            this.cancel.setFlags(7);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BOrd jobOrd = BBacnetHistoryImportManager.this.getDeviceExt().submitTrendLogDiscoveryJob();
            if (jobOrd != null && !jobOrd.equals((Object)BOrd.DEFAULT)) {
                BBacnetHistoryImportManager.this.getLearn().setJob(jobOrd);
            }
            return null;
        }
    }

    static class State
    extends MgrState {
        Object[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BBacnetHistoryImportManager mgr = (BBacnetHistoryImportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BBacnetHistoryImportManager mgr = (BBacnetHistoryImportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateRoots(this.lastLearn);
            }
        }
    }

    class Learn
    extends TrendLogLearn {
        public Learn(BBacnetHistoryImportManager manager) {
            super((BAbstractManager)manager);
        }

        public boolean isExisting(Object dis, BComponent db) {
            return ((BAbstractBacnetHistory)db).getObjectId().equals((Object)this.disc(dis).getObjectId());
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return true;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return BBacnetHistoryImportManager.this.myTypes(dis);
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            row.setName(SlotPath.escape((String)this.disc(dis).getObjectName()));
            row.setCell(BBacnetHistoryImportManager.this.objectIdCol, (BValue)this.disc(dis).getObjectId());
            BValue fmt = BAbstractBacnetHistory.localHistoryNameFormat.getDefaultValue();
            row.setCell(BBacnetHistoryImportManager.this.localHistoryNameFormatCol, fmt);
            row.setCell(BBacnetHistoryImportManager.this.discHistTypeCol, (BValue)BString.make((String)this.disc(dis).getDataType()));
        }
    }

    class Model
    extends ImportModel {
        public Model(BBacnetHistoryImportManager manager) {
            super((BHistoryImportManager)manager);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BAbstractBacnetHistory.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            Array ret = new Array(TypeInfo.class);
            BString blist = BBacnetHistoryImportManager.this.getDeviceExt().getImportTypes();
            String[] infos = StringUtil.getStringArray((String)blist.getString(), (String)";");
            for (int i = 0; i < infos.length; ++i) {
                ret.add((Object)BTypeSpec.make((String)infos[i]).getTypeInfo());
            }
            return MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])ret.trim()));
        }

        protected MgrColumn[] makeColumns() {
            MgrColumn[] cols = super.makeColumns();
            MgrColumn[] result = new MgrColumn[cols.length + 8];
            result[0] = cols[0];
            result[1] = new MgrColumn.Type();
            System.arraycopy(cols, 1, result, 2, cols.length - 1);
            result[2] = BBacnetHistoryImportManager.this.objectIdCol;
            result[result.length - 7] = BBacnetHistoryImportManager.this.onDemandPollEnabledCol;
            result[result.length - 6] = BBacnetHistoryImportManager.this.onDemandPollFrequencyCol;
            result[result.length - 5] = new TimeZoneConfigColumn("timeZone", lexDriver.getText("HistoryConfig.timeZone"), 3, (BValue)BTimeZone.DEFAULT);
            result[result.length - 4] = BBacnetHistoryImportManager.this.localHistoryNameFormatCol;
            result[result.length - 3] = BBacnetHistoryImportManager.this.localHistoryNameCol;
            result[result.length - 2] = BBacnetHistoryImportManager.this.discHistTypeCol;
            result[result.length - 1] = BBacnetHistoryImportManager.this.alwaysByTimeCol;
            return result;
        }
    }
}

