/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import java.util.StringTokenizer;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BWritableSlotsEditor
extends BWbFieldEditor {
    public static final Action clearAll = BWritableSlotsEditor.newAction((int)0, null);
    public static final Action selectAll = BWritableSlotsEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWritableSlotsEditor.class);
    private boolean init = false;
    private BCheckBox[] cboxes;
    static UiLexicon lex = UiLexicon.makeUiLexicon(BWritableSlotsEditor.class);
    static String lexNotWritable = lex.getText("server.notWritable");
    static BString notWritable = BString.make((String)lexNotWritable);

    public void clearAll() {
        this.invoke(clearAll, null, null);
    }

    public void selectAll() {
        this.invoke(selectAll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        this.init = false;
        if (readonly) {
            this.setContent((BWidget)new BTextField("", 16, false));
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        if (this.isReadonly()) {
            ((BTextField)this.getContent()).setText(value.toString());
        } else {
            if (!this.init) {
                this.init = true;
                BGridPane pane = new BGridPane(18);
                this.cboxes = new BCheckBox[16];
                for (int i = 0; i < this.cboxes.length; ++i) {
                    this.cboxes[i] = new BCheckBox(String.valueOf(i + 1));
                    pane.add("c" + i, (BValue)this.cboxes[i], null);
                    this.linkTo("l" + i, (BComponent)this.cboxes[i], (Slot)BCheckBox.actionPerformed, (Slot)setModified);
                }
                BButton clrButton = new BButton(lex.getText("writableFE.clearAll"));
                BButton allButton = new BButton(lex.getText("writableFE.selectAll"));
                this.linkTo("lClr", (BComponent)clrButton, (Slot)BButton.actionPerformed, (Slot)clearAll);
                this.linkTo("lAll", (BComponent)allButton, (Slot)BButton.actionPerformed, (Slot)selectAll);
                pane.add("clr", (BValue)clrButton);
                pane.add("all", (BValue)allButton);
                this.setContent((BWidget)pane);
            }
            for (int i = 0; i < this.cboxes.length; ++i) {
                this.cboxes[i].setSelected(false);
            }
            String s = ((BString)value).getString();
            if (s.equals(lexNotWritable)) {
                return;
            }
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                int ndx = Integer.parseInt(st.nextToken().substring(2));
                this.cboxes[ndx - 1].setSelected(true);
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.cboxes.length; ++i) {
            if (!this.cboxes[i].isSelected()) continue;
            sb.append("in" + (i + 1)).append(',');
        }
        if (sb.length() > 0) {
            return BString.make((String)sb.toString().substring(0, sb.length() - 1));
        }
        return notWritable;
    }

    public void doClearAll() {
        for (int i = 0; i < this.cboxes.length; ++i) {
            this.cboxes[i].setSelected(false);
        }
        this.setModified();
    }

    public void doSelectAll() {
        for (int i = 0; i < this.cboxes.length; ++i) {
            this.cboxes[i].setSelected(true);
        }
        this.setModified();
    }
}

