/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.fe.BBacnetObjectIdentifierFE;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BacnetDeviceModel
extends DeviceModel {
    static Lexicon lexicon = UiLexicon.makeUiLexicon(BacnetDeviceModel.class);
    protected MgrColumn colName = new MgrColumn.Name();
    protected MgrColumn colChgIdName = new MgrColumn.Name(5);
    protected MgrColumn colType = new MgrColumn.Type(3);
    protected MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BBacnetDevice());
    public MgrColumn colOid = new DevId(lexicon.getText("deviceManager.deviceId"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.objectId}, 1);
    protected MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    public MgrColumn colNetNum = new MgrColumn.PropPath(lexicon.getText("deviceManager.network"), new Property[]{BBacnetDevice.address, BBacnetAddress.networkNumber}, 1);
    public MgrColumn colMacAddr = new MacAddr();
    protected MgrColumn colMaxApdu = new MgrColumn.PropPath(lexicon.getText("deviceManager.maxApdu"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.maxAPDULengthAccepted}, 2);
    protected MgrColumn colSegment = new MgrColumn.PropPath(lexicon.getText("deviceManager.segmentation"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.segmentationSupported}, 2);
    protected MgrColumn colVName = new MgrColumn.PropPath(lexicon.getText("deviceManager.vendorName"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.vendorName}, 4);
    protected MgrColumn colMName = new MgrColumn.PropPath(lexicon.getText("deviceManager.modelName"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.modelName}, 4);
    protected MgrColumn colProtocolRev = new MgrColumn.PropPath(lexicon.getText("deviceManager.protocolRev"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.protocolRevision}, 2);
    protected MgrColumn colFwRev = new MgrColumn.PropPath(lexicon.getText("deviceManager.fwRev"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.firmwareRevision}, 4);
    protected MgrColumn colAppSwVer = new MgrColumn.PropPath(lexicon.getText("deviceManager.appSwVer"), new Property[]{BBacnetDevice.config, BBacnetConfigDeviceExt.deviceObject, BBacnetDeviceObject.applicationSoftwareVersion}, 4);
    protected MgrColumn colCharSet = new MgrColumn.Prop(lexicon.getText("deviceManager.charSet"), BBacnetDevice.characterSet, 2);
    protected MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    protected MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);
    public MgrColumn colUseCov = new MgrColumn.Prop(BBacnetDevice.useCov, 3);
    public MgrColumn colUseCovProperty = new MgrColumn.Prop(BBacnetDevice.useCovProperty, 3);
    protected MgrColumn colMaxCovSub = new MgrColumn.Prop(BBacnetDevice.maxCovSubscriptions, 3);
    protected MgrColumn colCovSub = new MgrColumn.Prop(BBacnetDevice.covSubscriptions, 2);
    @Deprecated
    protected MgrColumn colPollFreq = new MgrColumn.Prop(BBacnetDevice.pollFrequency, 3);
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colOid, this.colStatus, this.colNetNum, this.colMacAddr, this.colMaxApdu, this.colSegment, this.colVName, this.colMName, this.colProtocolRev, this.colFwRev, this.colAppSwVer, this.colCharSet, this.colHealth, this.colEnabled, this.colUseCov, this.colUseCovProperty, this.colMaxCovSub, this.colCovSub};
    protected MgrColumn[] changeIdCols = new MgrColumn[]{this.colChgIdName, this.colType, this.colOid};

    public BacnetDeviceModel(BBacnetDeviceManager manager) {
        super((BDeviceManager)manager);
    }

    public BBacnetDeviceManager getBacnetDeviceManager() {
        return (BBacnetDeviceManager)this.getManager();
    }

    public MgrTypeInfo[] getNewTypes() {
        return this.getBacnetDeviceManager().toTypes();
    }

    protected MgrColumn[] makeColumns() {
        return this.cols;
    }

    public MgrColumn[] getChangeIdColumns() {
        return this.changeIdCols;
    }

    static class MacAddr
    extends MgrColumn {
        public MacAddr() {
            super(lexicon.getText("deviceManager.mac"), 1);
        }

        public Object get(Object row) {
            BBacnetDevice dev = (BBacnetDevice)row;
            return BBacnetAddress.bytesToString((int)dev.getAddress().getAddressType(), (byte[])dev.getAddress().getMacAddress().getBytes());
        }

        public BValue load(MgrEditRow row) {
            BBacnetDevice dev = (BBacnetDevice)row.getTarget();
            BBacnetAddress addr = dev.getAddress();
            return BString.make((String)BBacnetAddress.bytesToString((int)addr.getAddressType(), (byte[])addr.getMacAddress().getBytes()));
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            int netNum = ((BInteger)row.getCell(((BBacnetDeviceManager)row.getManager()).bacModel().colNetNum)).getInt();
            BBacnetDevice dev = (BBacnetDevice)row.getTarget();
            BBacnetAddress addr = (BBacnetAddress)dev.getAddress().newCopy();
            addr.setNetworkNumber(netNum);
            String mac = ((BString)value).getString();
            int ndx = mac.indexOf(".");
            if (ndx > 0) {
                addr.setAddressType(2);
            } else {
                ndx = mac.indexOf(":");
                if (ndx > 0) {
                    addr.setAddressType(1);
                } else if (!mac.equals("null") && mac.length() <= 4) {
                    addr.setAddressType(3);
                }
            }
            addr.setMac(BBacnetAddress.stringToBytes((int)addr.getAddressType(), (int)5, (String)mac), null);
            dev.set(BBacnetDevice.address, (BValue)addr, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BString mac0 = (BString)rows[0].getCell(colIndex);
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)mac0, null);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)mac0, null);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BString mac = (BString)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)mac);
            }
        }
    }

    static class DevId
    extends MgrColumn.PropPath {
        Property[] props;
        BEnumRange DEV_RANGE = BEnumRange.make((int[])new int[]{8}, (String[])new String[]{BBacnetObjectType.device.getTag()});

        public DevId(String name, Property[] props, int flags) {
            super(name, props, flags);
            this.props = props;
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BValue val = rows[0].getCell(colIndex);
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
                return null;
            }
            BFacets facets = rows.length == 1 && this.props.length == 1 ? rows[0].getTarget().getSlotFacets((Slot)this.props[0]) : this.props[this.props.length - 1].getFacets();
            facets = BFacets.make((BFacets)facets, (String)"range", (BIDataValue)this.DEV_RANGE);
            Context cx = rows[0].getManager().getCurrentContext();
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            BBacnetObjectIdentifierFE editor = new BBacnetObjectIdentifierFE();
            if (currentEditor != null && currentEditor.getClass() == ((Object)((Object)editor)).getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BWbFieldEditor fe = (BWbFieldEditor)editor;
            BBacnetObjectIdentifier id = (BBacnetObjectIdentifier)fe.saveValue();
            int inst = id.getInstanceNumber();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)BBacnetObjectIdentifier.make((int)id.getObjectType(), (int)(inst + i)));
            }
        }
    }
}

