/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.job.BBacnetDiscoverDevicesJob;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.ui.device.BacnetDeviceController;
import com.tridium.bacnet.ui.device.BacnetDeviceLearn;
import com.tridium.bacnet.ui.device.BacnetDeviceModel;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ComponentTreeCursor;
import com.tridium.workbench.job.BJobBar;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.view.BWbComponentView;

public class BBacnetDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BBacnetDeviceManager.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BBacnetDeviceManager.class);
    static BImage bacnetDeviceIcon = BImage.make((String)"module://icons/x16/device.png");
    private DeviceManagerSubscriber sub = new DeviceManagerSubscriber();
    private BBacnetNetwork bacnet;
    protected BJobBar jobBar;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new BacnetDeviceModel(this);
    }

    protected MgrController makeController() {
        return new BacnetDeviceController(this);
    }

    protected MgrLearn makeLearn() {
        return new BacnetDeviceLearn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    protected BacnetDeviceModel bacModel() {
        return (BacnetDeviceModel)this.getModel();
    }

    protected BacnetDeviceLearn bacLearn() {
        return (BacnetDeviceLearn)this.getLearn();
    }

    protected BacnetDeviceController bacController() {
        return (BacnetDeviceController)this.getController();
    }

    public void doLoadValue(BObject value, Context cx) {
        this.bacnet = (BBacnetNetwork)((BIDeviceFolder)value).getNetwork();
        super.doLoadValue(value, cx);
        if (this.jobBar == null) {
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
        }
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        ((BEdgePane)this.getContent()).setTop((BWidget)jobPane);
        BBacnetStack stack = (BBacnetStack)this.bacnet.getBacnetComm();
        this.sub.subscribe((BComponent)stack.getNetwork(), 1);
        this.subscribeDevices(value.asComponent());
    }

    protected BJobBar getJobBar() {
        return this.jobBar;
    }

    void subscribeDevices(BComponent value) {
        BBacnetDevice[] devices;
        if (this.bacController().allDescendants.isSelected()) {
            Array a = new Array(BBacnetDevice.class);
            ComponentTreeCursor c = new ComponentTreeCursor(value, null);
            while (c.next(BBacnetDevice.class)) {
                a.add((Object)((BBacnetDevice)c.get()));
            }
            devices = (BBacnetDevice[])a.trim();
        } else {
            devices = (BBacnetDevice[])value.getChildren(BBacnetDevice.class);
        }
        for (int i = 0; i < devices.length; ++i) {
            BBacnetConfigDeviceExt cfg = devices[i].getConfig();
            this.sub.subscribe((BComponent)cfg, 1);
            this.sub.subscribe((BComponent)cfg.getDeviceObject(), 0);
        }
    }

    public void deactivated() {
        this.sub.unsubscribeAll();
    }

    public void handleComponentEvent(BComponentEvent event) {
        BJob job;
        super.handleComponentEvent(event);
        if (this.bacController().job == event.getSourceComponent() && (job = (BJob)event.getSourceComponent()).getJobState().isComplete() && !this.bacLearn().jobComplete) {
            this.bacLearn().jobComplete = true;
            this.bacLearn().jobComplete(job);
        }
    }

    public BBacnetNetwork getNetwork() {
        if (this.bacnet == null) {
            this.bacnet = (BBacnetNetwork)((BIDeviceFolder)this.getCurrentValue()).getNetwork();
        }
        return this.bacnet;
    }

    public MgrTypeInfo[] toTypes() {
        Array infos = new Array(TypeInfo.class);
        Array legalParents = new Array(TypeInfo.class);
        infos.addAll((Object[])Sys.getRegistry().getConcreteTypes(this.getNetwork().getDeviceType().getTypeInfo()));
        for (int i = 0; i < infos.size(); ++i) {
            TypeInfo info = (TypeInfo)infos.get(i);
            BComponent b = (BComponent)info.getInstance();
            if (!b.isParentLegal((BComponent)this.bacnet)) continue;
            legalParents.add((Object)info);
        }
        TypeInfo[] typeInfos = new TypeInfo[legalParents.size()];
        for (int i = 0; i < legalParents.size(); ++i) {
            typeInfos[i] = (TypeInfo)legalParents.get(i);
        }
        return MgrTypeInfo.makeArray((TypeInfo[])typeInfos);
    }

    protected TypeInfo getDefaultType() {
        return BBacnetDevice.TYPE.getTypeInfo();
    }

    private class DeviceManagerSubscriber
    extends Subscriber {
        private DeviceManagerSubscriber() {
        }

        public void event(BComponentEvent event) {
            BBacnetDeviceManager.this.handleComponentEvent(event);
        }
    }

    static class State
    extends DeviceState {
        BDiscoveryDevice[] lastLearn;
        BJob lrnJob;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BacnetDeviceLearn lrn = (BacnetDeviceLearn)m.getLearn();
            this.lastLearn = lrn.lastLearn;
            if (lrn.getJob() instanceof BBacnetDiscoverDevicesJob) {
                this.lrnJob = lrn.getJob();
            }
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BacnetDeviceLearn lrn = (BacnetDeviceLearn)m.getLearn();
            if (this.lastLearn != null) {
                lrn.updateRoots(this.lastLearn);
            }
            if (this.lrnJob != null) {
                lrn.setJob(this.lrnJob);
            }
        }
    }
}

