/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart.binding;

import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;

public abstract class BChartBinding
extends BBinding {
    public static final Property seriesName = BChartBinding.newProperty((int)0, (String)"", null);
    public static final Property xAxis = BChartBinding.newProperty((int)0, (BValue)new BAxisSpec(), null);
    public static final Property yAxis = BChartBinding.newProperty((int)0, (BValue)new BAxisSpec(), null);
    public static final Property brush = BChartBinding.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property pen = BChartBinding.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    public static final Type TYPE = Sys.loadType(BChartBinding.class);
    private boolean bound = false;

    public String getSeriesName() {
        return this.getString(seriesName);
    }

    public void setSeriesName(String v) {
        this.setString(seriesName, v, null);
    }

    public BAxisSpec getXAxis() {
        return (BAxisSpec)this.get(xAxis);
    }

    public void setXAxis(BAxisSpec v) {
        this.set(xAxis, (BValue)v, null);
    }

    public BAxisSpec getYAxis() {
        return (BAxisSpec)this.get(yAxis);
    }

    public void setYAxis(BAxisSpec v) {
        this.set(yAxis, (BValue)v, null);
    }

    public BBrush getBrush() {
        return (BBrush)this.get(brush);
    }

    public void setBrush(BBrush v) {
        this.set(brush, (BValue)v, null);
    }

    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BChart getChart() {
        BComplex p = this.getParent();
        if (p instanceof BChart) {
            return (BChart)p;
        }
        return null;
    }

    public abstract Series createSeries();

    public void started() {
        super.started();
        this.checkBound();
        if (this.bound) {
            this.valueChanged();
        }
    }

    public void targetChanged() {
        this.checkBound();
        if (this.bound) {
            this.valueChanged();
        }
    }

    private void checkBound() {
        boolean boundState = this.isBound();
        if (this.bound != boundState) {
            this.bound = boundState;
            if (this.bound) {
                this.bound();
            } else {
                this.unbound();
            }
        }
    }

    protected void bound() {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        ChartModel model = chart.getModel();
        if (!(model instanceof BoundChartModel)) {
            return;
        }
        ((BoundChartModel)model).syncBindings();
    }

    protected void unbound() {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        ChartModel model = chart.getModel();
        if (!(model instanceof BoundChartModel)) {
            return;
        }
        ((BoundChartModel)model).syncBindings();
    }

    protected void valueChanged() {
    }
}

