/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.data.BDataTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModelEvent;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public abstract class ChartModel
extends BChart.ChartSupport {
    public static Logger log = Logger.getLogger("chart.ChartModel");

    public abstract int getSpecCount();

    public abstract ChartSpec getSpec(int var1);

    public Series[] getAllSeries() {
        int specCount = this.getSpecCount();
        Series[] seriesList = new Series[specCount];
        for (int i = 0; i < specCount; ++i) {
            seriesList[i] = this.getSpec(i).getSeries();
        }
        return seriesList;
    }

    public void fireSeriesModified(Series series) {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        ChartSpec spec = this.getSpecForSeries(series);
        if (spec != null) {
            this.fireSpecModified(spec);
        } else {
            this.fireModelModified();
        }
    }

    public void fireSpecModified(ChartSpec spec) {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        chart.modelModified(new ChartModelEvent(this, 3, spec));
    }

    public void fireSpecAdded(ChartSpec spec) {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        chart.modelModified(new ChartModelEvent(this, 1, spec));
    }

    public void fireSpecRemoved(ChartSpec spec) {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        chart.modelModified(new ChartModelEvent(this, 2, spec));
    }

    public void fireModelModified() {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        chart.modelModified(new ChartModelEvent(this, 0));
    }

    public ChartSpec getSpecForSeries(Series series) {
        if (series == null) {
            return null;
        }
        int specCount = this.getSpecCount();
        for (int i = 0; i < specCount; ++i) {
            ChartSpec spec = this.getSpec(i);
            if (spec.getSeries() != series) continue;
            return spec;
        }
        return null;
    }

    public BAxis[] getAxes(BAxisDimension dim) {
        int count = this.getSpecCount();
        ArrayList<BAxis> temp = new ArrayList<BAxis>(count);
        for (int i = 0; i < count; ++i) {
            ChartSpec spec = this.getSpec(i);
            BAxis axis = spec.getXAxis();
            if (axis.getDimension() == dim && !temp.contains((Object)axis)) {
                temp.add(axis);
            }
            if ((axis = spec.getYAxis()).getDimension() != dim || temp.contains((Object)axis)) continue;
            temp.add(axis);
        }
        return temp.toArray(new BAxis[temp.size()]);
    }

    public BAxis findAxis(BAxis axis) {
        BAxisDimension dim = axis.getDimension();
        int count = this.getSpecCount();
        for (int i = 0; i < count; ++i) {
            ChartSpec spec = this.getSpec(i);
            BAxis check = null;
            check = dim == BAxisDimension.x ? spec.getXAxis() : spec.getYAxis();
            if (check == null || !check.isCompatible(axis)) continue;
            return check;
        }
        return null;
    }

    public BITable<?> export() {
        int i;
        BDataTable t = new BDataTable();
        Series[] series = this.getAllSeries();
        for (int i2 = 0; i2 < series.length; ++i2) {
            BFacets cfacets;
            Type ctype;
            String dname;
            String cname;
            Series s = series[i2];
            if (i2 == 0) {
                cname = s.getColumnName(0);
                dname = s.getColumnDisplayName(0);
                ctype = s.getColumnType(0);
                cfacets = s.getColumnFacets(0);
                t.addColumn(cname, dname, ctype, 0, cfacets);
            }
            cname = s.getColumnName(1);
            dname = s.getColumnDisplayName(1);
            ctype = s.getColumnType(1);
            cfacets = s.getColumnFacets(1);
            BFacets sfacets = BFacets.make((String)"SERIES_NAME", (String)s.getName());
            cfacets = BFacets.make((BFacets)cfacets, (BFacets)sfacets);
            t.addColumn(cname, dname, ctype, 0, cfacets);
        }
        log.setLevel(Level.INFO);
        ArrayList<BIDataValue[]> map = new ArrayList<BIDataValue[]>();
        for (i = 0; i < series.length; ++i) {
            Series s = series[i];
            for (int r = 0; r < s.getRowCount(); ++r) {
                BIDataValue val;
                BIDataValue key = (BIDataValue)s.getValue(r, 0);
                Object o = s.getValue(r, 1);
                if (o instanceof BIDataValue) {
                    val = (BIDataValue)s.getValue(r, 1);
                } else {
                    log.log(Level.INFO, "Export Object type " + o.getClass().getName().toString() + " is not compatible with BIDataValue");
                    val = null;
                }
                BIDataValue[] v = null;
                for (int j = 0; j < map.size(); ++j) {
                    BIDataValue[] z = (BIDataValue[])map.get(j);
                    if (!z[0].equals(key)) continue;
                    v = z;
                    break;
                }
                if (v == null) {
                    v = new BIDataValue[series.length + 1];
                    v[0] = key;
                    map.add(v);
                }
                v[i + 1] = val;
            }
        }
        Collections.sort(map, new KeyComparator());
        t.startRows();
        for (i = 0; i < map.size(); ++i) {
            t.startRow();
            BIDataValue[] v = (BIDataValue[])map.get(i);
            for (int j = 0; j < v.length; ++j) {
                Object dv = v[j];
                if (dv == null) {
                    ColumnList cols = t.getColumns();
                    Column column = cols.get(j);
                    Type colType = column.getType();
                    char symbol = colType.getDataTypeSymbol();
                    dv = symbol == 'b' ? BBoolean.DEFAULT : (symbol == 's' ? BString.DEFAULT : BDouble.NaN);
                }
                t.set(dv, BFacets.NULL);
            }
            t.endRow();
        }
        return t;
    }

    private class KeyComparator
    implements Comparator {
        private KeyComparator() {
        }

        public int compare(Object a, Object b) {
            BIDataValue[] dv1 = (BIDataValue[])a;
            BIDataValue[] dv2 = (BIDataValue[])b;
            if (dv1.length > 0 && dv2.length > 0 && dv1[0] instanceof Comparable) {
                return ((Comparable)dv1[0]).compareTo(dv2[0]);
            }
            return 0;
        }
    }
}

