/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.BContinuousAxis;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public class BStackedBarChart
extends BChart {
    public static final Type TYPE = Sys.loadType(BStackedBarChart.class);
    private JoinTable joinTable;
    private double barWidth;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BStackedBarChart() {
    }

    public BStackedBarChart(ChartModel model) {
        super(model);
    }

    @Override
    public void updateAxes() {
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        BAxis yaxis = model.getSpec(0).getYAxis();
        BAxis xaxis = model.getSpec(0).getXAxis();
        if (xaxis == null || yaxis == null) {
            return;
        }
        if (this.joinTable == null) {
            this.joinTable = JoinTable.make(model.getAllSeries(), 0);
        }
        if (xaxis != null) {
            Object maxValue;
            Object minValue;
            xaxis.updateFacets(this.joinTable.getSeries(0).getColumnFacets(0));
            if (xaxis.isMinAuto() && (minValue = this.joinTable.getSeries(0).getMin(0)) != null) {
                xaxis.updateAutoMin(minValue);
            }
            if (xaxis.isMaxAuto() && (maxValue = this.joinTable.getSeries(0).getMax(0)) != null) {
                xaxis.updateAutoMax(maxValue);
            }
        }
        if (yaxis != null) {
            Object ymax;
            Object ymin;
            yaxis.updateFacets(this.joinTable.getSeries(0).getColumnFacets(1));
            if (yaxis.isMinAuto() && (ymin = this.joinTable.getMinRow()) != null) {
                yaxis.updateAutoMin(ymin);
            }
            if (yaxis.isMaxAuto() && (ymax = this.joinTable.getMaxRow()) != null) {
                yaxis.updateAutoMax(ymax);
            }
        }
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        if (this.joinTable == null) {
            this.joinTable = JoinTable.make(model.getAllSeries(), 0);
        }
        BAxis keyAxis = model.getSpec(0).getXAxis();
        this.barWidth = 0.0;
        if (keyAxis instanceof BDiscreteAxis) {
            Object[] tickValues = keyAxis.getTickValues();
            if (tickValues.length == 1) {
                this.barWidth = w * 2.0 / 3.0;
            } else {
                double spacing = keyAxis.toDisplaySpace(tickValues[1]) - keyAxis.toDisplaySpace(tickValues[0]);
                this.barWidth = spacing * 2.0 / 3.0;
            }
        } else {
            this.barWidth = w / 16.0;
        }
    }

    @Override
    public void doPaint(Graphics g) {
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        BAxis xaxis = model.getSpec(0).getXAxis();
        BContinuousAxis yaxis = (BContinuousAxis)model.getSpec(0).getYAxis();
        if (this.joinTable == null) {
            this.joinTable = this.join(0);
        }
        int rowCount = this.joinTable.getRowCount();
        int colCount = this.joinTable.getColumnCount();
        double zeroLoc = yaxis.toDisplaySpace(yaxis.getZero());
        for (int row = 0; row < rowCount; ++row) {
            Object key = this.joinTable.getKey(row);
            double loc = xaxis.toDisplaySpace(key);
            double bar = loc - this.barWidth / 2.0;
            double barTop = zeroLoc;
            for (int col = 0; col < colCount; ++col) {
                double y;
                Object barValue = this.joinTable.getValue(row, col);
                if (barValue == null || (y = yaxis.toDisplaySpace(this.joinTable.getValue(row, col))) > zeroLoc) continue;
                Series series = this.joinTable.getSeries(col);
                BPen pen = series.getPen();
                g.setPen(pen == null ? BPen.DEFAULT : pen);
                g.setBrush(series.getBrush());
                g.fillRect(bar, y - (zeroLoc - barTop), this.barWidth, zeroLoc - y);
                g.setBrush(BColor.black.toBrush());
                g.strokeRect(bar, y - (zeroLoc - barTop), this.barWidth, zeroLoc - y);
                barTop = y - (zeroLoc - barTop);
            }
        }
    }
}

