/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.chart.BAxisContainer;
import com.tridium.chart.BDockedPanControl;
import com.tridium.ui.UiEnv;
import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartCanvas;
import javax.baja.chart.BChartHeader;
import javax.baja.chart.BChartLegend;
import javax.baja.chart.BDefaultChartLegend;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.ChartController;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.collection.BITable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;

public class BChartPane
extends BPane {
    public static final Property border = BChartPane.newProperty((int)0, (BValue)BBorder.solid, null);
    public static final Property background = BChartPane.newProperty((int)0, (BValue)BColor.make((String)"#eee").toBrush(), null);
    public static final Property header = BChartPane.newProperty((int)0, (BValue)new BChartHeader(), null);
    public static final Property canvas = BChartPane.newProperty((int)0, (BValue)new BChartCanvas(), null);
    public static final Property legend = BChartPane.newProperty((int)0, (BValue)new BDefaultChartLegend(), null);
    public static final Property zoomEnabled = BChartPane.newProperty((int)0, (boolean)true, null);
    public static final Property leftAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.y, BAxisLocation.left), null);
    public static final Property rightAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.y, BAxisLocation.right), null);
    public static final Property topAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.x, BAxisLocation.top), null);
    public static final Property bottomAxes = BChartPane.newProperty((int)6, (BValue)new BAxisContainer(BAxisDimension.x, BAxisLocation.bottom), null);
    public static final Action showPanControl = BChartPane.newAction((int)0, null);
    public static final Action hidePanControl = BChartPane.newAction((int)0, null);
    public static final Topic showPanRequested = BChartPane.newTopic((int)0, null);
    public static final Topic hidePanRequested = BChartPane.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BChartPane.class);
    private int rebuildCountDown = 0;
    private boolean buildRequired = false;
    private ChartController controller;
    private ArrayList<ZoomSpec> zoomStack = new ArrayList();
    private BDockedPanControl panControl = null;
    private BBorderPane panPane;
    private boolean zoomed = false;
    private Context context;
    private static Lexicon lex = Lexicon.make((String)"chart");
    private static BFont font = BFont.make((String)lex.getText("chart.pane.font"));
    public static final BColor[] DEFAULT_COLORS = new BColor[]{BColor.make((int)3882693), BColor.make((int)11808816), BColor.make((int)0x2AA22A), BColor.make((int)9468084), BColor.make((int)13866541), BColor.make((int)4959430), BColor.make((int)10337121), BColor.make((int)4547207), BColor.make((int)0x800000), BColor.make((int)3703188), BColor.make((int)6311032), BColor.make((int)128)};

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder v) {
        this.set(border, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BChartHeader getHeader() {
        return (BChartHeader)this.get(header);
    }

    public void setHeader(BChartHeader v) {
        this.set(header, (BValue)v, null);
    }

    public BChartCanvas getCanvas() {
        return (BChartCanvas)this.get(canvas);
    }

    public void setCanvas(BChartCanvas v) {
        this.set(canvas, (BValue)v, null);
    }

    public BChartLegend getLegend() {
        return (BChartLegend)this.get(legend);
    }

    public void setLegend(BChartLegend v) {
        this.set(legend, (BValue)v, null);
    }

    public boolean getZoomEnabled() {
        return this.getBoolean(zoomEnabled);
    }

    public void setZoomEnabled(boolean v) {
        this.setBoolean(zoomEnabled, v, null);
    }

    public BWidget getLeftAxes() {
        return (BWidget)this.get(leftAxes);
    }

    public void setLeftAxes(BWidget v) {
        this.set(leftAxes, (BValue)v, null);
    }

    public BWidget getRightAxes() {
        return (BWidget)this.get(rightAxes);
    }

    public void setRightAxes(BWidget v) {
        this.set(rightAxes, (BValue)v, null);
    }

    public BWidget getTopAxes() {
        return (BWidget)this.get(topAxes);
    }

    public void setTopAxes(BWidget v) {
        this.set(topAxes, (BValue)v, null);
    }

    public BWidget getBottomAxes() {
        return (BWidget)this.get(bottomAxes);
    }

    public void setBottomAxes(BWidget v) {
        this.set(bottomAxes, (BValue)v, null);
    }

    public void showPanControl() {
        this.invoke(showPanControl, null, null);
    }

    public void hidePanControl() {
        this.invoke(hidePanControl, null, null);
    }

    public void fireShowPanRequested(BWidgetEvent event) {
        this.fire(showPanRequested, (BValue)event, null);
    }

    public void fireHidePanRequested(BWidgetEvent event) {
        this.fire(hidePanRequested, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BChartPane() {
        this.setController(new ChartController());
    }

    public BChartPane(BChart chart) {
        this.setController(new ChartController());
        this.add(null, (BValue)chart);
    }

    public void started() {
        if (!UiEnv.get().hasMouse()) {
            this.panControl = new BDockedPanControl(this);
            this.panPane = new BBorderPane((BWidget)this.panControl);
            this.panPane.setPadding(BInsets.make((double)0.0));
            this.panPane.setBorder(BBorder.make((int)7));
            this.add(null, (BValue)this.panPane);
            this.linkTo((BComponent)this, (Slot)showPanRequested, (Slot)showPanControl);
            this.linkTo((BComponent)this, (Slot)hidePanRequested, (Slot)hidePanControl);
        }
        this.build();
    }

    public final BChart[] getCharts() {
        BChart[] temp = new BChart[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            BValue kid = c.get();
            if (!(kid instanceof BChart)) continue;
            temp[count++] = (BChart)kid;
        }
        BChart[] result = new BChart[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public Series[] getAllSeries() {
        ArrayList<Series> temp = new ArrayList<Series>(this.getSlotCount());
        SlotCursor c = this.getProperties();
        while (c.next(BChart.class)) {
            BChart chart = (BChart)c.get();
            ChartModel model = chart.getModel();
            int specCount = model.getSpecCount();
            for (int i = 0; i < specCount; ++i) {
                temp.add(model.getSpec(i).getSeries());
            }
        }
        return temp.toArray(new Series[temp.size()]);
    }

    public BAxis[] getAxes(BAxisDimension dim) {
        BAxis[] axes = null;
        if (dim == BAxisDimension.x) {
            BAxisContainer bottom = (BAxisContainer)this.getBottomAxes();
            BAxisContainer top = (BAxisContainer)this.getTopAxes();
            axes = new BAxis[bottom.getAxisCount() + top.getAxisCount()];
            bottom.copyInto(axes, 0);
            top.copyInto(axes, bottom.getAxisCount());
        } else if (dim == BAxisDimension.y) {
            BAxisContainer left = (BAxisContainer)this.getLeftAxes();
            BAxisContainer right = (BAxisContainer)this.getRightAxes();
            axes = new BAxis[left.getAxisCount() + right.getAxisCount()];
            left.copyInto(axes, 0);
            right.copyInto(axes, left.getAxisCount());
        }
        if (axes == null) {
            return new BAxis[0];
        }
        return axes;
    }

    public ChartController getController() {
        return this.controller;
    }

    public void setController(ChartController newController) {
        if (newController == null) {
            throw new NullPointerException();
        }
        if (newController == this.controller) {
            return;
        }
        if (newController.getPane() != null) {
            throw new IllegalStateException("Controller is already installed on another pane.");
        }
        newController.setPane(this);
        if (this.controller != null) {
            this.controller.setPane(null);
        }
        this.controller = newController;
    }

    public void doShowPanControl() {
        this.zoomed = true;
        this.panControl.updateActionStates();
        this.relayout();
        this.repaint();
    }

    public void doHidePanControl() {
        this.zoomed = false;
        this.relayout();
        this.repaint();
    }

    public void zoomIn(BAxisDimension dim, double v1, double v2) {
        ZoomSpec zoom = new ZoomSpec(dim);
        BAxis[] axes = this.getAxes(dim);
        for (int i = 0; i < axes.length; ++i) {
            Object newMax;
            Object newMin;
            BAxis axis = axes[i];
            if (!axis.isZoomEnabled() || !axis.validateZoom(newMin = axis.fromDisplaySpace(v1), newMax = axis.fromDisplaySpace(v2))) continue;
            zoom.add(axis, axis.getAxisMin(), axis.getAxisMax());
            axis.setAxisMin(newMin);
            axis.setAxisMax(newMax);
            axis.doLayout();
        }
        this.getCanvas().relayout();
        if (!zoom.isEmpty()) {
            this.zoomStack.add(zoom);
            this.fireShowPanRequested(null);
        }
    }

    public boolean isZoomed(BAxisDimension dim) {
        int count = this.zoomStack.size();
        for (int i = 0; i < count; ++i) {
            ZoomSpec zoom = this.zoomStack.get(i);
            if (zoom.dim != dim) continue;
            return true;
        }
        return false;
    }

    public void zoomOut() {
        if (this.zoomStack.size() == 0) {
            return;
        }
        ZoomSpec zoom = this.zoomStack.get(this.zoomStack.size() - 1);
        this.zoomStack.remove(this.zoomStack.size() - 1);
        int axisCount = zoom.list.size();
        for (int i = 0; i < axisCount; ++i) {
            Restore r = zoom.list.get(i);
            r.axis.setAxisMin(r.min);
            r.axis.setAxisMax(r.max);
            r.axis.doLayout();
        }
        if (this.zoomStack.size() == 0) {
            this.fireHidePanRequested(null);
        } else {
            this.fireShowPanRequested(null);
        }
        this.getCanvas().relayout();
        this.getCanvas().repaint();
    }

    public void noZoom() {
        if (this.zoomStack.size() == 0) {
            this.fireHidePanRequested(null);
            return;
        }
        while (this.zoomStack.size() > 0) {
            ZoomSpec zoom = this.zoomStack.get(this.zoomStack.size() - 1);
            this.zoomStack.remove(this.zoomStack.size() - 1);
            int axisCount = zoom.list.size();
            for (int i = 0; i < axisCount; ++i) {
                Restore r = zoom.list.get(i);
                r.axis.setAxisMin(r.min);
                r.axis.setAxisMax(r.max);
                r.axis.doLayout();
            }
        }
        this.fireHidePanRequested(null);
        this.getCanvas().relayout();
        this.getCanvas().repaint();
    }

    public void panLeft() {
        if (!this.isZoomed(BAxisDimension.x)) {
            return;
        }
        BChartCanvas canvas = this.getCanvas();
        double w = canvas.getWidth();
        double panWidth = w / 10.0;
        double newMinLoc = -panWidth;
        double newMaxLoc = newMinLoc + w;
        for (BAxis axis : this.getAxes(BAxisDimension.x)) {
            if (!axis.isZoomEnabled()) continue;
            Object newMin = axis.fromDisplaySpace(newMinLoc += axis.getMinMargin());
            Object newMax = axis.fromDisplaySpace(newMaxLoc -= axis.getMaxMargin());
            axis.setAxisMin(newMin);
            axis.setAxisMax(newMax);
            axis.doLayout();
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void panRight() {
        double panWidth;
        if (!this.isZoomed(BAxisDimension.x)) {
            return;
        }
        BChartCanvas canvas = this.getCanvas();
        double w = canvas.getWidth();
        double newMinLoc = panWidth = w / 10.0;
        double newMaxLoc = newMinLoc + w;
        for (BAxis axis : this.getAxes(BAxisDimension.x)) {
            if (!axis.isZoomEnabled()) continue;
            Object newMin = axis.fromDisplaySpace(newMinLoc += axis.getMinMargin());
            Object newMax = axis.fromDisplaySpace(newMaxLoc -= axis.getMaxMargin());
            axis.setAxisMin(newMin);
            axis.setAxisMax(newMax);
            axis.doLayout();
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void panUp() {
        if (!this.isZoomed(BAxisDimension.y)) {
            return;
        }
        BChartCanvas canvas = this.getCanvas();
        double h = canvas.getHeight();
        double panHeight = h / 10.0;
        double newMinLoc = h - panHeight;
        double newMaxLoc = newMinLoc - h;
        for (BAxis axis : this.getAxes(BAxisDimension.y)) {
            Object newMax;
            Object newMin;
            if (!axis.isZoomEnabled()) continue;
            if (axis instanceof BNumericAxis) {
                double oldMin = ((BDouble)axis.getAxisMin()).getDouble();
                double oldMax = ((BDouble)axis.getAxisMax()).getDouble();
                newMin = axis.fromDisplaySpace(newMinLoc);
                newMax = BDouble.make((double)(((BDouble)newMin).getDouble() + (oldMax - oldMin)));
            } else {
                newMin = axis.fromDisplaySpace(newMinLoc);
                newMax = axis.fromDisplaySpace(newMaxLoc);
            }
            axis.setAxisMin(newMin);
            axis.setAxisMax(newMax);
            axis.doLayout();
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void panDown() {
        if (!this.isZoomed(BAxisDimension.y)) {
            return;
        }
        BChartCanvas canvas = this.getCanvas();
        double h = canvas.getHeight();
        double panHeight = h / 10.0;
        double newMinLoc = h + panHeight;
        double newMaxLoc = newMinLoc - h;
        for (BAxis axis : this.getAxes(BAxisDimension.y)) {
            Object newMax;
            Object newMin;
            if (!axis.isZoomEnabled()) continue;
            if (axis instanceof BNumericAxis) {
                double oldMin = ((BDouble)axis.getAxisMin()).getDouble();
                double oldMax = ((BDouble)axis.getAxisMax()).getDouble();
                newMin = axis.fromDisplaySpace(newMinLoc);
                newMax = BDouble.make((double)(((BDouble)newMin).getDouble() + (oldMax - oldMin)));
            } else {
                newMin = axis.fromDisplaySpace(newMinLoc);
                newMax = axis.fromDisplaySpace(newMaxLoc);
            }
            axis.setAxisMin(newMin);
            axis.setAxisMax(newMax);
            axis.doLayout();
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public BWidget childAt(Point pt) {
        BChartCanvas canvas = this.getCanvas();
        if (canvas.contains(pt.x - canvas.getX(), pt.y - canvas.getY())) {
            return this.getCanvas();
        }
        return super.childAt(pt);
    }

    public void computePreferredSize() {
        BChartHeader header = this.getHeader();
        header.computePreferredSize();
        this.setPreferredSize(Math.max(300.0, header.getPreferredWidth()), 300.0);
    }

    public synchronized void refresh() {
        SlotCursor charts = this.getProperties();
        ((BAxisContainer)this.getLeftAxes()).reset();
        ((BAxisContainer)this.getBottomAxes()).reset();
        ((BAxisContainer)this.getRightAxes()).reset();
        ((BAxisContainer)this.getTopAxes()).reset();
        while (charts.next(BChart.class)) {
            BChart chart = (BChart)charts.get();
            chart.updateAxes();
            chart.relayout();
        }
        this.getCanvas().relayout();
        this.repaint();
    }

    public void animate() {
        super.animate();
        if (this.buildRequired) {
            if (this.rebuildCountDown == 0) {
                this.buildRequired = false;
                this.build();
                this.relayout();
            } else {
                --this.rebuildCountDown;
            }
        }
    }

    public void rebuild() {
        this.buildRequired = true;
        this.rebuildCountDown = 1;
    }

    public synchronized void build() {
        BAxisContainer leftAxes = (BAxisContainer)this.getLeftAxes();
        BAxisContainer rightAxes = (BAxisContainer)this.getRightAxes();
        BAxisContainer topAxes = (BAxisContainer)this.getTopAxes();
        BAxisContainer bottomAxes = (BAxisContainer)this.getBottomAxes();
        leftAxes.removeAllAxes();
        rightAxes.removeAllAxes();
        topAxes.removeAllAxes();
        bottomAxes.removeAllAxes();
        BChart[] charts = this.getCharts();
        int chartCount = charts.length;
        for (int c = 0; c < chartCount; ++c) {
            charts[c].updateAxes();
            boolean useX = charts[c].usesXAxis();
            boolean useY = charts[c].usesYAxis();
            ChartModel model = charts[c].getModel();
            int specCount = model.getSpecCount();
            for (int i = 0; i < specCount; ++i) {
                BAxis yaxis;
                ChartSpec spec = model.getSpec(i);
                this.assignColors(spec);
                BAxis xaxis = useX ? spec.getXAxis() : null;
                BAxis bAxis = yaxis = useY ? spec.getYAxis() : null;
                if (xaxis != null && !this.alreadyAdded(xaxis)) {
                    if (bottomAxes.getAxisCount() == 0) {
                        bottomAxes.addAxis(xaxis);
                    } else if (topAxes.getAxisCount() == 0) {
                        topAxes.addAxis(xaxis);
                    } else {
                        bottomAxes.addAxis(xaxis);
                    }
                }
                if (yaxis == null || this.alreadyAdded(yaxis)) continue;
                if (leftAxes.getAxisCount() == 0) {
                    leftAxes.addAxis(yaxis);
                    continue;
                }
                rightAxes.addAxis(yaxis);
            }
        }
        this.getCanvas().build();
    }

    private boolean alreadyAdded(BAxis axis) {
        return ((BAxisContainer)this.getLeftAxes()).contains(axis) || ((BAxisContainer)this.getBottomAxes()).contains(axis) || ((BAxisContainer)this.getRightAxes()).contains(axis) || ((BAxisContainer)this.getTopAxes()).contains(axis);
    }

    public BAxis findAxis(BAxis axis) {
        SlotCursor charts = this.getProperties();
        while (charts.next(BChart.class)) {
            BAxis found = ((BChart)charts.get()).getModel().findAxis(axis);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public synchronized void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        double pch = 0.0;
        double pcw = 0.0;
        if (this.panControl != null && this.zoomed) {
            this.panPane.computePreferredSize();
            pch = this.panPane.getPreferredHeight();
            pcw = this.panPane.getPreferredWidth();
        }
        BChartHeader header = this.getHeader();
        header.computePreferredSize();
        BAxisContainer leftAxes = (BAxisContainer)this.getLeftAxes();
        BAxisContainer rightAxes = (BAxisContainer)this.getRightAxes();
        BAxisContainer topAxes = (BAxisContainer)this.getTopAxes();
        BAxisContainer bottomAxes = (BAxisContainer)this.getBottomAxes();
        leftAxes.computePreferredSize();
        rightAxes.computePreferredSize();
        topAxes.computePreferredSize();
        bottomAxes.computePreferredSize();
        BChartLegend legend = this.getLegend();
        double lw = Math.max(5.0, leftAxes.getPreferredWidth());
        double rw = Math.max(5.0, rightAxes.getPreferredWidth());
        double legendHeight = legend.getPreferredHeight(w - (lw + rw) - 16.0);
        double bh = bottomAxes.getPreferredHeight() + legendHeight;
        if (legendHeight > 0.0) {
            bh += 8.0;
        }
        if (bottomAxes.getPreferredHeight() == 0.0) {
            bh += 8.0;
        }
        double th = pch + header.getPreferredHeight() + topAxes.getPreferredHeight();
        leftAxes.setBounds(0.0, 0.0, lw, h);
        leftAxes.setRange(th, h - (th + bh));
        leftAxes.doLayout(leftAxes.getChildWidgets());
        rightAxes.setBounds(w - rw, 0.0, rw, h);
        rightAxes.setRange(th, h - (th + bh));
        rightAxes.doLayout(rightAxes.getChildWidgets());
        topAxes.setBounds(0.0, header.getPreferredHeight(), w, topAxes.getPreferredHeight());
        topAxes.setRange(lw, w - (lw + rw));
        topAxes.doLayout(topAxes.getChildWidgets());
        bottomAxes.setBounds(0.0, h - bh, w, bottomAxes.getPreferredHeight());
        bottomAxes.setRange(lw, w - (lw + rw));
        bottomAxes.doLayout(bottomAxes.getChildWidgets());
        legend.setBounds(lw + 8.0, h - legendHeight - 8.0, w - (lw + rw) - 16.0, legendHeight);
        if (this.panControl != null) {
            this.panPane.setBounds(0.0, 0.0, w, pch);
            this.panPane.doLayout(this.panPane.getChildWidgets());
        }
        header.setBounds(lw + 8.0, 0.0 + pch, w - (rw + lw) - 16.0, header.getPreferredHeight());
        this.getCanvas().setBounds(lw, th, w - (rw + lw), h - (th + bh));
        SlotCursor c = this.getProperties();
        while (c.next(BChart.class)) {
            BChart chart = (BChart)c.get();
            chart.setBounds(lw, th, w - (rw + lw), h - (th + bh));
        }
    }

    public synchronized void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(this.getBackground());
        g.fillRect(0.0, 0.0, w, h);
        BChartCanvas canvas = this.getCanvas();
        if (canvas.getWidth() <= 0.0 || canvas.getHeight() <= 0.0) {
            g.setBrush(BColor.black);
            g.setFont(font);
            String err = Lexicon.make((String)"chart").getText("insufficientArea");
            g.drawString(err, (this.getWidth() - font.width(err)) / 2.0, (this.getHeight() - font.getHeight()) / 2.0);
        }
        if (this.panControl != null) {
            this.paintChild(g, (BWidget)this.panPane);
        }
        this.paintChild(g, this.getHeader());
        this.paintChild(g, this.getLeftAxes());
        this.paintChild(g, this.getBottomAxes());
        this.paintChild(g, this.getRightAxes());
        this.paintChild(g, this.getTopAxes());
        this.paintChild(g, this.getCanvas());
        this.paintChild(g, this.getLegend());
        this.getBorder().paint(g, 1.0, 1.0, this.getWidth() - 2.0, this.getHeight() - 2.0);
    }

    private void assignColors(ChartSpec spec) {
        Series[] seriesList = this.getAllSeries();
        for (int s = 0; s < seriesList.length; ++s) {
            Series series = seriesList[s];
            BBrush brush = series.getBrush();
            BColor color = null;
            if (brush != null && !brush.isNull()) {
                return;
            }
            boolean dup = false;
            for (int c = 0; c < DEFAULT_COLORS.length; ++c) {
                color = DEFAULT_COLORS[c];
                dup = false;
                for (int i = 0; i < seriesList.length; ++i) {
                    BBrush.Paint p;
                    BBrush b = seriesList[i].getBrush();
                    if (b == null || !((p = b.getPaint()) instanceof BBrush.Solid) || !((BBrush.Solid)p).getColor().equals((Object)color)) continue;
                    dup = true;
                    break;
                }
                if (!dup) break;
            }
            if (dup) {
                color = BColor.black;
            }
            series.setBrush(color.toBrush());
        }
    }

    public BITable<?> export() {
        BChart[] charts = this.getCharts();
        return charts.length == 0 ? null : charts[0].getModel().export();
    }

    public void mousePressed(BMouseEvent evt) {
        this.controller.mousePressed(evt);
    }

    public void mouseReleased(BMouseEvent evt) {
        this.controller.mouseReleased(evt);
    }

    public void mouseEntered(BMouseEvent evt) {
        this.controller.mouseEntered(evt);
    }

    public void mouseExited(BMouseEvent evt) {
        this.controller.mouseExited(evt);
    }

    public void mouseMoved(BMouseEvent evt) {
        this.controller.mouseMoved(evt);
    }

    public void mouseDragged(BMouseEvent evt) {
        this.controller.mouseDragged(evt);
    }

    public void mouseWheel(BMouseEvent evt) {
        this.controller.mouseWheel(evt);
    }

    public void mousePulsed(BMouseEvent evt) {
        this.controller.mousePulsed(evt);
    }

    public void mouseHover(BMouseEvent evt) {
        this.controller.mouseHover(evt);
    }

    public void added(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.getType().is(BChart.TYPE)) {
            this.build();
            this.doLayout(null);
        }
    }

    public void prepare() {
        BChart[] charts = this.getCharts();
        for (int c = 0; c < charts.length; ++c) {
            ChartModel model = charts[c].getModel();
            if (!(model instanceof BoundChartModel)) continue;
            ((BoundChartModel)model).doSyncBindings();
        }
    }

    private class Restore {
        BAxis axis;
        Object min;
        Object max;

        public Restore(BAxis axis, Object min, Object max) {
            this.axis = axis;
            this.min = min;
            this.max = max;
        }
    }

    private class ZoomSpec {
        BAxisDimension dim;
        ArrayList<Restore> list = new ArrayList();

        public ZoomSpec(BAxisDimension dim) {
            this.dim = dim;
        }

        public boolean isEmpty() {
            return this.list.size() == 0;
        }

        public void add(BAxis axis, Object min, Object max) {
            this.list.add(new Restore(axis, min, max));
        }
    }
}

