/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.chart.BPanControl;
import com.tridium.gx.GxEnv;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtGraphics;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartPane;
import javax.baja.chart.BDiscreteLineChart;
import javax.baja.chart.ChartController;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.units.BUnit;

public class BChartCanvas
extends BWidget {
    public static final Property fill = BChartCanvas.newProperty((int)0, (BValue)BColor.make((String)"#fff").toBrush(), null);
    public static final Property borderStroke = BChartCanvas.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property borderPen = BChartCanvas.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    public static final Property showHorizontalGridLines = BChartCanvas.newProperty((int)0, (boolean)false, null);
    public static final Property showVerticalGridLines = BChartCanvas.newProperty((int)0, (boolean)false, null);
    public static final Property gridStroke = BChartCanvas.newProperty((int)0, (BValue)BColor.make((String)"#d9deef").toBrush(), null);
    public static final Property gridPen = BChartCanvas.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    public static final Action showPanControl = BChartCanvas.newAction((int)0, null);
    public static final Action hidePanControl = BChartCanvas.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BChartCanvas.class);
    private BBrush selBrush = BBrush.makeInverse((BColor)BColor.black);
    private RectGeom selection;
    private BPanControl panControl;
    private boolean zoomed = false;
    private BAxis hGridAxis;
    private BAxis vGridAxis;
    private BImage chartBuffer;
    boolean repaintChart = true;

    public BBrush getFill() {
        return (BBrush)this.get(fill);
    }

    public void setFill(BBrush v) {
        this.set(fill, (BValue)v, null);
    }

    public BBrush getBorderStroke() {
        return (BBrush)this.get(borderStroke);
    }

    public void setBorderStroke(BBrush v) {
        this.set(borderStroke, (BValue)v, null);
    }

    public BPen getBorderPen() {
        return (BPen)this.get(borderPen);
    }

    public void setBorderPen(BPen v) {
        this.set(borderPen, (BValue)v, null);
    }

    public boolean getShowHorizontalGridLines() {
        return this.getBoolean(showHorizontalGridLines);
    }

    public void setShowHorizontalGridLines(boolean v) {
        this.setBoolean(showHorizontalGridLines, v, null);
    }

    public boolean getShowVerticalGridLines() {
        return this.getBoolean(showVerticalGridLines);
    }

    public void setShowVerticalGridLines(boolean v) {
        this.setBoolean(showVerticalGridLines, v, null);
    }

    public BBrush getGridStroke() {
        return (BBrush)this.get(gridStroke);
    }

    public void setGridStroke(BBrush v) {
        this.set(gridStroke, (BValue)v, null);
    }

    public BPen getGridPen() {
        return (BPen)this.get(gridPen);
    }

    public void setGridPen(BPen v) {
        this.set(gridPen, (BValue)v, null);
    }

    public void showPanControl() {
        this.invoke(showPanControl, null, null);
    }

    public void hidePanControl() {
        this.invoke(hidePanControl, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (UiEnv.get().hasMouse()) {
            this.linkTo((BComponent)this.getPane(), (Slot)BChartPane.showPanRequested, (Slot)showPanControl);
            this.linkTo((BComponent)this.getPane(), (Slot)BChartPane.hidePanRequested, (Slot)hidePanControl);
        }
    }

    public BChartPane getPane() {
        BComplex p = this.getParent();
        if (p instanceof BChartPane) {
            return (BChartPane)p;
        }
        return null;
    }

    void build() {
        this.repaintChart = true;
        this.updateGridAxes();
    }

    public void updateGridAxes() {
        BChartPane pane = this.getPane();
        if (pane == null) {
            return;
        }
        boolean doHGrid = this.getShowHorizontalGridLines();
        boolean doVGrid = this.getShowVerticalGridLines();
        boolean hDone = !doHGrid;
        boolean vDone = !doVGrid;
        this.hGridAxis = null;
        this.vGridAxis = null;
        if (doHGrid || doVGrid) {
            BChart[] charts = this.getPane().getCharts();
            for (int i = 0; i < charts.length; ++i) {
                ChartModel model = charts[i].getModel();
                int specCount = model.getSpecCount();
                for (int j = 0; j < specCount; ++j) {
                    ChartSpec spec = model.getSpec(j);
                    BAxis axis0 = spec.getXAxis();
                    BAxis axis1 = spec.getYAxis();
                    if (doHGrid && this.hGridAxis == null) {
                        if (axis0 != null && axis0.getDimension() == BAxisDimension.y) {
                            this.hGridAxis = axis0;
                            hDone = true;
                        } else if (axis1 != null && axis1.getDimension() == BAxisDimension.y) {
                            this.hGridAxis = axis1;
                            hDone = true;
                        }
                    }
                    if (doVGrid && this.vGridAxis == null) {
                        if (axis0 != null && axis0.getDimension() == BAxisDimension.x) {
                            this.vGridAxis = axis0;
                            vDone = true;
                        } else if (axis1 != null && axis1.getDimension() == BAxisDimension.x) {
                            this.vGridAxis = axis1;
                            vDone = true;
                        }
                    }
                    if (!hDone || !vDone) continue;
                    return;
                }
            }
        }
    }

    public void doLayout(BWidget[] kids) {
        this.repaintChart = true;
        double w = this.getWidth();
        double h = this.getHeight();
        if (GxEnv.get() instanceof AwtEnv) {
            if (this.chartBuffer == null) {
                this.chartBuffer = BImage.make((double)Math.max(w, 1.0), (double)Math.max(h, 1.0));
            } else if (this.chartBuffer.getWidth() != w || this.chartBuffer.getHeight() != h) {
                this.chartBuffer.dispose();
                this.chartBuffer = BImage.make((double)Math.max(w, 1.0), (double)Math.max(h, 1.0));
            }
        }
        if (this.zoomed) {
            this.panControl.computePreferredSize();
            this.panControl.setBounds(w - this.panControl.getPreferredWidth() - 5.0, 5.0, this.panControl.getPreferredWidth(), this.panControl.getPreferredHeight());
        } else if (this.panControl != null) {
            this.panControl.setBounds(0.0, 0.0, 0.0, 0.0);
        }
        int count = 0;
        SlotCursor charts = this.getParent().getProperties();
        while (charts.next(BDiscreteLineChart.class)) {
            count += ((BChart)charts.get()).getModel().getSpecCount();
        }
        if (count != 0) {
            int index = 0;
            charts = this.getParent().getProperties();
            while (charts.next(BDiscreteLineChart.class)) {
                BDiscreteLineChart chart = (BDiscreteLineChart)charts.get();
                int specs = chart.getModel().getSpecCount();
                chart.setStartIndex(index, count);
                index += specs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Object c;
        boolean noBuffer = !(g instanceof AwtGraphics);
        double w = this.getWidth();
        double h = this.getHeight();
        Graphics cg = null;
        if (cg == g || this.repaintChart) {
            if (cg == null) {
                if (noBuffer) {
                    cg = g;
                } else {
                    this.resetBuffer();
                    cg = this.chartBuffer.getGraphics();
                    cg.useAntiAliasing(true);
                }
            }
            try {
                int t;
                Object[] ticks;
                cg.setBrush(this.getFill());
                cg.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
                if (this.hGridAxis != null) {
                    cg.setBrush(this.getGridStroke());
                    cg.setPen(this.getGridPen());
                    ticks = this.hGridAxis.getTickValues();
                    if (ticks != null) {
                        for (t = 0; t < ticks.length; ++t) {
                            double y = this.hGridAxis.toDisplaySpace(ticks[t]);
                            cg.strokeLine(0.0, y, w, y);
                        }
                    }
                }
                if (this.vGridAxis != null) {
                    cg.setBrush(this.getGridStroke());
                    cg.setPen(this.getGridPen());
                    ticks = this.vGridAxis.getTickValues();
                    if (ticks != null) {
                        for (t = 0; t < ticks.length; ++t) {
                            double x = this.vGridAxis.toDisplaySpace(ticks[t]);
                            cg.strokeLine(x, 0.0, x, h);
                        }
                    }
                }
                c = this.getPane().getProperties();
                while (c.next(BChart.class)) {
                    ((BWidget)c.get()).paint(cg);
                }
            }
            finally {
                this.repaintChart = false;
                if (cg != g) {
                    cg.dispose();
                }
            }
        }
        if (cg != g) {
            g.drawImage(this.chartBuffer, 0.0, 0.0);
        }
        if (this.selection != null) {
            g.setBrush(this.selBrush);
            g.fill((IGeom)this.selection);
        }
        g.setBrush(this.getBorderStroke());
        g.setPen(this.getBorderPen());
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        this.paintChildren(g);
        c = this.getPane().getController();
        if (((ChartController)c).getTraceX() != -1.0) {
            this.paintPointDetail(g);
        }
    }

    private void resetBuffer() {
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.chartBuffer != null) {
            this.chartBuffer.dispose();
            this.chartBuffer = null;
        }
        this.chartBuffer = BImage.make((double)Math.max(w, 1.0), (double)Math.max(h, 1.0));
    }

    private void paintPointDetail(Graphics g) {
        ChartController c = this.getPane().getController();
        double mx = c.getTraceX();
        double my = c.getTraceY();
        BFont font = Theme.widget().getTextFont();
        ArrayList<String> lines = new ArrayList<String>();
        double w = this.getWidth();
        double dw = 0.0;
        BChart[] charts = this.getPane().getCharts();
        for (int i = 0; i < charts.length; ++i) {
            ChartModel model = charts[i].getModel();
            for (int j = 0; j < model.getSpecCount(); ++j) {
                ChartSpec spec = model.getSpec(j);
                BAxis xaxis = spec.getXAxis();
                BAxis yaxis = spec.getYAxis();
                if (xaxis == null || yaxis == null) continue;
                Object a = xaxis.fromDisplaySpace(mx);
                Object b = yaxis.fromDisplaySpace(my);
                StringBuffer sb = new StringBuffer(xaxis.valueToString(a));
                sb.append(", ");
                BUnit unit = (BUnit)yaxis.getFacets().getFacet("units");
                if (unit != null && unit.getIsPrefix()) {
                    sb.append(yaxis.getUnitLabel() + yaxis.valueToString(b));
                } else {
                    sb.append(yaxis.valueToString(b) + " " + yaxis.getUnitLabel());
                }
                String s = sb.toString();
                if (lines.contains(s)) continue;
                dw = Math.max(dw, font.width(s));
                lines.add(s);
            }
        }
        if (lines.size() == 0) {
            return;
        }
        dw += 10.0;
        double dh = (double)lines.size() * font.getHeight() + 10.0;
        double dx = mx;
        double dy = my - dh - 5.0;
        if (dy < 0.0) {
            dy = my + 24.0;
        }
        if (dx + dw > w) {
            dx = mx - dw;
        }
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(dx, dy, dw, dh);
        g.setBrush(BColor.black);
        g.strokeRect(dx, dy, dw, dh);
        g.setFont(font);
        for (int i = 0; i < lines.size(); ++i) {
            String s = (String)lines.get(i);
            double bx = dx + 5.0;
            double by = dy + (double)i * font.getHeight() + 5.0;
            by += (font.getHeight() - 10.0) / 2.0;
            double tx = dx + 5.0;
            double ty = dy + (double)i * font.getHeight() + 5.0 + font.getAscent();
            g.setBrush(BColor.black);
            g.drawString(s, tx, ty);
        }
    }

    public void select(double x, double y, double w, double h) {
        if (this.selection == null) {
            this.selection = new RectGeom(x, y, w, h);
        } else {
            this.selection.set(x, y, w, h);
        }
        this.repaint();
    }

    public void selectHorizontal(double x1, double x2) {
        if (x1 < x2) {
            this.select(x1, 0.0, x2 - x1, this.getHeight());
        } else {
            this.select(x2, 0.0, x1 - x2, this.getHeight());
        }
    }

    public void selectVertical(double y1, double y2) {
        if (y1 < y2) {
            this.select(0.0, y1, this.getWidth(), y2 - y1);
        } else {
            this.select(0.0, y2, this.getWidth(), y1 - y2);
        }
    }

    public void clearSelection() {
        this.selection = null;
        this.repaint();
    }

    public void setZoomed(boolean zoomed) {
        if (this.panControl == null) {
            this.panControl = new BPanControl(this.getPane());
            this.add("panner", (BValue)this.panControl);
        }
        this.panControl.updateActionStates();
        if (this.zoomed == zoomed) {
            return;
        }
        this.repaintChart = true;
        this.zoomed = zoomed;
        this.relayout();
        this.repaint();
    }

    public boolean isZoomed() {
        return this.zoomed;
    }

    public void doShowPanControl() {
        this.setZoomed(true);
    }

    public void doHidePanControl() {
        this.setZoomed(false);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mousePressed(BMouseEvent evt) {
        this.requestFocus();
        this.getPane().getController().mousePressed(evt);
    }

    public void mouseReleased(BMouseEvent evt) {
        this.getPane().getController().mouseReleased(evt);
    }

    public void mouseEntered(BMouseEvent evt) {
        this.getPane().getController().mouseEntered(evt);
    }

    public void mouseExited(BMouseEvent evt) {
        this.getPane().getController().mouseExited(evt);
    }

    public void mouseMoved(BMouseEvent evt) {
        this.getPane().getController().mouseMoved(evt);
    }

    public void mouseDragged(BMouseEvent evt) {
        this.getPane().getController().mouseDragged(evt);
    }

    public void mouseWheel(BMouseEvent evt) {
        this.getPane().getController().mouseWheel(evt);
    }

    public void mousePulsed(BMouseEvent evt) {
        this.getPane().getController().mousePulsed(evt);
    }

    public void mouseHover(BMouseEvent evt) {
        this.getPane().getController().mouseHover(evt);
    }

    public void keyPressed(BKeyEvent e) {
        this.getPane().getController().keyPressed(e);
    }

    public void keyReleased(BKeyEvent e) {
        this.getPane().getController().keyReleased(e);
    }

    public void keyTyped(BKeyEvent e) {
        this.getPane().getController().keyTyped(e);
    }
}

