/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.agent.AgentList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChartPane;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartModelEvent;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public abstract class BChart
extends BWidget {
    public static final Type TYPE = Sys.loadType(BChart.class);
    private boolean syncRequired = false;
    private int syncCountDown = 0;
    private static Lexicon lex = Lexicon.make((String)"chart");
    private static final BFont errFont = BFont.make((String)lex.getText("chart.err.font"));
    private ChartModel model;

    public Type getType() {
        return TYPE;
    }

    public BChart() {
        this.setModel(new BoundChartModel());
    }

    public BChart(ChartModel model) {
        this.setModel(model);
    }

    public BChartPane getPane() {
        try {
            return (BChartPane)this.getParent();
        }
        catch (Exception e) {
            throw new IllegalStateException("ChartPane parent required.");
        }
    }

    public void setModel(ChartModel model) {
        this.installSupport(this.model, model);
        this.model = model;
        this.rebuild();
        this.relayout();
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void modelModified(ChartModelEvent evt) {
        BChartPane pane = this.getPane();
        if (pane == null) {
            return;
        }
        int id = evt.getId();
        if (id == 3) {
            pane.refresh();
        } else {
            this.rebuild();
        }
    }

    public boolean usesXAxis() {
        return true;
    }

    public boolean usesYAxis() {
        return true;
    }

    public void bindingsChanged() {
    }

    public void added(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.getType().is(BBinding.TYPE) && this.model instanceof BoundChartModel) {
            ((BoundChartModel)this.model).syncBindings();
        }
    }

    public void removed(Property p, BValue oldValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (oldValue instanceof BBinding && this.model instanceof BoundChartModel) {
            ((BoundChartModel)this.model).syncBindings();
        }
    }

    public void syncBindings() {
        this.syncRequired = true;
        this.syncCountDown = 1;
    }

    public void animate() {
        if (this.syncRequired) {
            if (this.syncCountDown == 0) {
                this.syncRequired = false;
                if (this.model instanceof BoundChartModel) {
                    ((BoundChartModel)this.model).doSyncBindings();
                    this.relayout();
                }
            } else {
                --this.syncCountDown;
            }
        }
    }

    private void installSupport(ChartSupport oldSupport, ChartSupport newSupport) {
        if (newSupport == null) {
            throw new NullPointerException();
        }
        if (oldSupport == newSupport) {
            return;
        }
        if (newSupport.chart != null) {
            throw new IllegalArgumentException("Already installed on another chart.");
        }
        if (oldSupport != null) {
            oldSupport.setChart(null);
        }
        newSupport.setChart(this);
    }

    public void computePreferredSize() {
        this.setPreferredSize(300.0, 300.0);
    }

    public void rebuild() {
        BChartPane pane = this.getPane();
        if (pane != null) {
            pane.rebuild();
        }
    }

    public final void paint(Graphics g) {
        BWidget parent = (BWidget)this.getParent();
        if (parent == null || !(parent instanceof BChartPane)) {
            g.setFont(errFont);
            g.setBrush(BColor.black.toBrush());
            g.drawString(((Object)((Object)this)).getClass().getName() + ": ChartPane required.", 5.0, errFont.getHeight());
        } else {
            this.doPaint(g);
        }
    }

    public void doPaint(Graphics g) {
    }

    public void updateAxes() {
        int specCount = this.model.getSpecCount();
        for (int i = 0; i < specCount; ++i) {
            Object maxValue;
            Object minValue;
            BAxis yaxis;
            ChartSpec spec = this.model.getSpec(i);
            Series series = spec.getSeries();
            BAxis xaxis = this.usesXAxis() ? spec.getXAxis() : null;
            BAxis bAxis = yaxis = this.usesYAxis() ? spec.getYAxis() : null;
            if (xaxis == null && yaxis == null) continue;
            if (xaxis != null) {
                xaxis.updateFacets(series.getColumnFacets(0));
                if (xaxis.isMinAuto() && (minValue = series.getMin(0)) != null) {
                    xaxis.updateAutoMin(minValue);
                }
                if (xaxis.isMaxAuto() && (maxValue = series.getMax(0)) != null) {
                    xaxis.updateAutoMax(maxValue);
                }
            }
            if (yaxis == null) continue;
            yaxis.updateSeries(series);
            yaxis.updateFacets(series.getColumnFacets(1));
            if (yaxis.isMinAuto() && (minValue = series.getMin(1)) != null) {
                yaxis.updateAutoMin(minValue);
            }
            if (!yaxis.isMaxAuto() || (maxValue = series.getMax(1)) == null) continue;
            yaxis.updateAutoMax(maxValue);
        }
    }

    public JoinTable join(int keyColumn) {
        Series[] seriesList = this.model.getAllSeries();
        return JoinTable.make(seriesList, keyColumn);
    }

    public boolean receiveInputEvents() {
        return false;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("chart:ValueChartBinding");
        return agents;
    }

    public static abstract class ChartSupport {
        public BChart chart;

        public final BChart getChart() {
            return this.chart;
        }

        public final void setChart(BChart chart) {
            this.chart = chart;
        }

        public ChartModel getModel() {
            return this.chart.model;
        }
    }
}

