/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.chart.AxisRenderer;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.DefaultAxisRenderer;
import javax.baja.chart.Series;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public abstract class BAxis
extends BObject
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BAxis.class);
    public static final Logger log = Logger.getLogger("chart.axis");
    public static final double DEFAULT_MARGIN_SIZE = 5.0;
    private static AxisRenderer defRenderer = new DefaultAxisRenderer();
    private AxisRenderer renderer;
    private BAxisDimension dim;
    private BAxisLocation loc;
    private String title;
    private double prefWidth;
    private double prefHeight;
    private double x;
    private double y;
    private double w;
    private double h;
    private boolean showSwatches = true;
    private boolean minAuto = true;
    private boolean maxAuto = true;
    private double minMargin = 5.0;
    private double maxMargin = 5.0;
    private BFacets facets = BFacets.NULL;
    private String unitText;
    private ArrayList<String> units = new ArrayList();
    private ArrayList<Series> series = new ArrayList();

    public abstract Type getValueType();

    public BAxisDimension getDimension() {
        return this.dim;
    }

    public void setDimension(BAxisDimension dim) {
        this.dim = dim;
    }

    public BAxisLocation getLocation() {
        return this.loc;
    }

    public void setLocation(BAxisLocation loc) {
        this.loc = loc;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private void addUnit(String unit) {
        if (this.units.contains(unit)) {
            return;
        }
        this.units.add(unit);
        this.unitText = null;
    }

    private void clearUnits() {
        this.units.clear();
        this.unitText = null;
    }

    public String getUnitLabel() {
        if (this.unitText == null) {
            int count = this.units.size();
            if (count == 0) {
                this.unitText = "";
            } else if (count == 1) {
                this.unitText = this.units.get(0);
            } else {
                StringBuffer s = new StringBuffer(12);
                for (int i = 0; i < count; ++i) {
                    if (i != 0) {
                        s.append(",");
                    }
                    s.append(this.units.get(i));
                }
                this.unitText = s.toString();
            }
        }
        return this.unitText;
    }

    public void setShowSwatches(boolean showSwatches) {
        this.showSwatches = showSwatches;
    }

    public boolean getShowSwatches() {
        return this.showSwatches;
    }

    public void computePreferredSize() {
        if (this.dim == BAxisDimension.x) {
            this.setPreferredSize(100.0, this.getRenderer().getPreferredAxisWidth(this));
        } else if (this.dim == BAxisDimension.y) {
            this.setPreferredSize(this.getRenderer().getPreferredAxisWidth(this), 100.0);
        }
    }

    protected void setPreferredSize(double prefWidth, double prefHeight) {
        this.prefWidth = prefWidth;
        this.prefHeight = prefHeight;
    }

    public double getPreferredWidth() {
        return this.prefWidth;
    }

    public double getPreferredHeight() {
        return this.prefHeight;
    }

    public void setBounds(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void doLayout() {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public double getLength() {
        if (this.dim == BAxisDimension.x) {
            return this.w - this.getMinMargin() - this.getMaxMargin();
        }
        if (this.dim == BAxisDimension.y) {
            return this.h - this.getMinMargin() - this.getMaxMargin();
        }
        return 0.0;
    }

    public double getFullLength() {
        if (this.dim == BAxisDimension.x) {
            return this.w;
        }
        if (this.dim == BAxisDimension.y) {
            return this.h;
        }
        return 0.0;
    }

    public void setMinAuto(boolean auto) {
        this.minAuto = auto;
    }

    public boolean isMinAuto() {
        return this.minAuto;
    }

    public void updateAutoMin(Object newMin) {
    }

    public abstract Object getAxisMin();

    public abstract void setAxisMin(Object var1);

    public double getMinMargin() {
        return this.minMargin;
    }

    public void setMinMargin(double margin) {
        this.minMargin = margin;
    }

    public void setMaxAuto(boolean auto) {
        this.maxAuto = auto;
    }

    public boolean isMaxAuto() {
        return this.maxAuto;
    }

    public void updateAutoMax(Object newMax) {
    }

    public abstract Object getAxisMax();

    public abstract void setAxisMax(Object var1);

    public double getMaxMargin() {
        return this.maxMargin;
    }

    public void setMaxMargin(double margin) {
        this.maxMargin = margin;
    }

    public void reset() {
    }

    public BFacets updateFacets(BFacets newFacets) {
        if (newFacets == null) {
            return this.facets;
        }
        this.facets = BFacets.make((BFacets)this.facets, (BFacets)newFacets);
        BUnit unit = (BUnit)newFacets.getFacet("units");
        if (unit != null && !unit.isNull()) {
            this.addUnit(unit.getSymbol());
        }
        return this.facets;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public void updateSeries(Series s) {
        if (!this.series.contains(s)) {
            this.series.add(s);
        }
    }

    public Series[] getSeries() {
        return this.series.toArray(new Series[this.series.size()]);
    }

    public boolean isZoomEnabled() {
        return true;
    }

    public boolean validateZoom(Object zoomMin, Object zoomMax) {
        return this.isZoomEnabled();
    }

    public abstract Object[] getTickValues();

    public abstract String valueToString(Object var1);

    public abstract double toDisplaySpace(Object var1);

    public abstract Object fromDisplaySpace(double var1);

    public static AxisRenderer getDefaultRenderer() {
        return defRenderer;
    }

    public static void setDefaultRenderer(AxisRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException();
        }
        defRenderer = renderer;
    }

    public void setRenderer(AxisRenderer renderer) {
        this.renderer = renderer;
    }

    public AxisRenderer getRenderer() {
        if (this.renderer == null) {
            return defRenderer;
        }
        return this.renderer;
    }

    public boolean isCompatible(BAxis axis) {
        if (!((Object)((Object)axis)).getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        if (axis.dim != this.dim) {
            return false;
        }
        if (!axis.getRenderer().equals(this.getRenderer())) {
            return false;
        }
        BObject srcPrecision = this.facets.get("precision");
        BObject axisPrecision = axis.facets.get("precision");
        if (srcPrecision == null && axisPrecision != null) {
            return false;
        }
        if (axisPrecision == null && srcPrecision != null) {
            return false;
        }
        if (axisPrecision != null && srcPrecision != null && !axisPrecision.equals((Object)srcPrecision)) {
            return false;
        }
        String axisTitle = axis.getTitle();
        String title = this.getTitle();
        if (axisTitle == null && title != null) {
            return false;
        }
        if (title == null && axisTitle != null) {
            return false;
        }
        if (axisTitle != null && title != null && !axisTitle.equals(title)) {
            return false;
        }
        String axisUnit = axis.getUnitLabel();
        String unit = this.getUnitLabel();
        if (axisUnit == null && unit != null) {
            return false;
        }
        if (unit == null && axisUnit != null) {
            return false;
        }
        if (axisUnit != null && unit != null && !axisUnit.equals(unit)) {
            return false;
        }
        Object min = this.getAxisMin();
        Object max = this.getAxisMax();
        Object axisMin = axis.getAxisMin();
        Object axisMax = axis.getAxisMax();
        if (min == null || axisMin == null || max == null || axisMax == null) {
            return false;
        }
        if (this.isMinAuto() && !axis.isMinAuto() || !this.isMinAuto() && axis.isMinAuto()) {
            return false;
        }
        if (!(this.isMinAuto() || axis.isMinAuto() || min.equals(axisMin))) {
            return false;
        }
        if (this.isMaxAuto() && !axis.isMaxAuto() || !this.isMaxAuto() && axis.isMaxAuto()) {
            return false;
        }
        return this.isMaxAuto() || axis.isMaxAuto() || max.equals(axisMax);
    }

    public boolean equals(Object o) {
        if (!o.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        BAxis axis = (BAxis)((Object)o);
        if (axis.dim != this.dim) {
            return false;
        }
        if (!axis.facets.equals((Object)this.facets)) {
            return false;
        }
        if (axis.isMinAuto() != this.isMinAuto()) {
            return false;
        }
        if (!this.isMinAuto() && !axis.getAxisMin().equals(this.getAxisMin())) {
            return false;
        }
        if (axis.isMaxAuto() != this.isMaxAuto()) {
            return false;
        }
        if (!this.isMaxAuto() && !axis.getAxisMax().equals(this.getAxisMax())) {
            return false;
        }
        if (!axis.getRenderer().equals(this.getRenderer())) {
            return false;
        }
        String axisTitle = axis.getTitle();
        String title = this.getTitle();
        if (axisTitle == null && title != null) {
            return false;
        }
        if (title == null && axisTitle != null) {
            return false;
        }
        if (axisTitle != null && title != null && !axisTitle.equals(title)) {
            return false;
        }
        String axisUnit = axis.getUnitLabel();
        String unit = this.getUnitLabel();
        if (axisUnit == null && unit != null) {
            return false;
        }
        if (unit == null && axisUnit != null) {
            return false;
        }
        return axisUnit == null || unit == null || axisUnit.equals(unit);
    }

    public Type getType() {
        return TYPE;
    }
}

