/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.BContinuousAxis;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BAbsTimeAxis
extends BContinuousAxis {
    public static final Type TYPE = Sys.loadType(BAbsTimeAxis.class);
    private static final BAbsTime ZERO = BAbsTime.make((long)0L);
    private BFacets timeFacets;
    private BFacets formatFacets;
    private BAbsTime min = ZERO;
    private BAbsTime max = this.min.add(BRelTime.makeHours((int)1));
    private boolean initMin = true;
    private boolean initMax = true;
    private BRelTime tickIncrement;
    private BAbsTime[] tickValues;
    private BTimeZone timeZone;

    public BAbsTimeAxis() {
    }

    public BAbsTimeAxis(BTimeZone timeZone) {
        this.setTimeZone(timeZone);
    }

    @Override
    public BFacets updateFacets(BFacets newFacets) {
        BFacets facets = super.updateFacets(newFacets);
        this.setTimeZone((BTimeZone)facets.get("TimeZone", (BObject)BTimeZone.getLocal()));
        return facets;
    }

    public BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(BTimeZone timeZone) {
        this.timeZone = timeZone;
        this.timeFacets = super.updateFacets(null);
    }

    @Override
    public Type getValueType() {
        return BAbsTime.TYPE;
    }

    @Override
    public Object getAxisMin() {
        return this.min;
    }

    @Override
    public void setAxisMin(Object newMin) {
        this.min = (BAbsTime)newMin;
    }

    @Override
    public void updateAutoMin(Object newMin) {
        if (this.initMin) {
            this.min = (BAbsTime)newMin;
            this.initMin = false;
        } else if (((BAbsTime)newMin).isBefore(this.min)) {
            this.min = (BAbsTime)newMin;
        }
    }

    @Override
    public Object getAxisMax() {
        return this.max;
    }

    @Override
    public void setAxisMax(Object newMax) {
        this.max = (BAbsTime)newMax;
    }

    @Override
    public void updateAutoMax(Object newMax) {
        if (this.initMax) {
            this.max = (BAbsTime)newMax;
            this.initMax = false;
        } else if (((BAbsTime)newMax).isAfter(this.max)) {
            this.max = (BAbsTime)newMax;
        }
    }

    @Override
    public void reset() {
        this.initMax = true;
        this.initMin = true;
        this.max = BAbsTime.now();
        this.min = this.max.subtract(BRelTime.makeHours((int)1));
    }

    @Override
    public double toPercentOfRange(Object value) {
        long valueMillis = ((BAbsTime)value).getMillis();
        long minMillis = this.min.getMillis();
        long maxMillis = this.max.getMillis();
        return (double)(valueMillis - minMillis) / (double)(maxMillis - minMillis);
    }

    @Override
    public Object fromPercentOfRange(double percent) {
        long minMillis = this.min.getMillis();
        long maxMillis = this.max.getMillis();
        long result = minMillis + (long)((double)(maxMillis - minMillis) * percent);
        return BAbsTime.make((long)result);
    }

    @Override
    public Object getZero() {
        return ZERO;
    }

    @Override
    public void doLayout() {
        long maxMillis = this.max.getMillis();
        long minMillis = this.min.getMillis();
        long delta = maxMillis - minMillis;
        long tickIncrMillis = this.computeTickIncrement(delta);
        int tickCount = (int)(delta / tickIncrMillis) + 1;
        while (tickCount > 30) {
            tickCount = (int)(delta / (tickIncrMillis *= 2L)) + 1;
        }
        if (this.timeFacets.getFacet("timeFormat") == null) {
            BFacets timeFormat = this.deltaToTimeFormat(delta);
            this.formatFacets = BFacets.make((BFacets)this.timeFacets, (BFacets)timeFormat);
        } else {
            this.formatFacets = this.timeFacets;
        }
        BRelTime tickIncrement = BRelTime.make((long)tickIncrMillis);
        if (tickCount < 0) {
            tickCount = 0;
        }
        this.tickValues = new BAbsTime[tickCount];
        BAbsTime tickVal = this.min;
        for (int i = 0; i < tickCount; ++i) {
            this.tickValues[i] = tickVal;
            tickVal = tickVal.add(tickIncrement);
        }
    }

    private long computeTickIncrement(long delta) {
        long tickIncrMillis = 1L;
        tickIncrMillis = delta <= 1000L ? 1L : (delta < 60000L ? 1000L : (delta < 300000L ? 15000L : (delta < 1800000L ? 60000L : (delta < 3600000L ? 300000L : (delta < 21600000L ? 900000L : (delta <= 108000000L ? 3600000L : (delta <= 3110400000L ? 86400000L : (delta < 94608000000L ? 2592000000L : 31536000000L))))))));
        return tickIncrMillis;
    }

    private BFacets deltaToTimeFormat(long delta) {
        if (delta < 10000L) {
            return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY h:mm:ss a z"), (String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
        }
        if (delta < 3600000L) {
            return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY h:mm:ss a z"), (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
        }
        if (delta > 2592000000L) {
            return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY z"));
        }
        return BFacets.make((String)"timeFormat", (BIDataValue)BString.make((String)"D-MMM-YY h:mm a z"));
    }

    @Override
    public Object[] getTickValues() {
        return this.tickValues;
    }

    @Override
    public String valueToString(Object value) {
        BAbsTime t = (BAbsTime)value;
        return t.toString((Context)this.timeFacets);
    }

    @Override
    public boolean validateZoom(Object zoomMin, Object zoomMax) {
        long zmin = ((BAbsTime)zoomMin).getMillis();
        long zmax = ((BAbsTime)zoomMax).getMillis();
        long delta = zmax - zmin;
        if (delta < 10L) {
            return false;
        }
        return super.validateZoom(zoomMin, zoomMax);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

