/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BColumnIdentifierFE
extends BWbFieldEditor {
    public static final Action updateLayout = BColumnIdentifierFE.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BColumnIdentifierFE.class);
    private static final int NULL = 0;
    private static final int ROW_INDEX = 1;
    private static final int TABLE_COLUMN = 2;
    private static final int GAP = 4;
    private static Lexicon lex = Lexicon.make((String)"chart");
    private BListDropDown typeSelect = new BListDropDown();
    private BTextField columnNameField;

    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BColumnIdentifierFE() {
        BList typeList = this.typeSelect.getList();
        typeList.addItem((Object)lex.getText("null"));
        typeList.addItem((Object)lex.getText("rowIndex"));
        typeList.addItem((Object)lex.getText("tableColumn"));
        this.add("typeSelect", (BValue)this.typeSelect);
        this.columnNameField = new BTextField("", 20);
        this.add("nameField", (BValue)this.columnNameField);
        this.add("typeLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)setModified));
        this.add("layoutLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)updateLayout));
        this.add("nameLink", (BValue)new BLink((BComponent)this.columnNameField, (Slot)BTextField.textModified, (Slot)setModified));
    }

    public void doLoadValue(BObject value, Context cx) {
        BColumnIdentifier id = (BColumnIdentifier)value;
        if (id.isNull()) {
            this.typeSelect.setSelectedIndex(0);
        } else if (id.isRowIndex()) {
            this.typeSelect.setSelectedIndex(1);
        } else if (id.isTableColumn()) {
            this.typeSelect.setSelectedIndex(2);
            this.columnNameField.setText(id.getColumnName());
        } else {
            this.typeSelect.setSelectedIndex(0);
            throw new IllegalArgumentException("Unsupported identifier type: " + id);
        }
    }

    public BObject doSaveValue(BObject value, Context cx) {
        int index = this.typeSelect.getSelectedIndex();
        if (index == 0) {
            return BColumnIdentifier.NULL;
        }
        if (index == 1) {
            return BColumnIdentifier.makeRowIndexColumn();
        }
        if (index == 2) {
            return BColumnIdentifier.makeTableColumn((String)this.columnNameField.getText().trim());
        }
        throw new IllegalStateException("Invalid type index: " + index);
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        this.typeSelect.computePreferredSize();
        this.columnNameField.computePreferredSize();
        pw = this.typeSelect.getPreferredWidth() + 4.0 + this.columnNameField.getPreferredWidth();
        ph = Math.max(this.typeSelect.getPreferredHeight(), this.columnNameField.getPreferredHeight());
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.typeSelect.computePreferredSize();
        this.typeSelect.setBounds(0.0, (h - this.typeSelect.getPreferredHeight()) / 2.0, this.typeSelect.getPreferredWidth(), this.typeSelect.getPreferredHeight());
        int index = this.typeSelect.getSelectedIndex();
        if (index == 2) {
            this.columnNameField.computePreferredSize();
            this.columnNameField.setBounds(this.typeSelect.getPreferredWidth() + 4.0, (h - this.columnNameField.getPreferredHeight()) / 2.0, this.columnNameField.getPreferredWidth(), this.columnNameField.getPreferredHeight());
        } else {
            this.columnNameField.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void doUpdateLayout() {
        this.relayout();
    }
}

