/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import javax.baja.chart.binding.BAxisBound;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAxisBoundFE
extends BWbFieldEditor {
    public static final Action updateLayout = BAxisBoundFE.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAxisBoundFE.class);
    private static final int AUTO = 0;
    private static final int FIXED = 1;
    private static final double GAP = 4.0;
    private static final Lexicon lex = Lexicon.make((String)"chart");
    private BTypeSpec valueType = BTypeSpec.NULL;
    private BListDropDown typeSelect = new BListDropDown();
    private BWbFieldEditor valueEditor;

    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAxisBoundFE() {
        BList typeList = this.typeSelect.getList();
        typeList.addItem((Object)lex.getText("auto"));
        typeList.addItem((Object)lex.getText("fixed"));
        this.add("typeSelect", (BValue)this.typeSelect);
        this.valueEditor = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
        this.add("valueEditor", (BValue)this.valueEditor);
        this.add("typeLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)setModified));
        this.add("layoutLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)updateLayout));
        this.add("valueLink", (BValue)new BLink((BComponent)this.valueEditor, (Slot)BWbFieldEditor.setModified, (Slot)setModified));
    }

    public void setValueType(BTypeSpec valueType) {
        boolean isNumeric = !valueType.isNull() && valueType.getResolvedType() == BINumeric.TYPE;
        this.valueType = valueType;
        if ((valueType.isNull() || valueType.getTypeInfo().isAbstract()) && !isNumeric) {
            this.loadValue((BObject)BAxisBound.makeAuto());
            this.typeSelect.setEnabled(false);
        } else {
            this.typeSelect.setEnabled(!this.isReadonly());
            if (valueType.getResolvedType() == BINumeric.TYPE) {
                BDouble proto = BDouble.DEFAULT;
                BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)proto);
                if (!ed.getType().equals(this.valueEditor.getType())) {
                    this.replaceEditor(ed);
                }
                ed.loadValue((BObject)proto);
            } else if (valueType.getResolvedType() == BAbsTime.TYPE) {
                BAbsTime proto = BAbsTime.now();
                BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)proto);
                if (!ed.getType().equals(this.valueEditor.getType())) {
                    this.replaceEditor(ed);
                }
                ed.loadValue((BObject)proto);
            } else {
                BSimple proto = (BSimple)valueType.getInstance();
                BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)proto);
                if (!ed.getType().equals(this.valueEditor.getType())) {
                    this.replaceEditor(ed);
                }
                ed.loadValue((BObject)proto);
            }
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        BAxisBound bound = (BAxisBound)value;
        if (bound.isAuto()) {
            this.typeSelect.setSelectedIndex(0);
        } else {
            this.typeSelect.setSelectedIndex(1);
            BSimple val = bound.getValue();
            BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)val);
            if (!ed.getType().equals(this.valueEditor.getType())) {
                this.replaceEditor(ed);
            }
            ed.loadValue((BObject)val);
        }
        this.relayout();
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        int type = this.typeSelect.getSelectedIndex();
        if (type == 0) {
            return BAxisBound.makeAuto();
        }
        BSimple fixed = (BSimple)this.valueEditor.saveValue(cx);
        return BAxisBound.make((BSimple)fixed);
    }

    public void doSetReadonly(boolean ro) {
        this.typeSelect.setEnabled(!ro);
        this.valueEditor.setReadonly(ro);
    }

    private void replaceEditor(BWbFieldEditor ed) {
        this.remove("valueLink");
        this.remove("valueEditor");
        this.valueEditor = ed;
        this.add("valueEditor", (BValue)this.valueEditor);
        this.add("valueLink", (BValue)new BLink((BComponent)this.valueEditor, (Slot)BWbFieldEditor.setModified, (Slot)setModified));
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        this.typeSelect.computePreferredSize();
        this.valueEditor.computePreferredSize();
        pw = this.typeSelect.getPreferredWidth() + 4.0 + this.valueEditor.getPreferredWidth();
        ph = Math.max(this.typeSelect.getPreferredHeight(), this.valueEditor.getPreferredHeight());
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.typeSelect.computePreferredSize();
        this.valueEditor.computePreferredSize();
        this.typeSelect.setBounds(0.0, (h - this.typeSelect.getPreferredHeight()) / 2.0, this.typeSelect.getPreferredWidth(), this.typeSelect.getPreferredHeight());
        int type = this.typeSelect.getSelectedIndex();
        if (type == 1) {
            this.valueEditor.setBounds(this.typeSelect.getPreferredWidth() + 4.0, (h - this.valueEditor.getPreferredHeight()) / 2.0, this.valueEditor.getPreferredWidth(), this.valueEditor.getPreferredHeight());
        } else {
            this.valueEditor.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void doUpdateLayout() {
        this.setValueType(this.valueType);
        this.relayout();
    }
}

