/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx.awt.se;

import com.tridium.pdf.gx.PdfStream;
import com.tridium.pdf.gx.awt.se.PdfGraphicsSE;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BajaRuntimeException;

public class PathSupportSE {
    public static void doPath(PdfGraphicsSE g, IPathGeom p) {
        try {
            PdfStream stream = g.getTarget().getContentStream();
            Point controlPoint = new Point();
            Point lastPoint = new Point();
            Point lastControlPoint = null;
            block14: for (int i = 0; i < p.size(); ++i) {
                IPathGeom.Segment seg = p.segment(i);
                switch (seg.getCommand()) {
                    case 'M': 
                    case 'm': {
                        IPathGeom.MoveTo m = (IPathGeom.MoveTo)seg;
                        double x = g.transX(m.getX());
                        double y = g.transY(m.getY());
                        stream.println(x + " " + y + " m");
                        lastPoint.set(x, y);
                        lastControlPoint = null;
                        continue block14;
                    }
                    case 'L': 
                    case 'l': {
                        IPathGeom.LineTo l = (IPathGeom.LineTo)seg;
                        double x = g.transX(l.getX());
                        double y = g.transY(l.getY());
                        stream.println(x + " " + y + " l");
                        lastPoint.set(x, y);
                        lastControlPoint = null;
                        continue block14;
                    }
                    case 'H': 
                    case 'h': {
                        continue block14;
                    }
                    case 'V': 
                    case 'v': {
                        continue block14;
                    }
                    case 'Q': 
                    case 'q': {
                        lastControlPoint = PathSupportSE.quadTo(g, (IPathGeom.QuadTo)seg, controlPoint, lastPoint);
                        continue block14;
                    }
                    case 'T': 
                    case 't': {
                        lastControlPoint = PathSupportSE.smoothQuadTo(g, (IPathGeom.SmoothQuadTo)seg, controlPoint, lastPoint, lastControlPoint);
                        continue block14;
                    }
                    case 'C': 
                    case 'c': {
                        lastControlPoint = PathSupportSE.curveTo(g, (IPathGeom.CurveTo)seg, controlPoint, lastPoint);
                        continue block14;
                    }
                    case 'S': 
                    case 's': {
                        lastControlPoint = PathSupportSE.smoothCurveTo(g, (IPathGeom.SmoothCurveTo)seg, controlPoint, lastPoint, lastControlPoint);
                        continue block14;
                    }
                    case 'A': 
                    case 'a': {
                        PathSupportSE.arcTo(g, (IPathGeom.ArcTo)seg, lastPoint);
                        lastControlPoint = null;
                        continue block14;
                    }
                    case 'Z': 
                    case 'z': {
                        lastControlPoint = null;
                        continue block14;
                    }
                    default: {
                        throw new IllegalStateException(seg.toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected static Point quadTo(PdfGraphicsSE g, IPathGeom.QuadTo s, Point controlPoint, Point lastPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = g.transX(s.getX1());
        double y1 = g.transY(s.getY1());
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
            x1 += lastPoint.x;
            y1 -= lastPoint.y;
        }
        PdfStream stream = g.getTarget().getContentStream();
        stream.println(x1 + " " + y1 + " " + x + " " + y + " v");
        lastPoint.set(x, y);
        controlPoint.set(x1, y1);
        return controlPoint;
    }

    protected static Point smoothQuadTo(PdfGraphicsSE g, IPathGeom.SmoothQuadTo s, Point controlPoint, Point lastPoint, Point lastControlPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = lastPoint.x;
        double y1 = lastPoint.y;
        if (lastControlPoint != null) {
            x1 += lastPoint.x - lastControlPoint.x;
            y1 -= lastPoint.y - lastControlPoint.y;
        }
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
        }
        PdfStream stream = g.getTarget().getContentStream();
        stream.println(x1 + " " + y1 + " " + x + " " + y + " v");
        lastPoint.set(x, y);
        controlPoint.set(x1, y1);
        return controlPoint;
    }

    protected static Point curveTo(PdfGraphicsSE g, IPathGeom.CurveTo s, Point controlPoint, Point lastPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = g.transX(s.getX1());
        double y1 = g.transY(s.getY1());
        double x2 = g.transX(s.getX2());
        double y2 = g.transY(s.getY2());
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
            x1 += lastPoint.x;
            y1 -= lastPoint.y;
            x2 += lastPoint.x;
            y2 -= lastPoint.y;
        }
        PdfStream stream = g.getTarget().getContentStream();
        stream.println(x1 + " " + y1 + " " + x2 + " " + y2 + " " + x + " " + y + " c");
        lastPoint.set(x, y);
        controlPoint.set(x2, y2);
        return controlPoint;
    }

    protected static Point smoothCurveTo(PdfGraphicsSE g, IPathGeom.SmoothCurveTo s, Point controlPoint, Point lastPoint, Point lastControlPoint) throws IOException {
        double x = g.transX(s.getX());
        double y = g.transY(s.getY());
        double x1 = lastPoint.x;
        double y1 = lastPoint.y;
        double x2 = g.transX(s.getX2());
        double y2 = g.transY(s.getY2());
        if (lastControlPoint != null) {
            x1 += lastPoint.x - lastControlPoint.x;
            y1 -= lastPoint.y - lastControlPoint.y;
        }
        if (s.isRelative()) {
            x += lastPoint.x;
            y -= lastPoint.y;
            x2 += lastPoint.x;
            y2 -= lastPoint.y;
        }
        PdfStream stream = g.getTarget().getContentStream();
        stream.println(x1 + " " + y1 + " " + x2 + " " + y2 + " " + x + " " + y + " c");
        lastPoint.set(x, y);
        controlPoint.set(x2, y2);
        return controlPoint;
    }

    protected static void arcTo(PdfGraphicsSE g, IPathGeom.ArcTo s, Point lastPoint) throws IOException {
        double rx = s.getRadiusX();
        double ry = s.getRadiusY();
        double axisRotation = s.getXAxisRotation();
        double x0 = lastPoint.x;
        double y0 = lastPoint.y;
        double x1 = g.transX(s.getX());
        double y1 = g.transY(s.getY());
        if (s.isRelative()) {
            x1 += x0;
            y1 += y0;
        }
        double a = rx;
        double b = ry;
        double c = Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
        double angle = Math.acos((a * a + b * b - c * c) / (2.0 * a * b));
        if (s.getLargeArcFlag() && s.getSweepFlag() && angle == 0.0) {
            angle = 360.0;
        }
        PdfStream stream = g.getTarget().getContentStream();
        Arc2D arc = PathSupportSE.computeArc(x0, y0, rx, ry, axisRotation, s.getLargeArcFlag(), s.getSweepFlag(), x1, y1);
        arc.setArcType(2);
        if (angle == 360.0) {
            arc.setArcByCenter(x0, y0 - ry, rx, 0.0, angle, 2);
            axisRotation = 90.0;
        }
        System.out.println("PathSupport.arcTo angle extent " + arc.getAngleExtent());
        System.out.println("PathSupport.arcTo angle start " + arc.getAngleStart());
        System.out.println("PathSupport.arcTo center x " + arc.getCenterX());
        System.out.println("PathSupport.arcTo center y " + arc.getCenterY());
        System.out.println("PathSupport.arcTo height " + arc.getHeight());
        System.out.println("PathSupport.arcTo width " + arc.getWidth());
        System.out.println("PathSupport.arcTo X " + arc.getX());
        System.out.println("PathSupport.arcTo Y " + arc.getY());
        AffineTransform t = AffineTransform.getRotateInstance(Math.toRadians(axisRotation), arc.getCenterX(), arc.getCenterY());
        PathIterator points = arc.getPathIterator(t);
        int traces = 0;
        float[] coords = new float[6];
        while (!points.isDone()) {
            ++traces;
            int segtype = points.currentSegment(coords);
            if (Float.isNaN(coords[0])) {
                points.next();
                continue;
            }
            switch (segtype) {
                case 4: {
                    stream.println("h");
                    break;
                }
                case 3: {
                    stream.println(coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " " + coords[4] + " " + coords[5] + " c");
                    break;
                }
                case 1: {
                    stream.println(coords[0] + " " + coords[1] + " l");
                    break;
                }
                case 0: {
                    stream.println(coords[0] + " " + coords[1] + " m");
                    break;
                }
                case 2: {
                    stream.println(coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " v");
                }
            }
            points.next();
        }
        lastPoint.set(x1, y1);
    }

    public static Arc2D computeArc(double x0, double y0, double rx, double ry, double angle, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        double Pry;
        double Py1;
        double dx2 = (x0 - x) / 2.0;
        double dy2 = (y0 - y) / 2.0;
        angle = Math.toRadians(angle % 360.0);
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double Px1 = x1 * x1;
        double Prx = (rx = Math.abs(rx)) * rx;
        double radiiCheck = Px1 / Prx + (Py1 = y1 * y1) / (Pry = (ry = Math.abs(ry)) * ry);
        if (radiiCheck > 1.0) {
            rx = Math.sqrt(radiiCheck) * rx;
            ry = Math.sqrt(radiiCheck) * ry;
            Prx = rx * rx;
            Pry = ry * ry;
        }
        double sign = largeArcFlag == sweepFlag ? 1.0 : -1.0;
        double sq = (Prx * Pry - Prx * Py1 - Pry * Px1) / (Prx * Py1 + Pry * Px1);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rx * y1 / ry);
        double cy1 = coef * -(ry * x1 / rx);
        double sx2 = (x0 + x) / 2.0;
        double sy2 = (y0 + y) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (-x1 - cx1) / rx;
        double uy = (-y1 - cy1) / ry;
        double vx = (x1 - cx1) / rx;
        double vy = (y1 - cy1) / ry;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p / n));
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = Math.toDegrees(sign * Math.acos(p / n));
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        angleExtent %= 360.0;
        angleStart %= 360.0;
        Arc2D.Double arc = new Arc2D.Double();
        arc.x = cx - rx;
        arc.y = cy - ry;
        arc.width = rx * 2.0;
        arc.height = ry * 2.0;
        arc.start = -angleStart;
        arc.extent = -angleExtent;
        return arc;
    }
}

