/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf;

import com.tridium.pdf.BIPdfWidget;
import com.tridium.pdf.PdfCidFontInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

public class BPdfTable
extends BTable
implements BIPdfWidget {
    public static final Type TYPE = Sys.loadType(BPdfTable.class);
    public static final Log log = Log.getLog((String)"pdf");
    private BFont headerFont;
    private BFont cellFont;
    private double[] colWidths;
    private boolean keepcw = false;
    private BInsets pad = BInsets.make((double)2.0, (double)3.0, (double)1.0, (double)3.0);
    private PdfCidFontInfo headerCidFontInfo = null;
    private PdfCidFontInfo cellCidFontInfo = null;

    public Type getType() {
        return TYPE;
    }

    public BPdfTable() {
        this.headerFont = BFont.make((String)Lexicon.make((String)"pdf").getText("pdf.table.header.font"));
        this.cellFont = BFont.make((String)Lexicon.make((String)"pdf").getText("pdf.table.cell.font"));
        PdfCidFontInfo.CJK cjkFont = PdfCidFontInfo.cjkFontType(Lexicon.make((String)"pdf").getText("pdf.table.cell.font"));
        if (cjkFont != PdfCidFontInfo.CJK.UNKNOWN) {
            this.cellCidFontInfo = new PdfCidFontInfo(Lexicon.make((String)"pdf").getText("pdf.table.cell.font"));
        }
        if ((cjkFont = PdfCidFontInfo.cjkFontType(Lexicon.make((String)"pdf").getText("pdf.table.header.font"))) != PdfCidFontInfo.CJK.UNKNOWN) {
            this.headerCidFontInfo = new PdfCidFontInfo(Lexicon.make((String)"pdf").getText("pdf.table.header.font"));
        }
    }

    @Override
    public void fromWidget(BWidget widget, PdfOp op) {
        BTable w = (BTable)widget;
        this.setLayout(w.getLayout());
        this.setModel(new SourceTableModel(w.getModel(), 0, w.getModel().getRowCount()));
    }

    @Override
    public BWidget getToFit(double w, double h) {
        double ch;
        double pady = this.pad.top + this.pad.bottom;
        double hh = pady + this.headerFont.getHeight();
        if (h < hh + (ch = pady + this.cellFont.getHeight())) {
            return null;
        }
        SourceTableModel model = (SourceTableModel)this.getModel();
        double ph = h - hh;
        int rows = (int)(ph / ch);
        SourceTableModel newModel = new SourceTableModel(model.source, model.start, rows);
        model.start += rows;
        BPdfTable table = new BPdfTable();
        table.setModel(newModel);
        table.colWidths = this.colWidths;
        table.keepcw = true;
        this.keepcw = true;
        return table;
    }

    public void computePreferredSize() {
        int i;
        TableModel model = this.getModel();
        double padx = this.pad.left + this.pad.right;
        double pady = this.pad.top + this.pad.bottom;
        double pw = 0.0;
        if (this.keepcw) {
            for (i = 0; i < this.colWidths.length; ++i) {
                pw += this.colWidths[i];
            }
        } else {
            this.colWidths = new double[model.getColumnCount()];
            for (int rowCount = 0; rowCount < model.getRowCount(); ++rowCount) {
                for (int colCount = 0; colCount < this.colWidths.length; ++colCount) {
                    BImage image;
                    double imageOffset = 0.0;
                    if (colCount == 0 && (image = model.getRowIcon(rowCount)) != null) {
                        try {
                            image.sync();
                            imageOffset = image.getWidth();
                        }
                        catch (Exception e) {
                            imageOffset = 0.0;
                        }
                    }
                    String s = String.valueOf(model.getValueAt(rowCount, colCount));
                    double width = this.cellFont.width(s);
                    if (this.cellCidFontInfo != null && this.cellCidFontInfo.getType() != PdfCidFontInfo.CJK.UNKNOWN) {
                        width = (double)s.length() * this.cellFont.getSize();
                    }
                    this.colWidths[colCount] = Math.max(this.colWidths[colCount], width + padx + imageOffset);
                }
            }
            for (i = 0; i < this.colWidths.length; ++i) {
                String s = model.getColumnName(i);
                double width = this.headerFont.width(s);
                if (this.headerCidFontInfo != null && this.headerCidFontInfo.getType() != PdfCidFontInfo.CJK.UNKNOWN) {
                    width = (double)s.length() * this.headerCidFontInfo.getSize();
                }
                this.colWidths[i] = 10.0 + Math.max(this.colWidths[i], width + padx);
                pw += this.colWidths[i];
            }
        }
        if (log.isTraceOn()) {
            StringBuffer sb = new StringBuffer(" New PDF table column widths: [");
            for (int i2 = 0; i2 < this.colWidths.length; ++i2) {
                if (i2 != 0) {
                    sb.append(",");
                }
                sb.append(this.colWidths[i2]);
            }
            sb.append("]");
            log.trace(sb.toString());
        }
        double ph = this.headerFont.getHeight() + pady;
        this.setPreferredSize(pw, ph += (this.cellFont.getHeight() + pady) * (double)model.getRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int i;
        if (this.colWidths == null) {
            this.computePreferredSize();
        }
        TableModel model = this.getModel();
        double w = this.getWidth();
        double h = this.getHeight();
        double xo = 0.0;
        double yo = 0.0;
        double headerAscent = this.headerFont.getAscent();
        double headerHeight = this.headerFont.getHeight();
        double cellAscent = this.cellFont.getAscent();
        double cellHeight = this.cellFont.getHeight();
        double pady = this.pad.top + this.pad.bottom;
        double[] rowWidth = this.colWidths;
        double pw = this.getPreferredWidth();
        if (pw > w) {
            rowWidth = new double[this.colWidths.length];
            double temp = 0.0;
            for (int i2 = 0; i2 < this.colWidths.length - 1; ++i2) {
                rowWidth[i2] = this.colWidths[i2] / pw * w;
                temp += rowWidth[i2];
            }
            rowWidth[rowWidth.length - 1] = w - temp;
        }
        g.setBrush(BColor.white);
        g.fillRect(0.0, 0.0, w, h);
        g.setBrush(BColor.make((int)0xCCCCCC));
        g.fillRect(0.0, 0.0, w, headerHeight + pady);
        g.setFont(this.headerFont);
        g.setBrush(BColor.black);
        for (i = 0; i < rowWidth.length; ++i) {
            try {
                g.push();
                g.clip(xo + this.pad.left, yo + this.pad.top, rowWidth[i] - this.pad.left - this.pad.right, headerHeight);
                g.drawString(model.getColumnName(i), xo + this.pad.left, yo + this.pad.top + headerAscent);
            }
            finally {
                g.pop();
            }
            xo += rowWidth[i];
        }
        yo += headerHeight + pady;
        g.setFont(this.cellFont);
        for (i = 0; i < model.getRowCount(); ++i) {
            xo = 0.0;
            if (i % 2 > 0) {
                g.setBrush(BBrush.make((String)"#eee"));
                g.fillRect(0.0, yo, w, cellHeight + pady);
            }
            g.setBrush(BColor.black);
            g.strokeLine(0.0, yo, w, yo);
            for (int j = 0; j < rowWidth.length; ++j) {
                double imageOffset = 0.0;
                try {
                    BImage image;
                    g.push();
                    if (j == 0 && (image = model.getRowIcon(i)) != null) {
                        g.drawImage(image, xo + this.pad.left, yo + this.pad.top);
                        imageOffset = image.getWidth();
                    }
                    g.clip(xo + this.pad.left, yo + this.pad.top, rowWidth[j] - this.pad.left - this.pad.right, cellHeight);
                    g.drawString(String.valueOf(model.getValueAt(i, j)), xo + this.pad.left + imageOffset, yo + this.pad.top + cellAscent);
                }
                finally {
                    g.pop();
                }
                xo += rowWidth[j];
            }
            yo += cellHeight + pady;
        }
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w, h);
    }

    public class SourceTableModel
    extends TableModel {
        TableModel source;
        int start = 0;
        int rows = 0;

        public SourceTableModel(TableModel source, int start, int rows) {
            this.source = source;
            this.start = start;
            this.rows = rows;
        }

        public int getColumnCount() {
            return this.source.getColumnCount();
        }

        public String getColumnName(int col) {
            return this.source.getColumnName(col);
        }

        public BHalign getColumnAlignment(int col) {
            return this.source.getColumnAlignment(col);
        }

        public int getRowCount() {
            return Math.min(this.rows, this.source.getRowCount() - this.start);
        }

        public BImage getRowIcon(int row) {
            return this.source.getRowIcon(this.start + row);
        }

        public Object getValueAt(int row, int col) {
            return this.source.getValueAt(this.start + row, col);
        }
    }
}

