/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf;

import com.tridium.pdf.BIPdfWidget;
import com.tridium.pdf.PdfUtil;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BScrollPane;

public class BPdfScrollPane
extends BScrollPane
implements BIPdfWidget {
    public static final Type TYPE = Sys.loadType(BPdfScrollPane.class);

    public Type getType() {
        return TYPE;
    }

    @Override
    public void fromWidget(BWidget widget, PdfOp op) {
        BScrollPane p = (BScrollPane)widget;
        BWidget w = PdfUtil.getWidget(p.getContent(), op);
        if (w != null) {
            this.setContent(w);
        }
    }

    public void doLayout(BWidget[] kids) {
        BWidget content = this.getContent();
        double w = this.getWidth();
        double h = this.getHeight();
        double pw = content.getPreferredWidth();
        double ph = content.getPreferredHeight();
        if (pw < w && ph < h || w == 0.0 || h == 0.0) {
            content.setBounds(0.0, 0.0, w, h);
        } else {
            double s = 1.0 / Math.max(pw / w, ph / h);
            content.setBounds(0.0, 0.0, w /= s, h /= s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        BWidget content = this.getContent();
        content.computePreferredSize();
        double w = this.getWidth();
        double h = this.getHeight();
        double pw = content.getPreferredWidth();
        double ph = content.getPreferredHeight();
        if (pw < w && ph < h || w == 0.0 || h == 0.0) {
            super.paint(g);
        } else {
            g.push();
            try {
                double s = 1.0 / Math.max(pw / w, ph / h);
                g.transform(BTransform.makeScale((double)s, (double)s));
                content.paint(g);
            }
            finally {
                g.pop();
            }
        }
    }
}

