/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf;

import com.tridium.pdf.BIPdfWidget;
import com.tridium.pdf.PdfUtil;
import com.tridium.ui.util.LayoutUtil;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.px.BPxInclude;

public class BPdfCanvasPane
extends BCanvasPane
implements BIPdfWidget {
    public static final Type TYPE = Sys.loadType(BPdfCanvasPane.class);

    public Type getType() {
        return TYPE;
    }

    @Override
    public void fromWidget(BWidget widget, PdfOp op) {
        SlotCursor c = widget.getProperties();
        while (c.next()) {
            BCanvasPane canvasPane;
            Property prop = c.property();
            if (prop.isFrozen()) {
                this.set(prop.getName(), widget.get(prop));
            }
            if (!prop.equals(BCanvasPane.scale) || !(widget instanceof BCanvasPane) || LayoutUtil.getParentScrollPane((BWidget)(canvasPane = (BCanvasPane)widget)) == null) continue;
            this.set(BCanvasPane.scale, (BValue)BScaleMode.none);
        }
        BWidget[] kids = widget.getChildWidgets();
        BOrd baseOrd = BOrd.NULL;
        for (int i = 0; i < kids.length; ++i) {
            BWidget w = null;
            w = PdfUtil.getWidget(kids[i], op);
            if (null == w) {
                try {
                    w = (BWidget)kids[i].newCopy();
                }
                catch (Exception e) {
                    PdfUtil.log.log(Level.WARNING, "Skipping rendering of widget type " + kids[i].getType(), e);
                    continue;
                }
            }
            if (w instanceof BPxInclude) {
                baseOrd = ((BPxInclude)kids[i]).getBaseOrd();
            }
            BPdfCanvasPane.fix(w, baseOrd);
            this.add(null, (BValue)w);
        }
    }

    public static void fix(BWidget w, BOrd baseOrd) {
        if (w instanceof BButton && !w.getEnabled()) {
            w.setEnabled(true);
        } else if (w instanceof BCanvasPane) {
            ((BCanvasPane)w).overrideClip = true;
        } else if (w instanceof BPxInclude) {
            ((BPxInclude)w).setBaseOrd(baseOrd);
            w.computePreferredSize();
        }
        BWidget[] kids = w.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            BPdfCanvasPane.fix(kids[i], baseOrd);
        }
    }
}

