/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf;

import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.units.BUnit;

public class BITableToPdf
extends BPdfExporter {
    public static final Type TYPE = Sys.loadType(BITableToPdf.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void export(PdfOp op) throws Exception {
        BIRandomAccessTable t = Tables.slurp((BITable)((BITable)op.get()));
        BTable table = new BTable();
        table.setModel((TableModel)new DirectModel(t, op));
        BWidgetToPdf exporter = new BWidgetToPdf();
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        exporter.renderDocument((BWidget)table, doc, op);
    }

    class DirectModel
    extends TableModel {
        BIRandomAccessTable<?> table;
        ColumnList cols;
        PdfOp op;

        public DirectModel(BIRandomAccessTable<?> table, PdfOp op) {
            this.table = table;
            this.op = op;
            this.cols = table.getColumns();
        }

        public int getRowCount() {
            return this.table.size();
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public String getColumnName(int col) {
            Column column = this.cols.get(col);
            BFacets facets = column.getFacets();
            String displayName = column.getDisplayName(null);
            BUnit units = null;
            BObject sName = null;
            if (null != facets) {
                units = (BUnit)facets.get("units");
                sName = facets.get("SERIES_NAME");
            }
            if (null != sName) {
                displayName = sName.toString((Context)this.op);
            }
            if (null != units && units != BUnit.NULL) {
                displayName = displayName + " (" + units.toString((Context)this.op) + ")";
            }
            return displayName;
        }

        public Object getValueAt(int row, int col) {
            Column column = this.cols.get(col);
            BFacets colFacets = column.getFacets();
            BasicContext bcx = new BasicContext((Context)this.op, colFacets);
            return this.table.get(row).cell(column).toString((Context)bcx);
        }
    }
}

