/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.util.BNiagaraRemoteQueryFilter;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDescriptor;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDeviceExt;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import java.util.List;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BNiagaraSystemIndexImport
extends BNiagaraSystemIndexDescriptor {
    public static final Type TYPE = Sys.loadType(BNiagaraSystemIndexImport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    private volatile String lastLimitExceededMsg;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        try {
            this.checkLicenseForIndexing(null);
        }
        catch (Exception e) {
            this.executeFail(e);
            return null;
        }
        return super.postExecute(action, arg, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeIndex(SystemIndexLog log, Context cx) throws Exception {
        int limit = this.checkLicenseForIndexing(log);
        BFoxClientConnection connection = ((BNiagaraStation)this.getDevice()).getClientConnection();
        try {
            BNiagaraSystemIndexDeviceExt.getCategoryService(true);
            BNiagaraSystemIndexDeviceExt.getNiagaraNetwork(true);
            connection.engageNoRetry((BFoxClientConnection.Interest)this);
            BDataChannel channel = (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
            BNiagaraRemoteQueryFilter[] queryFilters = new BNiagaraRemoteQueryFilter[]{BNiagaraRemoteQueryFilter.make((boolean)true, (boolean)((BNiagaraSystemIndexDeviceExt)this.getDeviceExt()).getReceiveExportedIndexFromRemoteStation())};
            List entitiesList = channel.resolveEntitiesToList(this.getOperationalIndexQueries(), 0, -1, (BIPreQueryValidator[])queryFilters, (BIPostQueryFilter[])queryFilters);
            int size = limit != Integer.MAX_VALUE ? entitiesList.size() : -1;
            String stationNameStr = ((BINiagaraStation)this.getDevice()).getStationName();
            connection.disengage((BFoxClientConnection.Interest)this);
            BSystemIndexer.systemIndexToSystemDb((String)stationNameStr, BNiagaraSystemIndexDeviceExt.toEntityStream(stationNameStr, entitiesList, size, limit), (SystemIndexLog)log, (Context)BNiagaraSystemIndexDeviceExt.SystemIndexContextHolder.INDEX_CONTEXT);
            if (size > limit) {
                String[] args = new String[]{stationNameStr, Integer.toString(size), Integer.toString(limit)};
                this.lastLimitExceededMsg = Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args);
                this.setFaultCause(this.lastLimitExceededMsg);
                if (log.isLoggingEnabled()) {
                    log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                }
            } else {
                this.lastLimitExceededMsg = null;
                this.setFaultCause("");
            }
        }
        finally {
            if (connection != null && connection.isEngaged((BFoxClientConnection.Interest)this)) {
                connection.disengage((BFoxClientConnection.Interest)this);
            }
        }
    }

    public void executeOk() {
        String oldFaultCause = this.getFaultCause();
        super.executeOk();
        if (this.lastLimitExceededMsg != null && oldFaultCause.equals(this.lastLimitExceededMsg)) {
            this.setFaultCause(oldFaultCause);
        }
    }

    protected String getIndexDescription(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexImport", new Object[]{this.getDevice().getName()});
    }

    public BIcon getIcon() {
        return icon;
    }

    private int checkLicenseForIndexing(SystemIndexLog log) throws Exception {
        BSystemIndexer.checkServicesOperational((SystemIndexLog)log);
        return ((BNiagaraSystemIndexDeviceExt)this.getDeviceExt()).checkLicenseForIndexing();
    }
}

