/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import javax.baja.gx.Graphics;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;

public class BTextOutputPane
extends BTextEditorPane {
    public static final Type TYPE = Sys.loadType(BTextOutputPane.class);
    private boolean autoScroll = false;
    private Object monitor = new Object();
    private CharArrayWriter outputA = new CharArrayWriter();
    private CharArrayWriter outputB = new CharArrayWriter();
    private CharArrayWriter output = this.outputA;
    private TextModelWriter textModelWriter = new TextModelWriter();
    private long maxSize = 32768L;
    private long currentSize = 0L;
    private boolean toEnd = false;
    private long lastUpdate = 0L;
    private AutoScrollThread autoScrollThread = null;

    public Type getType() {
        return TYPE;
    }

    public BTextOutputPane(byte[] buf, int offset, int len) {
        this();
        this.append(buf, offset, len);
    }

    public BTextOutputPane(Throwable t) {
        this();
        this.append(t);
    }

    public BTextOutputPane(String text) {
        this();
        this.append(text);
    }

    public BTextOutputPane() {
        this(20, 80);
    }

    public BTextOutputPane(int rows, int cols, Throwable t) {
        this(rows, cols);
        this.append(t);
    }

    public BTextOutputPane(int rows, int cols, String text) {
        this(rows, cols);
        this.append(text);
    }

    public BTextOutputPane(int rows, int cols) {
        super("", rows, cols, false);
    }

    public void started() throws Exception {
        super.started();
        if (this.autoScrollThread != null) {
            this.autoScrollThread.terminate();
        }
        this.autoScrollThread = new AutoScrollThread();
        this.autoScrollThread.start();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.autoScrollThread != null) {
            this.autoScrollThread.terminate();
        }
        this.autoScrollThread = null;
    }

    public void clear() {
        this.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = this.monitor;
        synchronized (object) {
            super.setText(text);
            this.currentSize = text.length();
        }
    }

    public void append(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(out));
        this.append(out.toString());
    }

    public void append(byte[] buf, int offset, int len) {
        this.append(new String(buf, offset, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTextOutputPane append(String text) {
        Object object = this.monitor;
        synchronized (object) {
            this.output.write(text, 0, text.length());
        }
        this.repaint();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        boolean haveData;
        CharArrayWriter poutput = null;
        boolean bl = haveData = this.output.size() > 0;
        if (haveData) {
            this.toEnd = true;
            Object object = this.monitor;
            synchronized (object) {
                if (this.output == this.outputA) {
                    this.output = this.outputB;
                    poutput = this.outputA;
                } else {
                    this.output = this.outputA;
                    poutput = this.outputB;
                }
            }
            try {
                poutput.writeTo(this.textModelWriter);
                poutput.reset();
                this.currentSize = this.getEditor().getModel().getTextLength();
                if (this.currentSize > this.maxSize) {
                    int linePos = 0;
                    while ((double)this.currentSize > (double)this.maxSize * 0.95) {
                        Line line = this.getEditor().getModel().getLine(linePos);
                        this.currentSize -= (long)line.getColumnCount();
                        ++linePos;
                    }
                    this.getEditor().getModel().remove(new Position(0, 0), new Position(linePos, 0));
                }
            }
            catch (Exception e) {
                System.out.println("*** exception adding/removing data:");
                e.printStackTrace();
            }
            this.lastUpdate = Clock.ticks();
        }
        if (this.autoScroll && this.toEnd) {
            this.getEditor().scrollToVisible(this.getEditor().getModel().getEndPosition());
            this.toEnd = false;
        }
        super.paint(g);
    }

    public void scrollToEnd() {
        this.getEditor().moveCaretPosition(this.getEditor().getModel().getEndPosition());
        this.toEnd = true;
        this.repaint();
    }

    public void setOutputBufferSize(int size) {
        this.maxSize = size;
    }

    public void setUseAutoScroll(boolean value) {
        this.autoScroll = value;
    }

    public boolean useAutoScroll() {
        return this.autoScroll;
    }

    public class AutoScrollThread
    extends Thread {
        private boolean running;
        private boolean dirty;

        public AutoScrollThread() {
            super("tAutoScroll");
            this.running = true;
            this.dirty = true;
        }

        @Override
        public void run() {
            while (this.running) {
                if (Clock.ticks() - BTextOutputPane.this.lastUpdate > 500L) {
                    if (this.dirty) {
                        BTextOutputPane.this.scrollToEnd();
                        this.dirty = false;
                    }
                } else {
                    this.dirty = true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }

        public void terminate() {
            this.running = false;
        }
    }

    private class TextModelWriter
    extends Writer {
        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            BTextOutputPane.this.getEditor().getModel().insert(BTextOutputPane.this.getEditor().getModel().getEndPosition(), cbuf, off, len);
        }
    }
}

