/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.pathbar;

import com.tridium.sys.station.BStationScheme;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.pathbar.BStationPA;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.agent.AgentFilter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNSpacePA
extends BPathBarAgent {
    public static final Type TYPE = Sys.loadType(BNSpacePA.class);
    static final AgentFilter pathBarAgentFilter = AgentFilter.is((Type)BPathBarAgent.TYPE);

    public Type getType() {
        return TYPE;
    }

    public BPathBarAgent[] explode() {
        String body = this.query().getBody();
        if (body.isEmpty()) {
            BStationPA stationPA = new BStationPA();
            stationPA.setAgentOrd(this.base(), BStationScheme.INSTANCE.parse(""));
            return new BPathBarAgent[]{stationPA};
        }
        BComponentSpace space = (BComponentSpace)BOrd.make((BOrd)this.base(), (OrdQuery)this.query()).get();
        BOrd ordInSession = space.getOrdInSession();
        OrdQuery[] queries = ordInSession.parse();
        if (queries.length == 1 && queries[0].getScheme().equals(BStationScheme.INSTANCE.getId()) && queries[0].getBody().isEmpty()) {
            BStationPA stationPA = new BStationPA();
            stationPA.setAgentOrd(this.base(), BStationScheme.INSTANCE.parse(""));
            return new BPathBarAgent[]{stationPA};
        }
        ordInSession = space.getNavOrd().relativizeToSession();
        queries = ordInSession.parse();
        BOrd sessionOrd = space.getSession().getNavOrd();
        ArrayList agents = new ArrayList();
        for (int i = 0; i < queries.length; ++i) {
            BOrd base = i == 0 ? sessionOrd : BOrd.make((BOrd)sessionOrd, (BOrd)ordInSession.getSubOrd(0, i));
            BOrdScheme scheme = BOrdScheme.lookup((String)queries[i].getScheme());
            BPathBarAgent agent = (BPathBarAgent)scheme.getAgents().filter(pathBarAgentFilter).getDefault().getInstance();
            agent.setAgentOrd(base, queries[i]);
            Collections.addAll(agents, agent.explode());
        }
        return agents.toArray(new BPathBarAgent[agents.size()]);
    }
}

