/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.history;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryImport;
import com.tridium.nd.history.BNiagaraSystemHistoryImport;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.ui.history.BNiagaraHistoryImportManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.HistoryLearn;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class NiagaraImportLearn
extends HistoryLearn {
    static final Logger LOG = Logger.getLogger("niagaraDriver");
    static Lexicon lex = Lexicon.make(BNiagaraHistoryImportManager.class);
    static String lexRemote = lex.getText("historyImportManager.remote");
    static final BImage historyIcon = BImage.make((BIcon)BIcon.std((String)"history.png"));
    static final BImage deviceIcon = BImage.make((BIcon)BIcon.std((String)"device.png"));
    BNiagaraStation station;

    public NiagaraImportLearn(BHistoryImportManager manager) {
        super((BArchiveManager)manager);
    }

    static BNiagaraStation getStation(BComponent target) {
        for (BComponent parent = target; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BNiagaraStation)) continue;
            return (BNiagaraStation)parent;
        }
        return null;
    }

    public void load(BComponent target) {
        super.load(target);
        this.station = NiagaraImportLearn.getStation(target);
    }

    public Object[] getDiscovery(BComponent target) {
        String targetStationName = ((BFoxSession)target.getSession()).getStationName();
        BFoxSession session = (BFoxSession)this.station.getSession();
        BITable remoteHistories = null;
        BOrd ord = BOrd.make((String)"history:|bql:select id.encodeToString, systemTags.encodeToString from sys.histories order by id.encodeToString asc");
        BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
        try {
            remoteHistories = (BITable)channel.discover((BDeviceExt)this.station.getHistories(), ord);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not discover remote histories", e);
        }
        if (remoteHistories == null) {
            return new Object[0];
        }
        HashMap<String, DiscoveredHistoryDevice> deviceMap = new HashMap<String, DiscoveredHistoryDevice>();
        try (TableCursor c = remoteHistories.cursor();){
            ColumnList cols = remoteHistories.getColumns();
            while (c.next()) {
                try {
                    BHistoryId id = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(c.cell(cols.get(0)).toString());
                    BNameList systemTags = (BNameList)BNameList.DEFAULT.decodeFromString(c.cell(cols.get(1)).toString());
                    String deviceName = id.getDeviceName();
                    if (deviceName.equals(targetStationName)) continue;
                    DiscoveredHistoryDevice dev = (DiscoveredHistoryDevice)deviceMap.get(deviceName);
                    if (dev == null) {
                        dev = new DiscoveredHistoryDevice(deviceName);
                        deviceMap.put(deviceName, dev);
                    }
                    dev.addDiscoveredHistory(new DiscoveredHistory(dev, id, systemTags));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Encountered error while processing discovered history " + c.get(), e);
                }
            }
        }
        int size = deviceMap.size();
        if (size < 1) {
            return new Object[0];
        }
        Object[] devs = deviceMap.values().toArray(new DiscoveredHistoryDevice[size]);
        if (devs != null) {
            SortUtil.sort((Object[])devs);
        }
        return devs;
    }

    public MgrTypeInfo[] toTypes(Object discovery) {
        if (discovery instanceof DiscoveredHistory) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNiagaraHistoryImport.TYPE)};
        }
        return super.toTypes(discovery);
    }

    public boolean isExisting(Object discovery, BComponent component) {
        if (!(discovery instanceof DiscoveredHistory)) {
            return false;
        }
        if (!(component instanceof BHistoryImport)) {
            return false;
        }
        DiscoveredHistory h = (DiscoveredHistory)discovery;
        if (component instanceof BNiagaraSystemHistoryImport) {
            BHistoryConfig config = new BHistoryConfig();
            config.setId(h.id);
            config.setSystemTags(h.systemTags);
            String list = ((BNiagaraSystemHistoryImport)component).getSystemTagPatterns();
            if (list == null || list.length() < 1) {
                return false;
            }
            PatternFilter[] patterns = PatternFilter.parseList((String)list);
            return patterns.length > 0 && BLocalHistoryDatabase.acceptSystemTags((BHistoryConfig)config, (PatternFilter[])patterns);
        }
        BHistoryId id = h.id;
        BHistoryImport imp = (BHistoryImport)component;
        BHistoryId impId = imp.getHistoryId();
        return id.equals((Object)impId) || impId.equals((Object)id.toShorthand(this.station.getStationName()));
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] cols = super.makeColumns();
        int size = cols != null ? cols.length : 0;
        MgrColumn[] newCols = new MgrColumn[size + 1];
        for (int i = 0; i < size; ++i) {
            newCols[i] = cols[i];
        }
        newCols[size] = new SystemTagColumn();
        return newCols;
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        DiscoveredHistory history = (DiscoveredHistory)discovery;
        BHistoryId shorthandId = history.id.toShorthand(this.station.getStationName());
        String name = shorthandId.toString();
        name = name.startsWith("^", 0) ? lexRemote + "_" + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)shorthandId);
    }

    public BImage getIcon(Object discovery) {
        if (discovery instanceof DiscoveredHistory) {
            return historyIcon;
        }
        if (discovery instanceof DiscoveredHistoryDevice) {
            return deviceIcon;
        }
        return null;
    }

    public boolean isGroup(Object discovery) {
        return discovery instanceof DiscoveredHistoryDevice;
    }

    public Object[] getChildren(Object discovery) {
        if (discovery instanceof DiscoveredHistoryDevice) {
            return ((DiscoveredHistoryDevice)discovery).histories.toArray();
        }
        return super.getChildren(discovery);
    }

    public boolean isMatchable(Object discovery, BComponent database) {
        if (discovery instanceof DiscoveredHistoryDevice) {
            return false;
        }
        return discovery instanceof DiscoveredHistory && database instanceof BArchiveDescriptor;
    }

    static class DiscoveredHistory {
        DiscoveredHistoryDevice parentDevice;
        BHistoryId id;
        BNameList systemTags;

        DiscoveredHistory(DiscoveredHistoryDevice parentDevice, BHistoryId id, BNameList systemTags) {
            this.parentDevice = parentDevice;
            this.id = id;
            this.systemTags = systemTags;
        }

        public String toString() {
            return this.id.getHistoryDisplayName();
        }
    }

    static class DiscoveredHistoryDevice
    implements Comparable<DiscoveredHistoryDevice> {
        String deviceName;
        ArrayList<DiscoveredHistory> histories = new ArrayList();

        DiscoveredHistoryDevice(String name) {
            this.deviceName = name;
        }

        public void addDiscoveredHistory(DiscoveredHistory history) {
            this.histories.add(history);
        }

        @Override
        public int compareTo(DiscoveredHistoryDevice o) {
            return this.deviceName.compareTo(o.deviceName);
        }

        public String toString() {
            return this.deviceName;
        }
    }

    static class SystemTagColumn
    extends MgrColumn {
        SystemTagColumn(String name) {
            super(name, 1);
        }

        SystemTagColumn() {
            this(HistoryLearn.histLex.getText("historyExtManager.systemTags"));
        }

        public Object get(Object row) {
            if (row instanceof DiscoveredHistory) {
                return ((DiscoveredHistory)row).systemTags;
            }
            if (row instanceof BIHistory) {
                return ((BIHistory)row).getConfig().getSystemTags();
            }
            return "";
        }
    }
}

