/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.ui.BNiagaraPointLearnBase;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceExt;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

public abstract class NiagaraLearn
extends MgrLearn {
    public static final int UNESCAPE = 1;
    static Lexicon bajaLex = Lexicon.make((String)"baja");
    BComponent target;
    FoxSessionSupport sessionSupport;
    BOrd bqlQuery;
    BITable<?> lastLearn;

    public NiagaraLearn(BAbstractManager manager) {
        super(manager);
    }

    public BComponent getTarget() {
        return this.target;
    }

    protected BWidget makeJobBar() {
        return null;
    }

    public void load(BComponent target) {
        super.load(target);
        this.target = target;
        BISession session = target.getSession();
        this.sessionSupport = session instanceof BFoxSession ? new FoxSessionSupport(this.getManager(), (BFoxSession)session) : new FoxSessionSupport(this.getManager(), null);
    }

    public BFoxSession connect(BNiagaraStation s) {
        s.lease(1);
        return this.sessionSupport.connect(s.getStationName(), s.getAddress(), s.getClientConnection().getPort(), s.getClientConnection().getUseFoxs());
    }

    public BFoxSession connect(BLearnStation s, boolean useHostName) {
        String host = useHostName ? s.getHostName() : s.getHostAddress();
        boolean useFoxs = false;
        if (s.getScheme().equalsIgnoreCase("foxs")) {
            useFoxs = true;
        }
        return this.sessionSupport.connect(s.getStationName(), BOrd.make((String)("ip:" + host)), s.getFoxPort(), useFoxs);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs) {
        return this.sessionSupport.connect(stationName, host, foxPort, useFoxs);
    }

    public void bqlDiscover(BNiagaraStation station, BTypeSpec filterType) throws Exception {
        String stationName = station.getStationName();
        BFoxSession session = (BFoxSession)station.getSession();
        if (this.bqlQuery == null) {
            String projection = this.getBqlProjection();
            this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + projection + " from " + filterType));
        }
        BOrd findBasesOrd = BOrd.make((String)"station:|slot:/|bql:select name, navDisplayName, navOrd, icon.encodeToString from driver:DeviceNetwork, driver:DeviceFolder, driver:Device");
        BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
        BITable networksAndDevices = (BITable)channel.discover((BDeviceExt)station.getPoints(), findBasesOrd);
        ColumnList cols = networksAndDevices.getColumns();
        BIcon baseIcon = new BStation().getNavIcon();
        BOrd baseOrd = BOrd.make((String)"station:|slot:/");
        String baseDisplayName = bajaLex.get("nav.station");
        BNiagaraPointLearnBase root = new BNiagaraPointLearnBase("config", baseDisplayName, baseOrd, baseIcon);
        BNiagaraPointLearnBase base = new BNiagaraPointLearnBase("config", baseDisplayName, baseOrd, baseIcon);
        root.addNavChild((BINavNode)base);
        try (TableCursor c = networksAndDevices.cursor();){
            Array ancestorBases = new Array(BNiagaraPointLearnBase.class);
            ancestorBases.push((Object)base);
            while (c.next()) {
                String name = c.cell(cols.get(0)).toString();
                String navName = c.cell(cols.get(1)).toString();
                String navOrdString = c.cell(cols.get(2)).toString();
                BOrd navOrd = BOrd.make((String)navOrdString).relativizeToSession();
                navOrdString = navOrd.toString();
                BIcon navIcon = BIcon.make((String)c.cell(cols.get(3)).toString());
                BNiagaraPointLearnBase currentBase = new BNiagaraPointLearnBase(name, navName, navOrd, navIcon);
                BNiagaraPointLearnBase ancestorBase = (BNiagaraPointLearnBase)((Object)ancestorBases.peek());
                String ancestorOrdStr = ancestorBase.getNavOrd().toString();
                if (!ancestorOrdStr.endsWith("/")) {
                    ancestorOrdStr = ancestorOrdStr + "/";
                }
                while (ancestorBase != null && !navOrdString.startsWith(ancestorOrdStr)) {
                    try {
                        ancestorBases.pop();
                        ancestorBase = (BNiagaraPointLearnBase)((Object)ancestorBases.peek());
                        ancestorOrdStr = ancestorBase.getNavOrd().toString();
                        if (ancestorOrdStr.endsWith("/")) continue;
                        ancestorOrdStr = ancestorOrdStr + "/";
                    }
                    catch (Exception e) {
                        ancestorBase = null;
                    }
                }
                if (ancestorBase == null) {
                    ancestorBase = base;
                    if (ancestorBases.size() < 1) {
                        ancestorBases.push((Object)base);
                    }
                }
                if (ancestorBase.getNavChild(currentBase.getNavName()) != null) {
                    currentBase = new BNiagaraPointLearnBase(name + " (" + navOrdString + ")", navName, navOrd, navIcon);
                }
                ancestorBase.addNavChild((BINavNode)currentBase);
                ancestorBases.push((Object)currentBase);
            }
        }
        BBqlQueryBuilder builder = new BBqlQueryBuilder((BObject)root, this.bqlQuery, false);
        BOrd bql = builder.open((BWidget)this.getManager());
        if (bql == null) {
            return;
        }
        this.bqlQuery = bql.relativizeToSession();
        BITable table = (BITable)channel.discover((BDeviceExt)station.getPoints(), this.bqlQuery);
        this.updateTable(table);
    }

    public String getBqlProjection() {
        StringBuffer s = new StringBuffer();
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            Column col = (Column)cols[i];
            s.append(col.projection);
        }
        s.append(",icon.encodeToString");
        return s.toString();
    }

    public BImage getIcon(Object node) {
        return ((Node)node).getIcon();
    }

    public boolean hasChildren(Object node) {
        return ((Node)node).hasChildren();
    }

    public Object[] getChildren(Object node) {
        return ((Node)node).getChildren();
    }

    public void updateTable(BITable<?> table) {
        this.lastLearn = table;
        ArrayList<Node> roots = new ArrayList<Node>(32);
        try (TableCursor c = table.cursor();){
            while (c.next()) {
                Node n = this.makeNode();
                n.update(c.row());
                roots.add(n);
            }
        }
        this.updateRoots(roots.toArray(new Node[roots.size()]));
    }

    protected Node makeNode() {
        return new Node();
    }

    public static class Node {
        public BImage icon;
        public BObject[] cells;

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn col) {
            return col.get((Object)this);
        }

        public boolean hasChildren() {
            return false;
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public void update(Row<?> row) {
            ColumnList cols = row.getTable().getColumns();
            this.cells = new BObject[cols.size() - 1];
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c] = (BObject)row.cell(cols.get(c)).as(BObject.class);
            }
            this.icon = BImage.make((String)row.cell(cols.get(cols.size() - 1)).toString());
        }
    }

    public static class Column
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;
        int special;

        public Column(String displayName, String projection) {
            this(displayName, projection, 0, 0);
        }

        public Column(String displayName, String projection, int flags) {
            this(displayName, projection, flags, 0);
        }

        public Column(String displayName, String projection, int flags, int special) {
            super(displayName, flags);
            this.projection = projection;
            this.special = special;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] cols = this.getManager().getLearn().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not in manager.getDiscoveryColumns()");
                }
            }
            return this.colIndex;
        }

        public Object get(Object discovery) {
            BObject x = ((Node)discovery).cells[this.getColumnIndex()];
            if ((this.special & 1) != 0) {
                return SlotPath.unescape((String)x.toString());
            }
            return x;
        }
    }
}

